/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFDataType;
import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFFieldDefinition;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfieldDefinition;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Iterator;

public class View8211 {
    protected boolean bFSPTHack = false;
    protected String pszFilename = null;

    public View8211(String filename, boolean fspt_repeating) {
        this.pszFilename = filename;
        this.bFSPTHack = fspt_repeating;
        this.view();
    }

    protected void view() {
        try {
            DDFRecord poRecord;
            DDFModule oModule = new DDFModule(this.pszFilename);
            if (this.bFSPTHack) {
                DDFFieldDefinition poFSPT = oModule.findFieldDefn("FSPT");
                if (poFSPT == null) {
                    Debug.error("View8211: unable to find FSPT field to set repeating flag.");
                } else {
                    poFSPT.setRepeating(true);
                }
            }
            int iRecord = 1;
            while ((poRecord = oModule.readRecord()) != null) {
                Debug.output("Record " + iRecord++ + "(" + poRecord.getDataSize() + " bytes)");
                Iterator it = poRecord.iterator();
                while (it != null && it.hasNext()) {
                    this.viewRecordField((DDFField)it.next());
                }
            }
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    protected void viewRecordField(DDFField poField) {
        DDFFieldDefinition poFieldDefn = poField.getFieldDefn();
        Debug.output("    Field " + poFieldDefn.getName() + ": " + poFieldDefn.getDescription());
        byte[] pachFieldData = poField.getData();
        int nBytesRemaining = poField.getDataSize();
        for (int iRepeat = 0; iRepeat < poField.getRepeatCount(); ++iRepeat) {
            if (iRepeat > 0) {
                Debug.output("Repeating (" + iRepeat + ")...");
            }
            for (int iSF = 0; iSF < poFieldDefn.getSubfieldCount(); ++iSF) {
                DDFSubfieldDefinition poSFDefn = poFieldDefn.getSubfieldDefn(iSF);
                int nBytesConsumed = this.viewSubfield(poSFDefn, pachFieldData, nBytesRemaining);
                nBytesRemaining -= nBytesConsumed;
                byte[] tempData = new byte[pachFieldData.length - nBytesConsumed];
                System.arraycopy(pachFieldData, nBytesConsumed, tempData, 0, tempData.length);
                pachFieldData = tempData;
            }
        }
    }

    protected int viewSubfield(DDFSubfieldDefinition poSFDefn, byte[] pachFieldData, int nBytesRemaining) {
        MutableInt nBytesConsumed = new MutableInt();
        DDFDataType ddfdt = poSFDefn.getType();
        if (ddfdt == DDFDataType.DDFInt) {
            Debug.output("        " + poSFDefn.getName() + " = " + poSFDefn.extractIntData(pachFieldData, nBytesRemaining, nBytesConsumed));
        } else if (ddfdt == DDFDataType.DDFFloat) {
            Debug.output("        " + poSFDefn.getName() + " = " + poSFDefn.extractFloatData(pachFieldData, nBytesRemaining, nBytesConsumed));
        } else if (ddfdt == DDFDataType.DDFString) {
            Debug.output("        " + poSFDefn.getName() + " = " + poSFDefn.extractStringData(pachFieldData, nBytesRemaining, nBytesConsumed));
        } else if (ddfdt == DDFDataType.DDFBinaryString) {
            poSFDefn.extractStringData(pachFieldData, nBytesRemaining, nBytesConsumed);
            Debug.output("        " + poSFDefn.getName());
        }
        return nBytesConsumed.value;
    }

    public static void main(String[] argv) {
        Debug.init();
        String pszFilename = null;
        boolean bFSPTHack = false;
        for (int iArg = 0; iArg < argv.length; ++iArg) {
            if (argv[iArg].equals("-fspt_repeating")) {
                bFSPTHack = true;
                continue;
            }
            pszFilename = argv[iArg];
        }
        if (pszFilename == null) {
            Debug.output("Usage: View8211 filename\n");
            System.exit(1);
        }
        new View8211(pszFilename, bFSPTHack);
    }
}

