/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.dted.DTEDFrameACC;
import com.bbn.openmap.dataAccess.dted.DTEDFrameDSI;
import com.bbn.openmap.dataAccess.dted.DTEDFrameUHL;
import com.bbn.openmap.dataAccess.dted.OMDTEDGrid;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.Closable;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.grid.OMGridData;
import com.bbn.openmap.omGraphics.grid.SlopeGenerator;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrame
implements Closable {
    public static final int UHL_SIZE = 80;
    public static final int DSI_SIZE = 648;
    public static final int ACC_SIZE = 2700;
    public static final int ACC_SR_SIZE = 284;
    protected BinaryFile binFile;
    protected String path;
    protected short[][] elevations;
    public DTEDFrameDSI dsi;
    public DTEDFrameUHL uhl;
    public DTEDFrameACC acc;
    public boolean frame_is_valid = false;

    public DTEDFrame(String filePath) {
        this(filePath, false);
    }

    public DTEDFrame(String filePath, boolean readWholeFile) {
        try {
            this.binFile = new BinaryBufferedFile(filePath);
            this.read(this.binFile, readWholeFile);
            if (readWholeFile) {
                this.close(true);
            } else {
                BinaryFile.addClosable(this);
            }
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrame: file " + filePath + " not found");
        }
        catch (IOException e) {
            Debug.error("DTEDFrame: File IO Error!\n" + e.toString());
        }
        this.path = filePath;
    }

    protected void read(BinaryFile binFile, boolean readWholeFile) {
        binFile.byteOrder(true);
        this.dsi = new DTEDFrameDSI(binFile);
        this.uhl = new DTEDFrameUHL(binFile);
        this.acc = new DTEDFrameACC(binFile);
        this.elevations = new short[this.uhl.num_lon_lines][];
        if (readWholeFile) {
            this.readDataRecords();
        }
        this.frame_is_valid = true;
    }

    public void dispose() {
        this.close(true);
        BinaryFile.removeClosable(this);
    }

    public boolean close(boolean done) {
        try {
            this.binFile.close();
            this.binFile = null;
            return true;
        }
        catch (IOException e) {
            Debug.error("DTEDFrame close(): File IO Error!\n" + e.toString());
            return false;
        }
    }

    protected boolean reopen() {
        try {
            this.binFile = new BinaryBufferedFile(this.path);
            return true;
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrame reopen(): file " + this.path + " not found");
            return false;
        }
        catch (IOException e) {
            Debug.error("DTEDFrame close(): File IO Error!\n" + e.toString());
            return false;
        }
    }

    public int elevationAt(float lat, float lon) {
        if (this.frame_is_valid && lat >= this.dsi.sw_lat && lat <= this.dsi.ne_lat && lon >= this.dsi.sw_lon && lon <= this.dsi.ne_lon) {
            int lat_index = Math.round((lat - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval);
            int lon_index = Math.round((lon - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval);
            if (this.elevations[lon_index] == null) {
                this.readDataRecord(lon_index);
            }
            return this.elevations[lon_index][lat_index];
        }
        return -32767;
    }

    public int interpElevationAt(float lat, float lon) {
        if (this.frame_is_valid && lat >= this.dsi.sw_lat && lat <= this.dsi.ne_lat && lon >= this.dsi.sw_lon && lon <= this.dsi.ne_lon) {
            float lat_index = (lat - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
            float lon_index = (lon - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
            int lflon_index = (int)Math.floor(lon_index);
            int lclon_index = (int)Math.ceil(lon_index);
            int lclat_index = (int)Math.ceil(lat_index);
            if (this.elevations[lflon_index] == null) {
                this.readDataRecord(lflon_index);
            }
            if (this.elevations[lclon_index] == null) {
                this.readDataRecord(lclon_index);
            }
            short ul = this.elevations[lflon_index][lclat_index];
            short ur = this.elevations[lclon_index][lclat_index];
            short ll = this.elevations[lflon_index][lclat_index];
            short lr = this.elevations[lclon_index][lclat_index];
            float answer = this.resolveFourPoints(ul, ur, lr, ll, lat_index, lon_index);
            return Math.round(answer);
        }
        return -32767;
    }

    public int[] getIndexesFromLatLons(float ullat, float ullon, float lrlat, float lrlon) {
        float upper = ullat;
        float lower = lrlat;
        float right = lrlon;
        float left = ullon;
        if (ullon > lrlon) {
            right = ullon;
            left = lrlon;
        }
        if (lrlat > ullat) {
            upper = lrlat;
            lower = ullat;
        }
        int[] ret = new int[4];
        float ullat_index = (upper - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
        float ullon_index = (left - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
        float lrlat_index = (lower - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
        float lrlon_index = (right - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
        ret[0] = Math.round(ullon_index);
        ret[1] = Math.round(lrlat_index);
        ret[2] = Math.round(lrlon_index);
        ret[3] = Math.round(ullat_index);
        if (ret[0] < 0) {
            ret[0] = 0;
        }
        if (ret[0] > this.uhl.num_lon_lines - 2) {
            ret[0] = this.uhl.num_lon_lines - 2;
        }
        if (ret[1] < 0) {
            ret[1] = 0;
        }
        if (ret[1] > this.uhl.num_lat_points - 2) {
            ret[1] = this.uhl.num_lat_points - 2;
        }
        if (ret[2] < 0) {
            ret[2] = 0;
        }
        if (ret[2] > this.uhl.num_lon_lines - 2) {
            ret[2] = this.uhl.num_lon_lines - 2;
        }
        if (ret[3] < 0) {
            ret[3] = 0;
        }
        if (ret[3] > this.uhl.num_lat_points - 2) {
            ret[3] = this.uhl.num_lat_points - 2;
        }
        return ret;
    }

    public short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon) {
        int[] indexes = this.getIndexesFromLatLons(ullat, ullon, lrlat, lrlon);
        return this.getElevations(indexes[0], indexes[1], indexes[2], indexes[3]);
    }

    public short[][] getElevations(int startx, int starty, int endx, int endy) {
        int upper = endy;
        int lower = starty;
        int right = endx;
        int left = startx;
        if (startx > endx) {
            right = startx;
            left = endx;
        }
        if (starty > endy) {
            upper = starty;
            lower = endy;
        }
        short[][] matrix = new short[right - left + 1][upper - lower + 1];
        int matrixColumn = 0;
        for (int x = left; x <= right; ++x) {
            if (this.elevations[x] == null) {
                this.readDataRecord(x);
            }
            System.arraycopy(this.elevations[x], lower, matrix[matrixColumn], 0, upper - lower + 1);
            ++matrixColumn;
        }
        return matrix;
    }

    private float resolveFourPoints(int ul, int ur, int lr, int ll, float lat_index, float lon_index) {
        float top_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (float)(ur - ul) + (float)ul;
        float bottom_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (float)(lr - ll) + (float)ll;
        float right_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (float)(ur - lr) + (float)lr;
        float left_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (float)(ul - ll) / 100.0f + (float)ll;
        float lon_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (top_avg - bottom_avg) + bottom_avg;
        float lat_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (right_avg - left_avg) + left_avg;
        float result = (lon_avg + lat_avg) / 2.0f;
        return result;
    }

    protected boolean readDataRecord(int lon_index) {
        try {
            if (this.binFile == null && !this.reopen()) {
                return false;
            }
            this.binFile.seek(3428 + lon_index * (12 + 2 * this.uhl.num_lat_points));
            this.binFile.read();
            this.binFile.skipBytes(3L);
            this.binFile.readShort();
            this.binFile.readShort();
            this.elevations[lon_index] = new short[this.uhl.num_lat_points];
            for (int j = 0; j < this.uhl.num_lat_points; ++j) {
                this.elevations[lon_index][j] = this.binFile.readShortData();
            }
        }
        catch (IOException e3) {
            Debug.error("DTEDFrame.RDR: Error reading file.");
            e3.printStackTrace();
            this.elevations[lon_index] = null;
            return false;
        }
        catch (FormatException f) {
            Debug.error("DTEDFrame.RDR: File IO Format error!");
            this.elevations[lon_index] = null;
            return false;
        }
        return true;
    }

    protected boolean readDataRecords() {
        boolean ret = true;
        for (int lon_index = 0; lon_index < this.uhl.num_lon_lines; ++lon_index) {
            if (this.readDataRecord(lon_index)) continue;
            ret = false;
        }
        return ret;
    }

    public OMGrid getOMGrid() {
        double vResolution = (double)this.dsi.lat_post_interval / 36000.0;
        double hResolution = (double)this.dsi.lon_post_interval / 36000.0;
        if (Debug.debugging("grid")) {
            Debug.output("DTEDFrame creating OMGrid with vResolution: " + vResolution + ",  hResolution: " + hResolution + ", created from:" + "\n\tNE LAT: " + this.dsi.ne_lat + "\n\tSW LAT: " + this.dsi.sw_lat + "\n\tNE LON: " + this.dsi.ne_lon + "\n\tSW LON: " + this.dsi.sw_lon + "\n\tlat lines: " + this.dsi.num_lat_lines + "\n\tlon points: " + this.dsi.num_lon_points);
        }
        OMDTEDGrid omg = new OMDTEDGrid(this.dsi.lat_origin, this.dsi.lon_origin, this.dsi.ne_lat, this.dsi.ne_lon, (float)vResolution, (float)hResolution, new OMGridData.Short(this.elevations));
        omg.setUnits(Length.METER);
        return omg;
    }

    public OMRaster getOMRaster(EqualArc proj) {
        OMGrid grid = this.getOMGrid();
        grid.generate(proj);
        SlopeGenerator sg = new SlopeGenerator();
        return sg.generateRasterForProjection(grid, proj);
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            System.out.println("DTEDFrame:  Need a path/filename");
            System.exit(0);
        }
        System.out.println("DTEDFrame: " + args[0]);
        DTEDFrame df = new DTEDFrame(args[0], true);
        if (df.frame_is_valid) {
            System.out.println(df.uhl);
            System.out.println(df.dsi);
            System.out.println(df.acc);
        }
        float lat = df.dsi.lat_origin + 0.5f;
        float lon = df.dsi.lon_origin + 0.5f;
        CADRG crg = new CADRG(new LatLonPoint(lat, lon), 1500000.0f, 600, 600);
        final OMRaster ras = df.getOMRaster(crg);
        Frame window = new Frame(args[0]){

            public void paint(Graphics g) {
                if (ras != null) {
                    g.translate(-300 + ras.getWidth() / 2, -300 + ras.getHeight() / 2);
                    ras.render(g);
                }
            }
        };
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        window.setSize(ras.getWidth(), ras.getHeight());
        window.setVisible(true);
        window.repaint();
    }
}

