/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGM;
import com.bbn.openmap.dataAccess.cgm.CGMPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class CGMDisplay {
    Graphics G;
    protected double X = 0.0;
    protected double Y = 0.0;
    protected double DX = 1.0;
    protected double DY = 1.0;
    protected int W;
    protected int H;
    protected CGM Cgm;
    Color FillColor = Color.black;
    Color EdgeColor = Color.black;
    Color LineColor = Color.black;
    Color TextColor = Color.black;
    boolean Filled = true;
    boolean Edge = true;
    int TextSize = 10;
    protected int[] Extent = new int[]{-30000, -30000, 30000, 30000};

    public CGMDisplay(CGM cgm) {
        int[] extent = cgm.extent();
        if (extent != null) {
            this.Extent = extent;
        }
        this.Cgm = cgm;
    }

    public void paint(Graphics g) {
        this.G = g;
        this.Cgm.paint(this);
    }

    public int x(int x) {
        return this.W + (int)(this.X + (double)x * this.DX);
    }

    public int y(int y) {
        return this.H - (int)(this.Y + (double)y * this.DY);
    }

    public Graphics graphics() {
        return this.G;
    }

    public void setFillColor(Color c) {
        this.FillColor = c;
    }

    public Color getFillColor() {
        return this.FillColor;
    }

    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    public boolean getFilled() {
        return this.Filled;
    }

    public void setEdgeColor(Color c) {
        this.EdgeColor = c;
    }

    public Color getEdgeColor() {
        return this.EdgeColor;
    }

    public void setEdge(boolean flag) {
        this.Edge = flag;
    }

    public boolean getEdge() {
        return this.Edge;
    }

    public void setLineColor(Color c) {
        this.LineColor = c;
    }

    public Color getLineColor() {
        return this.LineColor;
    }

    public void setTextColor(Color c) {
        this.TextColor = c;
    }

    public Color getTextColor() {
        return this.TextColor;
    }

    public void setTextSize(int h) {
        this.TextSize = h;
    }

    public int getTextSize() {
        return this.TextSize;
    }

    public double factorX() {
        return this.DX;
    }

    public double factorY() {
        return this.DY;
    }

    public void scale(int w, int h) {
        if (this.Extent == null) {
            return;
        }
        double fx = (double)w / (double)(this.Extent[2] - this.Extent[0]);
        if (fx * (double)(this.Extent[3] - this.Extent[1]) > (double)h) {
            fx = (double)h / (double)(this.Extent[3] - this.Extent[1]);
        }
        this.DX = fx *= 1.0;
        this.DY = fx;
        this.X = (double)(-this.Extent[0]) * fx;
        this.Y = (double)(-this.Extent[1]) * fx;
        this.W = (int)((double)w - fx * (double)(this.Extent[2] - this.Extent[0])) / 2;
        this.H = (int)((double)h - ((double)h - fx * (double)(this.Extent[3] - this.Extent[1])) / 2.0);
        this.Cgm.scale(this);
    }

    public void frame(Graphics g) {
        if (this.Extent == null) {
            return;
        }
        g.setColor(Color.black);
        g.drawRect(this.x(this.Extent[0]) - 1, this.y(this.Extent[3]) - 1, (int)Math.abs((double)(this.Extent[2] - this.Extent[0]) * this.DX) + 1, (int)Math.abs((double)(this.Extent[3] - this.Extent[1]) * this.DY) + 1);
    }

    public static void main(String[] args) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(args[0]));
        CGM cgm = new CGM();
        cgm.read(in);
        in.close();
        CGMDisplay d = new CGMDisplay(cgm);
        CGMPanel p = new CGMPanel(d);
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(600, 450);
        f.setLayout(new BorderLayout());
        f.add("Center", p);
        f.setVisible(true);
    }

    public void changeColor(Color oldc, Color newc) {
        this.Cgm.changeColor(oldc, newc);
    }
}

