/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.LayerSupport;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.HandleError;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class LayerHandler
extends OMComponent
implements SoloMapComponent,
Serializable {
    public static final String layersProperty = "layers";
    public static final String startUpLayersProperty = "startUpLayers";
    public static final String SynchronousThreadingProperty = "synchronousThreading";
    protected transient LayerSupport listeners = new LayerSupport(this);
    protected Layer[] allLayers = new Layer[0];
    protected PropertyHandler propertyHandler;
    static /* synthetic */ Class class$com$bbn$openmap$LayerHandler;

    public LayerHandler() {
    }

    public LayerHandler(Properties props) {
        this.init(null, props);
    }

    public LayerHandler(String prefix, Properties props) {
        this.init(prefix, props);
    }

    public LayerHandler(Layer[] layers) {
        this.init(layers);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.init(prefix, props);
    }

    public void init(String prefix, Properties props) {
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.init(this.getLayers(prefix, props));
        this.getListeners().setSynchronous(PropUtils.booleanFromProperties(props, prefix + SynchronousThreadingProperty, this.getListeners().isSynchronous()));
    }

    public void init(URL url) {
        this.init(null, url);
    }

    public void init(String prefix, URL url) {
        try {
            InputStream in = url.openStream();
            Properties props = new Properties();
            props.load(in);
            this.init(this.getLayers(prefix, props));
        }
        catch (MalformedURLException murle) {
            Debug.error("LayerHandler.init(URL): " + url + " is not a valid URL");
        }
        catch (IOException e) {
            Debug.error("LayerHandler.init(URL): Caught an IOException");
        }
    }

    public void init(Layer[] layers) {
        this.removeAll();
        if (this.allLayers != null && this.allLayers.length > 0) {
            int i;
            int lLength = layers != null ? layers.length : 0;
            Vector<Layer> newLayers = new Vector<Layer>(this.allLayers.length + lLength);
            if (layers != null) {
                for (i = 0; i < lLength; ++i) {
                    if (newLayers.contains(layers[i])) continue;
                    newLayers.add(layers[i]);
                }
            }
            for (i = 0; i < this.allLayers.length; ++i) {
                if (newLayers.contains(this.allLayers[i])) continue;
                newLayers.add(this.allLayers[i]);
            }
            layers = new Layer[newLayers.size()];
            layers = newLayers.toArray(layers);
        }
        this.setLayers(layers);
        this.addLayersToBeanContext(layers);
    }

    public void setPropertyHandler(PropertyHandler ph) {
        this.propertyHandler = ph;
    }

    public PropertyHandler getPropertyHandler() {
        return this.propertyHandler;
    }

    protected Layer[] getLayers(Properties p) {
        return this.getLayers(null, p);
    }

    protected Layer[] getLayers(String prefix, Properties p) {
        Debug.message("layerhandler", "LayerHandler: Getting new layers from properties...");
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String layersValueString = p.getProperty(prefix + layersProperty);
        String startupLayersValueString = p.getProperty(prefix + startUpLayersProperty);
        if (layersValueString == null) {
            layersValueString = p.getProperty(PropUtils.getScopedPropertyPrefix("openmap") + layersProperty);
        }
        if (startupLayersValueString == null) {
            startupLayersValueString = p.getProperty(PropUtils.getScopedPropertyPrefix("openmap") + startUpLayersProperty);
        }
        Vector startuplayers = PropUtils.parseSpacedMarkers(startupLayersValueString);
        Vector layersValue = PropUtils.parseSpacedMarkers(layersValueString);
        if (startuplayers.isEmpty()) {
            Debug.message("layerhandler", "LayerHandler: No layers on startup list");
        }
        if (layersValue.isEmpty()) {
            Debug.error("LayerHandler.getLayers(): No property \"layers\" found in properties.");
            return new Layer[0];
        }
        if (Debug.debugging("layerhandler")) {
            Debug.output("LayerHandler: Layer markers found = " + layersValue);
        }
        Layer[] layers = LayerHandler.getLayers(layersValue, startuplayers, p);
        return layers;
    }

    /*
     * WARNING - void declaration
     */
    public static Layer[] getLayers(Vector layerList, Vector visibleLayerList, Properties p) {
        int nLayerNames = layerList.size();
        Vector<void> layers = new Vector<void>(nLayerNames);
        for (int i = 0; i < nLayerNames; ++i) {
            void var10_10;
            Layer l;
            String layerName = (String)layerList.elementAt(i);
            String classProperty = layerName + ".class";
            String className = p.getProperty(classProperty);
            if (className == null) {
                Debug.error("LayerHandler.getLayers(): Failed to locate property \"" + classProperty + "\"\n  Skipping layer \"" + layerName + "\"");
                continue;
            }
            Object obj = ComponentFactory.create(className, layerName, p);
            if (obj instanceof Layer) {
                l = (Layer)obj;
            } else if (obj instanceof PlugIn) {
                PlugInLayer pl = new PlugInLayer();
                pl.setProperties(layerName, p);
                pl.setPlugIn((PlugIn)obj);
                l = pl;
            } else {
                Debug.error("LayerHandler: Skipped \"" + layerName + "\" " + (obj == null ? " - unable to create " : ", type " + obj.getClass().getName() + " is not a layer or plugin"));
                continue;
            }
            var10_10.setVisible(visibleLayerList.contains(layerName));
            layers.addElement(var10_10);
            if (!Debug.debugging("layerhandler")) continue;
            Debug.output("LayerHandler: layer " + var10_10.getName() + (var10_10.isVisible() ? " is visible" : " is not visible"));
        }
        int nLayers = layers.size();
        if (nLayers == 0) {
            return new Layer[0];
        }
        Object[] value = new Layer[nLayers];
        layers.copyInto(value);
        return value;
    }

    public void addLayerListener(LayerListener ll) {
        Debug.message("layerhandler", "LayerHandler: adding layer listener");
        this.listeners.addLayerListener(ll);
        ll.setLayers(new LayerEvent(this, 403, this.allLayers));
        ll.setLayers(new LayerEvent(this, 400, this.getMapLayers()));
    }

    public void removeLayerListener(LayerListener ll) {
        if (this.listeners != null) {
            this.listeners.removeLayerListener(ll);
        }
    }

    public synchronized void setLayers(Layer[] layers) {
        this.allLayers = this.organizeBackgroundLayers(layers);
        if (Debug.debugging("layerhandler")) {
            Debug.output("LayerHandler.setLayers: " + layers);
        }
        Layer[] layersCopy = new Layer[this.allLayers.length];
        System.arraycopy(this.allLayers, 0, layersCopy, 0, this.allLayers.length);
        this.getListeners().pushLayerEvent(403, layersCopy);
        this.getListeners().pushLayerEvent(402, this.getMapLayers());
    }

    protected boolean isForegroundUnderBackgroundLayer(Layer[] layers) {
        boolean ret = false;
        boolean foundBackgroundLayer = false;
        for (int i = 0; i < layers.length; ++i) {
            boolean isBackgroundLayer = layers[i].getAddAsBackground();
            if (isBackgroundLayer) {
                foundBackgroundLayer = true;
                continue;
            }
            if (!foundBackgroundLayer) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected Layer[] organizeBackgroundLayers(Layer[] layers) {
        while (this.isForegroundUnderBackgroundLayer(layers)) {
            for (int i = layers.length - 1; i > 0; --i) {
                Layer layer1 = layers[i - 1];
                Layer layer2 = layers[i];
                if (layer2.getAddAsBackground() || !layer1.getAddAsBackground()) continue;
                layers[i - 1] = layer2;
                layers[i] = layer1;
            }
        }
        return layers;
    }

    protected LayerSupport getListeners() {
        return this.listeners;
    }

    public void setLayers() {
        this.setLayers(this.allLayers);
    }

    public void updateLayerLabels() {
        this.setLayers(this.allLayers);
    }

    public synchronized Layer[] getLayers() {
        if (this.allLayers == null) {
            return new Layer[0];
        }
        Layer[] layers = new Layer[this.allLayers.length];
        System.arraycopy(this.allLayers, 0, layers, 0, this.allLayers.length);
        return layers;
    }

    public Layer[] getMapLayers() {
        Debug.message("layerhandler", "LayerHandler.getMapLayers()");
        int numEnabled = 0;
        int cakeIndex = 0;
        Layer[] cake = null;
        Layer[] layers = this.getLayers();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < layers.length; ++i) {
                if (layers[i] == null || !layers[i].isVisible()) continue;
                if (j == 0) {
                    ++numEnabled;
                    continue;
                }
                cake[cakeIndex++] = layers[i];
            }
            if (j != 0) continue;
            cake = new Layer[numEnabled];
        }
        return cake;
    }

    public boolean moveLayer(Layer layer, int toPosition) {
        boolean found = false;
        if (this.allLayers == null) {
            return false;
        }
        int i = 0;
        for (i = 0; i < this.allLayers.length; ++i) {
            if (layer != this.allLayers[i]) continue;
            found = true;
            break;
        }
        if (found) {
            int pos = toPosition;
            if (pos < 0) {
                pos = 0;
            } else if (pos >= this.allLayers.length) {
                pos = this.allLayers.length - 1;
            }
            if (pos == i) {
                return true;
            }
            Layer movedLayer = this.allLayers[i];
            int direction = i > pos ? -1 : 1;
            while (i != pos) {
                this.allLayers[i] = this.allLayers[i + direction];
                i += direction;
            }
            this.allLayers[pos] = movedLayer;
            this.setLayers(this.allLayers);
        }
        return found;
    }

    public void addLayer(Layer layer) {
        if (this.allLayers == null) {
            this.addLayer(layer, 0);
            return;
        }
        int i = 0;
        for (i = 0; i < this.allLayers.length; ++i) {
            if (layer != this.allLayers[i]) continue;
            return;
        }
        this.addLayer(layer, this.allLayers.length + 1);
    }

    public void addLayer(Layer layer, int position) {
        String pre;
        if (this.moveLayer(layer, position)) {
            return;
        }
        if (this.allLayers == null) {
            this.allLayers = new Layer[0];
        }
        Layer[] newLayers = new Layer[this.allLayers.length + 1];
        if (position >= this.allLayers.length) {
            System.arraycopy(this.allLayers, 0, newLayers, 0, this.allLayers.length);
            newLayers[this.allLayers.length] = layer;
        } else if (position <= 0) {
            System.arraycopy(this.allLayers, 0, newLayers, 1, this.allLayers.length);
            newLayers[0] = layer;
        } else {
            newLayers[position] = layer;
            System.arraycopy(this.allLayers, 0, newLayers, 0, position);
            System.arraycopy(this.allLayers, position, newLayers, position + 1, this.allLayers.length - position);
        }
        if (this.propertyHandler != null && (pre = layer.getPropertyPrefix()) != null && pre != "") {
            this.propertyHandler.addUsedPrefix(layer.getPropertyPrefix());
        }
        this.setLayers(newLayers);
        BeanContext bc = this.getBeanContext();
        if (bc != null && layer.getAddToBeanContext() && layer.getBeanContext() == null) {
            bc.add(layer);
        }
    }

    public void addLayer(Layer layer, int position, boolean addedLayerTurnedOn) {
        layer.setVisible(addedLayerTurnedOn);
        this.addLayer(layer, position);
    }

    public void removeLayer(Layer layer) {
        if (layer != null && layer.isRemovable()) {
            int index = -1;
            for (int i = 0; i < this.allLayers.length; ++i) {
                if (layer != this.allLayers[i]) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.removeLayer(this.allLayers, index);
            }
        } else if (layer != null) {
            Debug.error("LayerHandler: received command to remove " + layer.getName() + ", which has been designated as *NOT* removeable");
            throw new HandleError("LayerHandler commanded to delete a layer (" + layer.getName() + ") that is not removeable");
        }
    }

    public void removeLayer(int index) {
        if (index >= 0 && index < this.allLayers.length) {
            this.removeLayer(this.allLayers, index);
        }
    }

    public boolean hasLayer(Layer l) {
        Layer[] layers = this.allLayers;
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] != l) continue;
            return true;
        }
        return false;
    }

    public void removeAll() {
        if (this.allLayers == null || this.allLayers.length == 0) {
            return;
        }
        BeanContext bc = this.getBeanContext();
        Layer[] oldLayers = this.allLayers;
        Vector<Layer> nonRemoveableLayers = null;
        for (int i = 0; i < oldLayers.length; ++i) {
            Layer layer = oldLayers[i];
            if (layer.isRemovable()) {
                this.turnLayerOn(false, layer);
                layer.clearListeners();
                if (bc != null) {
                    bc.remove(layer);
                }
                oldLayers[i] = null;
                continue;
            }
            if (nonRemoveableLayers == null) {
                nonRemoveableLayers = new Vector<Layer>(oldLayers.length);
            }
            nonRemoveableLayers.add(layer);
        }
        if (nonRemoveableLayers != null) {
            this.allLayers = new Layer[nonRemoveableLayers.size()];
            this.allLayers = nonRemoveableLayers.toArray(this.allLayers);
        } else {
            this.allLayers = new Layer[0];
        }
        this.setLayers(this.allLayers);
        System.gc();
    }

    protected void removeLayer(Layer[] currentLayers, int index) {
        Layer rLayer = currentLayers[index];
        if (!rLayer.isRemovable()) {
            Debug.error("LayerHandler: received command to remove " + rLayer.getName() + ", which has been designated as *NOT* removeable");
            return;
        }
        rLayer.setVisible(false);
        Layer[] newLayers = new Layer[currentLayers.length - 1];
        System.arraycopy(currentLayers, 0, newLayers, 0, index);
        System.arraycopy(currentLayers, index + 1, newLayers, index, currentLayers.length - index - 1);
        BeanContext bc = this.getBeanContext();
        if (bc != null) {
            bc.remove(rLayer);
        }
        this.turnLayerOn(false, rLayer);
        rLayer.clearListeners();
        rLayer = null;
        if (Debug.debugging("helpgc")) {
            System.gc();
        }
        this.setLayers(newLayers);
    }

    public boolean turnLayerOn(boolean setting, int index) {
        try {
            this.turnLayerOn(setting, this.allLayers[index]);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException aoobe) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean turnLayerOn(boolean setting, Layer layer) {
        if (setting && !layer.isVisible() || !setting && layer.isVisible()) {
            if (Debug.debugging("layerhandler")) {
                Debug.output("LayerHandler: turning " + layer.getName() + (setting ? " on" : " off"));
            }
            layer.setVisible(setting);
            this.getListeners().pushLayerEvent(402, this.getMapLayers());
            return true;
        }
        return false;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof LayerListener) {
            Debug.message("layerhandler", "LayerHandler found a LayerListener.");
            this.addLayerListener((LayerListener)someObj);
        }
        if (someObj instanceof Layer) {
            if (Debug.debugging("layerhandler")) {
                Debug.output("LayerHandler found a Layer |" + ((Layer)someObj).getName() + "|");
            }
            if (!this.hasLayer((Layer)someObj)) {
                this.addLayer((Layer)someObj, 0);
            }
        }
        if (someObj instanceof PropertyHandler) {
            this.setPropertyHandler((PropertyHandler)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof LayerListener) {
            Debug.message("layerhandler", "LayerListener object is being removed");
            this.removeLayerListener((LayerListener)someObj);
        }
        if (someObj instanceof Layer) {
            this.removeLayer((Layer)someObj);
        }
        if (someObj instanceof PropertyHandler && someObj == this.getPropertyHandler()) {
            this.setPropertyHandler(null);
        }
    }

    public void addLayersToBeanContext(Layer[] layers) {
        BeanContext bc = this.getBeanContext();
        if (bc == null || layers == null) {
            return;
        }
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getAddToBeanContext() || layers[i].getBeanContext() != null) continue;
            bc.add(layers[i]);
        }
    }

    public void removeLayersFromBeanContext(Layer[] layers) {
        BeanContext bc = this.getBeanContext();
        if (bc == null || layers == null) {
            return;
        }
        for (int i = 0; i < layers.length; ++i) {
            bc.remove(layers[i]);
        }
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            if (Debug.debugging("layerhandler")) {
                Debug.output("LayerHandler.setBeanContext()");
            }
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.addLayersToBeanContext(this.getLayers());
            this.findAndInit(in_bc.iterator());
        }
    }

    public void setSynchronousThreading(boolean s) {
        this.getListeners().setSynchronous(s);
    }

    public boolean isSynchronousThreading() {
        return this.getListeners().isSynchronous();
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        props.put(PropUtils.getScopedPropertyPrefix(this) + SynchronousThreadingProperty, Boolean.toString(this.getListeners().isSynchronous()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String internString = this.i18n.get(class$com$bbn$openmap$LayerHandler == null ? (class$com$bbn$openmap$LayerHandler = LayerHandler.class$("com.bbn.openmap.LayerHandler")) : class$com$bbn$openmap$LayerHandler, SynchronousThreadingProperty, 3, "Launch new threads to do work.");
        props.put(SynchronousThreadingProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$LayerHandler == null ? (class$com$bbn$openmap$LayerHandler = LayerHandler.class$("com.bbn.openmap.LayerHandler")) : class$com$bbn$openmap$LayerHandler, SynchronousThreadingProperty, "Synchronous Threading");
        props.put("synchronousThreading.label", internString);
        props.put("synchronousThreadingeditor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

