/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.BasicI18n;
import com.bbn.openmap.I18n;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.applet.Applet;
import java.awt.Color;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class Environment
extends Properties {
    protected static Environment env;
    protected Properties hardcodedProps;
    protected Properties runtimeProps;
    protected JLayeredPane desktop = null;
    protected static Applet applet;
    private static int counter;
    private static transient Vector extraPaths;
    public static final transient String OpenMapPrefix = "openmap";
    public static final transient String PreferencesURL = "openmap.PreferencesURL";
    public static final transient String Title = "openmap.Title";
    public static final transient String Version = "openmap.Version";
    public static final transient String BuildDate = "openmap.BuildDate";
    public static final transient String UniqueID = "openmap.UniqueID";
    public static final transient String WebBrowser = "openmap.WebBrowser";
    public static final transient String TmpDir = "openmap.TempDirectory";
    public static final transient String UseInternalFrames = "openmap.UseInternalFrames";
    public static final transient String Latitude = "openmap.Latitude";
    public static final transient String Longitude = "openmap.Longitude";
    public static final transient String Scale = "openmap.Scale";
    public static final transient String Projection = "openmap.Projection";
    public static final transient String Width = "openmap.Width";
    public static final transient String Height = "openmap.Height";
    public static final transient String HelpURL = "openmap.HelpURL";
    public static final transient String BackgroundColor = "openmap.BackgroundColor";
    public static final transient String DebugList = "openmap.Debug";
    private static transient boolean isXWindows;
    public static transient boolean doingXWindowsWorkaround;
    public static final transient String title = "$$Title=OpenMap(tm)";
    public static final transient String version = "$$Version=4.6.4_beta";
    public static final transient String build = "$$BuildDate=20080229@14:48";
    private static I18n i18n;

    protected static final void initHardCodedProperties(Properties p) {
        StringTokenizer tokenizer = new StringTokenizer(title, "=");
        tokenizer.nextToken();
        p.put(Title, tokenizer.nextToken());
        tokenizer = new StringTokenizer(version, "=");
        tokenizer.nextToken();
        p.put(Version, tokenizer.nextToken());
        tokenizer = new StringTokenizer(build, "=");
        tokenizer.nextToken();
        try {
            p.put(BuildDate, tokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static void init(Applet applet) {
        if (applet == null) {
            Environment.init(System.getProperties());
        } else {
            if (env != null) {
                Debug.output("Reinitializing Applet Environment!");
                Environment.setApplet(applet);
                env.setAppletProperties(applet, env);
                return;
            }
            new Environment(applet);
        }
        if (Debug.debugging("env")) {
            env.list(System.out);
        }
    }

    public static void init(Properties sysProps) {
        if (env != null) {
            env.installProps(sysProps);
            return;
        }
        new Environment(sysProps);
        if (Debug.debugging("env")) {
            env.list(System.out);
        }
    }

    public static void init() {
        Environment.init(System.getProperties());
    }

    protected Environment(Applet applet) {
        env = this;
        Environment.setApplet(applet);
        this.setAppletProperties(applet, this);
        this.commonInit();
    }

    protected Environment(Properties sysProps) {
        env = this;
        this.installProps(sysProps);
        this.commonInit();
    }

    private void installProps(Properties sysProps) {
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            try {
                this.put(key, val);
            }
            catch (NullPointerException ex) {}
        }
    }

    protected void commonInit() {
        this.hardcodedProps = new Properties();
        this.defaults = this.runtimeProps = new Properties(this.hardcodedProps);
        Environment.initHardCodedProperties(this.hardcodedProps);
        Environment.initRuntimeProperties(this.runtimeProps);
    }

    protected void setAppletProperties(Applet applet, Properties props) {
        int i;
        String[] appletProps = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator"};
        for (i = 0; i < appletProps.length; ++i) {
            String prop = appletProps[i];
            props.put(prop, System.getProperty(prop));
        }
        String[][] pinfo = applet.getParameterInfo();
        if (pinfo == null) {
            return;
        }
        for (i = 0; i < pinfo.length; ++i) {
            try {
                String key = pinfo[i][0];
                String value = applet.getParameter(key);
                Debug.message("env", "Applet Parameter " + key + " has value " + value);
                props.put(key, value);
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    protected static void initRuntimeProperties(Properties p) {
        if (Environment.isApplet()) {
            p.put("user.name", "appletUser");
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (NullPointerException npe) {
            Debug.output("Environment.init: Can't get hostname from InetAddress!");
        }
        catch (UnknownHostException e) {
            Debug.output("Environment.init: I don't know my hostname!");
        }
        catch (IndexOutOfBoundsException ioobe) {
            Debug.output("Environment.init: network may not be available");
        }
        p.put(UniqueID, "_" + Environment.get("user.name") + "_" + Environment.get(Version) + "_" + Environment.get("os.arch") + "_" + Environment.get("os.name") + "_" + (addr != null ? addr.getHostName() : "nohost") + "_" + Environment.timestamp() + "_");
        String osname = Environment.get("os.name");
        if (osname == null) {
            isXWindows = false;
            doingXWindowsWorkaround = false;
            Debug.message("env", "Environment: is applet, Web Start.");
            return;
        }
        if (osname.equalsIgnoreCase("solaris") || osname.equalsIgnoreCase("SunOS")) {
            isXWindows = true;
            doingXWindowsWorkaround = true;
            Debug.message("env", "Environment: is X Windows!");
        } else if (osname.equalsIgnoreCase("linux")) {
            isXWindows = true;
            doingXWindowsWorkaround = true;
            Debug.message("env", "Environment: is X Windows!");
        } else if (osname.startsWith("Windows")) {
            isXWindows = false;
            doingXWindowsWorkaround = false;
            isXWindows = true;
            doingXWindowsWorkaround = true;
            Debug.message("env", "Environment: is MS Windows!");
        } else if (osname.equalsIgnoreCase("Mac OS")) {
            isXWindows = false;
            doingXWindowsWorkaround = false;
            Debug.message("env", "Environment: is Mac OS!");
        } else if (osname.equalsIgnoreCase("Mac OS X")) {
            isXWindows = true;
            doingXWindowsWorkaround = true;
            DrawingAttributes.alwaysSetTextToBlack = true;
            Debug.message("env", "Environment: Excellent! Mac OS X!");
        } else {
            System.err.println("Environment.initRuntimeProperties(): running on unknown/untested OS: " + osname);
        }
        if (Environment.get("openmap.noXWindowsWorkaround") != null) {
            Debug.message("env", "Environment.initRuntimeProperties(): not working around XWindows clipping bug.");
            doingXWindowsWorkaround = false;
        }
    }

    public static boolean isApplet() {
        return applet != null;
    }

    protected static void setApplet(Applet applet) {
        Environment.applet = applet;
        if (applet instanceof JApplet) {
            Environment.useInternalFrames(((JApplet)applet).getRootPane());
        }
    }

    public static boolean isApplication() {
        return applet == null;
    }

    public static String get(String key) {
        return Environment.get(key, null);
    }

    public static String get(String key, String defaultValue) {
        if (env == null) {
            if (Debug.debugging("env")) {
                System.err.println("Environment.get(" + key + ", " + defaultValue + ") called with null environment");
            }
            return defaultValue;
        }
        return env.getProperty(key, defaultValue);
    }

    public static String set(String key, String value) {
        if (env == null) {
            if (Debug.debugging("env")) {
                System.err.println("Can't Environment.put(" + key + ", " + value + ") - no environment yet.");
            }
            return null;
        }
        return (String)env.put(key, value);
    }

    public static boolean getBoolean(String key) {
        return Environment.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String str = Environment.get(key, null);
        if (str == null) {
            return defaultValue;
        }
        return Boolean.valueOf(str);
    }

    public static int getInteger(String key) {
        return Environment.getInteger(key, Integer.MIN_VALUE, 10);
    }

    public static int getInteger(String key, int defaultValue) {
        return Environment.getInteger(key, defaultValue, 10);
    }

    public static int getInteger(String key, int defaultValue, int radix) {
        String str = Environment.get(key, null);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str, radix);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float getFloat(String key) {
        return Environment.getFloat(key, Float.NaN);
    }

    public static float getFloat(String key, float defaultValue) {
        String str = Environment.get(key, null);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(str).floatValue();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDouble(String key) {
        return Environment.getDouble(key, Double.NaN);
    }

    public static double getDouble(String key, double defaultValue) {
        String str = Environment.get(key, null);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void addSystemProperty(String key, String value) {
        env.put(key, value);
    }

    public static void addRuntimeProperty(String key, String value) {
        Environment.env.runtimeProps.put(key, value);
    }

    public static Properties getProperties() {
        return env;
    }

    public static String timestamp() {
        Calendar calendar = Calendar.getInstance();
        return "" + calendar.get(1) + calendar.get(2) + calendar.get(5) + calendar.get(10) + calendar.get(12) + calendar.get(13);
    }

    public static final boolean isXWindowSystem() {
        return isXWindows;
    }

    public static String generateUniqueString() {
        return Environment.get(UniqueID) + counter++;
    }

    public static final Vector getClasspathDirs() {
        Vector<String> v = new Vector<String>();
        try {
            String classPath = System.getProperty("java.class.path");
            StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                if (!new File(path).isDirectory()) continue;
                v.addElement(path);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        v.addAll(extraPaths);
        return v;
    }

    public static void addPathToClasspaths(String path) {
        extraPaths.addElement(path);
    }

    public static Color getCustomBackgroundColor() {
        String colorRep = Environment.get(BackgroundColor);
        if (colorRep == null) {
            return null;
        }
        try {
            return PropUtils.parseColor(colorRep);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static void useInternalFrames(JRootPane rootPane) {
        if (rootPane != null) {
            Environment.useInternalFrames(rootPane.getLayeredPane());
        } else {
            Environment.useInternalFrames((JLayeredPane)null);
        }
    }

    public static void useInternalFrames(JLayeredPane layeredPane) {
        if (layeredPane != null) {
            Environment.env.desktop = layeredPane;
            Environment.env.desktop.setOpaque(true);
            Environment.set(UseInternalFrames, "true");
        } else {
            Environment.env.desktop = null;
            Environment.set(UseInternalFrames, "false");
        }
    }

    public static JLayeredPane getInternalFrameDesktop() {
        return Environment.env.desktop;
    }

    public static I18n getI18n() {
        return i18n;
    }

    static {
        counter = 0;
        extraPaths = new Vector();
        isXWindows = false;
        doingXWindowsWorkaround = false;
        i18n = new BasicI18n();
    }
}

