/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.exceptions.OpenCLError;
import org.encog.engine.opencl.kernels.EncogKernel;

public class OpenCLTrainingProfile {
    private EncogCLDevice device;
    private final double localRatio;
    private final int globalRatio;
    private final double segmentationRatio;
    private int kernelGlobalWorkgroup;
    private int kernelLocalWorkgroup;
    private int kernelWorkPerCall;
    private int kernelNumberOfCalls;
    private int kernelRemainder;
    private int kernelRemainderGlobal;
    private int kernelRemainderPer;

    public OpenCLTrainingProfile(EncogCLDevice encogCLDevice) {
        this(encogCLDevice, 1.0, 1, 1.0);
    }

    public OpenCLTrainingProfile(EncogCLDevice encogCLDevice, double d, int n, double d2) {
        this.device = encogCLDevice;
        if (d < 0.0 || n < 0 || d2 < 0.0) {
            throw new OpenCLError("None of the ratios can be below zero.");
        }
        if (d > 1.0) {
            throw new OpenCLError("The local ratio cannot be greater than 1.0.  That would cause the OpenCL device to have more local items than it can handle.");
        }
        if ((double)n < 1.0) {
            throw new OpenCLError("The global ratio cannot be less than 1.0.  That would cause the global work area to be less than a local work area.");
        }
        if (d2 > 1.0) {
            throw new OpenCLError("The segmentation ratio cannot be greater than 1.0.  That would cause the trainer to require more training elements per iteration than exist.");
        }
        this.localRatio = d;
        this.globalRatio = n;
        this.segmentationRatio = d2;
    }

    public void calculateKernelParams(EncogKernel encogKernel, EngineIndexableSet engineIndexableSet) {
        int n;
        int n2;
        boolean bl = false;
        if (Math.abs(this.segmentationRatio - 1.0) < 1.0E-6) {
            n2 = (int)Math.min((long)encogKernel.getMaxWorkGroupSize(), engineIndexableSet.getRecordCount());
            ++n2;
            do {
                this.kernelLocalWorkgroup = (int)((double)(--n2) * this.localRatio);
                this.kernelGlobalWorkgroup = this.kernelLocalWorkgroup * this.globalRatio;
                this.kernelWorkPerCall = (int)((double)(engineIndexableSet.getRecordCount() / (long)this.kernelGlobalWorkgroup) * this.segmentationRatio);
            } while ((long)(n = this.kernelGlobalWorkgroup * this.kernelWorkPerCall) != engineIndexableSet.getRecordCount() && n2 > 1);
            if (n2 > 0) {
                bl = true;
            }
        }
        if (!bl) {
            n2 = (int)Math.min((long)encogKernel.getMaxWorkGroupSize(), engineIndexableSet.getRecordCount());
            this.kernelLocalWorkgroup = (int)((double)n2 * this.localRatio);
            this.kernelGlobalWorkgroup = this.kernelLocalWorkgroup * this.globalRatio;
            if (this.segmentationRatio < 1.0E-6) {
                this.kernelWorkPerCall = 1;
            } else {
                this.kernelWorkPerCall = (int)((double)(engineIndexableSet.getRecordCount() / (long)this.kernelGlobalWorkgroup) * this.segmentationRatio);
                if (this.kernelWorkPerCall == 0) {
                    this.kernelWorkPerCall = 1;
                }
            }
        }
        n = this.kernelGlobalWorkgroup * this.kernelWorkPerCall;
        this.kernelNumberOfCalls = (int)(engineIndexableSet.getRecordCount() / (long)n);
        this.kernelRemainder = (int)(engineIndexableSet.getRecordCount() % (long)n);
        this.kernelRemainderGlobal = this.kernelGlobalWorkgroup;
        if (this.kernelRemainder == 0) {
            this.kernelRemainder = this.kernelGlobalWorkgroup;
            this.kernelRemainderPer = this.kernelWorkPerCall;
            --this.kernelNumberOfCalls;
        } else {
            this.kernelRemainderPer = this.kernelRemainder / this.kernelGlobalWorkgroup;
        }
        if (this.kernelRemainderPer == 0) {
            this.kernelRemainderPer = 1;
            this.kernelRemainderGlobal = this.kernelRemainder;
        }
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public int getGlobalRatio() {
        return this.globalRatio;
    }

    public int getKernelGlobalWorkgroup() {
        return this.kernelGlobalWorkgroup;
    }

    public int getKernelLocalWorkgroup() {
        return this.kernelLocalWorkgroup;
    }

    public int getKernelNumberOfCalls() {
        return this.kernelNumberOfCalls;
    }

    public int getKernelRemainder() {
        return this.kernelRemainder;
    }

    public int getKernelRemainderGlobal() {
        return this.kernelRemainderGlobal;
    }

    public int getKernelRemainderPer() {
        return this.kernelRemainderPer;
    }

    public int getKernelWorkPerCall() {
        return this.kernelWorkPerCall;
    }

    public double getLocalRatio() {
        return this.localRatio;
    }

    public double getSegmentationRatio() {
        return this.segmentationRatio;
    }

    public void setDevice(EncogCLDevice encogCLDevice) {
        this.device = encogCLDevice;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenCL Profile:\n");
        stringBuilder.append("Local Ratio: ");
        stringBuilder.append(this.localRatio);
        stringBuilder.append("\n");
        stringBuilder.append("Number of global work items: ");
        stringBuilder.append(this.globalRatio);
        stringBuilder.append("\n");
        stringBuilder.append("Segmentation Ratio: ");
        stringBuilder.append(this.segmentationRatio);
        stringBuilder.append("\n");
        stringBuilder.append("Device: ");
        stringBuilder.append(this.device.toString());
        stringBuilder.append("\n");
        stringBuilder.append("kernelGlobalWorkgroup: ");
        stringBuilder.append(this.kernelGlobalWorkgroup);
        stringBuilder.append("\n");
        stringBuilder.append("kernelLocalWorkgroup: ");
        stringBuilder.append(this.kernelLocalWorkgroup);
        stringBuilder.append("\n");
        stringBuilder.append("kernelWorkPerCall: ");
        stringBuilder.append(this.kernelWorkPerCall);
        stringBuilder.append("\n");
        stringBuilder.append("kernelNumberOfCalls: ");
        stringBuilder.append(this.kernelNumberOfCalls);
        stringBuilder.append("\n");
        stringBuilder.append("kernelRemainder: ");
        stringBuilder.append(this.kernelRemainder);
        stringBuilder.append("\n");
        stringBuilder.append("kernelRemainderGlobal: ");
        stringBuilder.append(this.kernelRemainderGlobal);
        stringBuilder.append("\n");
        stringBuilder.append("kernelRemainderPer: ");
        stringBuilder.append(this.kernelRemainderPer);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

