/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationTANH
implements ActivationFunction {
    private static final long serialVersionUID = 9121998892720207643L;
    private double[] params = new double[0];

    public ActivationFunction clone() {
        return new ActivationTANH();
    }

    public boolean hasDerivative() {
        return true;
    }

    public void activationFunction(double[] dArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = Math.tanh(dArray[i]);
        }
    }

    public double derivativeFunction(double d) {
        return 1.0 - d * d;
    }

    public String[] getParamNames() {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public void setParam(int n, double d) {
        this.params[n] = d;
    }

    public String getOpenCLExpression(boolean bl) {
        if (bl) {
            return "(1.0f - x * x)";
        }
        return "tanh(x)";
    }
}

