/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.engine.EncogEngineError;
import org.encog.engine.concurrency.EngineTask;
import org.encog.engine.concurrency.PoolItem;
import org.encog.engine.concurrency.TaskGroup;

public class EngineConcurrency {
    private static EngineConcurrency instance;
    private Throwable threadError;
    private int currentTaskGroup;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public static EngineConcurrency getInstance() {
        if (instance == null) {
            instance = new EngineConcurrency();
        }
        return instance;
    }

    public void checkError() {
        if (this.threadError != null) {
            throw new EncogEngineError(this.threadError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskGroup createTaskGroup() {
        TaskGroup taskGroup = null;
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            ++this.currentTaskGroup;
            taskGroup = new TaskGroup(this.currentTaskGroup);
        }
        return taskGroup;
    }

    public void processTask(EngineTask engineTask) {
        this.processTask(engineTask, null);
    }

    public void processTask(EngineTask engineTask, TaskGroup taskGroup) {
        if (this.executor == null) {
            engineTask.run();
        } else {
            if (this.threadError != null) {
                Throwable throwable = this.threadError;
                this.threadError = null;
                throw new EncogEngineError(throwable);
            }
            PoolItem poolItem = new PoolItem(engineTask, taskGroup);
            if (taskGroup != null) {
                taskGroup.taskStarting();
            }
            this.executor.execute(poolItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerError(Throwable throwable) {
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            this.threadError = throwable;
        }
    }

    public void shutdown(long l) {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(l, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (InterruptedException interruptedException) {
                throw new EncogEngineError(interruptedException);
            }
        }
    }
}

