/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.StringTokenizer;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5Datatype
extends Datatype {
    private static final long serialVersionUID = -750546422258749792L;
    private List<Attribute> attributeList;
    private boolean isNamed = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;
    private boolean isVLEN = false;
    private String description = null;

    public H5Datatype(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    @Deprecated
    public H5Datatype(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (oid == null && theFile != null) {
            try {
                byte[] ref_buf = H5.H5Rcreate((int)theFile.getFID(), (String)this.getFullName(), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong((byte[])ref_buf, (int)0);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public H5Datatype(int tclass, int tsize, int torder, int tsign) {
        super(tclass, tsize, torder, tsign);
    }

    public H5Datatype(int nativeID) {
        super(nativeID);
        this.description = H5Datatype.getDatatypeDescription(nativeID);
        this.fromNative(nativeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int tid = -1;
            try {
                tid = H5.H5Topen((int)this.getFID(), (String)(this.getPath() + this.getName()), (int)HDF5Constants.H5P_DEFAULT);
                this.fromNative(tid);
                this.obj_info = H5.H5Oget_info((int)tid);
                this.isNamed = true;
            }
            catch (Exception ex) {
                this.obj_info.num_attrs = 0L;
            }
            finally {
                try {
                    H5.H5Tclose((int)tid);
                }
                catch (Exception exception) {}
            }
        }
        return this.obj_info.num_attrs > 0L;
    }

    public static final String[] convertEnumValueToName(int tid, Object inValues, String[] outNames) throws HDF5Exception {
        int inSize = 0;
        if (inValues == null || (inSize = Array.getLength(inValues)) <= 0 || outNames != null && inSize != Array.getLength(outNames)) {
            return null;
        }
        int nMembers = H5.H5Tget_nmembers((int)tid);
        if (nMembers <= 0) {
            return null;
        }
        if (outNames == null) {
            outNames = new String[inSize];
        } else {
            for (int i = 0; i < inSize; ++i) {
                outNames[i] = null;
            }
        }
        String[] names = new String[nMembers];
        int[] values = new int[nMembers];
        int[] theValue = new int[]{0};
        for (int i = 0; i < nMembers; ++i) {
            names[i] = H5.H5Tget_member_name((int)tid, (int)i);
            H5.H5Tget_member_value((int)tid, (int)i, (int[])theValue);
            values[i] = theValue[0];
        }
        int val = -1;
        block2: for (int i = 0; i < inSize; ++i) {
            val = Array.getInt(inValues, i);
            for (int j = 0; j < nMembers; ++j) {
                if (val != values[j]) continue;
                outNames[i] = names[j];
                continue block2;
            }
        }
        return outNames;
    }

    public static final int[] convertEnumNameToValue(int tid, String[] in, int[] out) throws HDF5Exception {
        int i;
        int size = 0;
        if (in == null || (size = Array.getLength(in)) <= 0 || out != null && size != Array.getLength(out)) {
            return null;
        }
        int nMembers = H5.H5Tget_nmembers((int)tid);
        if (nMembers <= 0) {
            return null;
        }
        if (out == null) {
            out = new int[size];
        } else {
            for (int i2 = 0; i2 < size; ++i2) {
                out[i2] = -1;
            }
        }
        String[] names = new String[nMembers];
        int[] values = new int[nMembers];
        int[] theValue = new int[]{0};
        for (i = 0; i < nMembers; ++i) {
            names[i] = H5.H5Tget_member_name((int)tid, (int)i);
            H5.H5Tget_member_value((int)tid, (int)i, (int[])theValue);
            values[i] = theValue[0];
        }
        block2: for (i = 0; i < size; ++i) {
            if (in[i] == null || in[i].length() <= 0) continue;
            for (int j = 0; j < nMembers; ++j) {
                if (!in[i].equalsIgnoreCase(names[j])) continue;
                out[i] = values[j];
                continue block2;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromNative(int tid) {
        int tclass = -1;
        int tsize = -1;
        boolean isChar = false;
        boolean isUchar = false;
        try {
            tclass = H5.H5Tget_class((int)tid);
            tsize = H5.H5Tget_size((int)tid);
            this.isVLEN = tclass == HDF5Constants.H5T_VLEN;
        }
        catch (Exception ex) {
            this.datatypeClass = -1;
        }
        try {
            isUchar = H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_NATIVE_UCHAR);
            isChar = H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_NATIVE_CHAR) || isUchar;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tclass == HDF5Constants.H5T_ARRAY) {
            int tmptid = -1;
            this.datatypeClass = 10;
            try {
                int ndims = H5.H5Tget_array_ndims((int)tid);
                this.dims = new long[ndims];
                H5.H5Tget_array_dims((int)tid, (long[])this.dims);
                tmptid = H5.H5Tget_super((int)tid);
                this.baseType = new H5Datatype(tmptid);
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Tclose((int)tmptid);
                }
                catch (Exception ex) {}
            }
        } else if (isChar) {
            this.datatypeClass = 2;
            if (isUchar) {
                this.datatypeSign = 0;
            }
        } else if (tclass == HDF5Constants.H5T_INTEGER) {
            this.datatypeClass = 0;
            try {
                int tsign = H5.H5Tget_sign((int)tid);
                if (tsign == HDF5Constants.H5T_SGN_NONE) {
                    this.datatypeSign = 0;
                }
            }
            catch (Exception ex) {}
        } else if (tclass == HDF5Constants.H5T_FLOAT) {
            this.datatypeClass = 1;
        } else if (tclass == HDF5Constants.H5T_STRING) {
            try {
                this.isVLEN = H5.H5Tis_variable_str((int)tid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.datatypeClass = 3;
        } else if (tclass == HDF5Constants.H5T_REFERENCE) {
            this.datatypeClass = 7;
        } else if (tclass == HDF5Constants.H5T_ENUM) {
            this.datatypeClass = 8;
            try {
                int nMember = H5.H5Tget_nmembers((int)tid);
                String name = null;
                int[] val = new int[1];
                String enumStr = "";
                for (int i = 0; i < nMember; ++i) {
                    name = H5.H5Tget_member_name((int)tid, (int)i);
                    H5.H5Tget_member_value((int)tid, (int)i, (int[])val);
                    enumStr = enumStr + name + "=" + val[0] + ",";
                }
                this.enumMembers = enumStr;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.datatypeSize = this.isVLEN ? -1 : tsize;
        this.datatypeOrder = -1;
    }

    @Deprecated
    public static int toNative(int tid) {
        int native_type = -1;
        try {
            native_type = H5.H5Tget_native_type((int)tid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (H5.H5Tis_variable_str((int)tid)) {
                H5.H5Tset_size((int)native_type, (int)HDF5Constants.H5T_VARIABLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return native_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toNative() {
        int tid = -1;
        int tmptid = -1;
        if (this.isNamed) {
            try {
                tid = H5.H5Topen((int)this.getFID(), (String)(this.getPath() + this.getName()), (int)HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (tid >= 0) {
            return tid;
        }
        try {
            switch (this.datatypeClass) {
                case 10: {
                    try {
                        tmptid = this.baseType.toNative();
                        tid = H5.H5Tarray_create((int)tmptid, (int)this.dims.length, (long[])this.dims);
                        break;
                    }
                    finally {
                        this.close(tmptid);
                    }
                }
                case 0: 
                case 8: {
                    tid = this.datatypeSize == 1 ? H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT8) : (this.datatypeSize == 2 ? H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT16) : (this.datatypeSize == 4 ? H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT32) : (this.datatypeSize == 8 ? H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT64) : H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_INT))));
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order((int)tid, (int)HDF5Constants.H5T_ORDER_BE);
                    } else if (this.datatypeOrder == 0) {
                        H5.H5Tset_order((int)tid, (int)HDF5Constants.H5T_ORDER_LE);
                    }
                    if (this.datatypeSign != 0) break;
                    H5.H5Tset_sign((int)tid, (int)HDF5Constants.H5T_SGN_NONE);
                    break;
                }
                case 1: {
                    tid = this.datatypeSize == 8 ? H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_DOUBLE) : H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_FLOAT);
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order((int)tid, (int)HDF5Constants.H5T_ORDER_BE);
                        break;
                    }
                    if (this.datatypeOrder != 0) break;
                    H5.H5Tset_order((int)tid, (int)HDF5Constants.H5T_ORDER_LE);
                    break;
                }
                case 2: {
                    if (this.datatypeSign == 0) {
                        tid = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_UCHAR);
                        break;
                    }
                    tid = H5.H5Tcopy((int)HDF5Constants.H5T_NATIVE_CHAR);
                    break;
                }
                case 3: {
                    tid = H5.H5Tcopy((int)HDF5Constants.H5T_C_S1);
                    if (this.isVLEN || this.datatypeSize < 0) {
                        H5.H5Tset_size((int)tid, (int)HDF5Constants.H5T_VARIABLE);
                        break;
                    }
                    H5.H5Tset_size((int)tid, (int)this.datatypeSize);
                    break;
                }
                case 7: {
                    tid = this.datatypeSize > H5.H5Tget_size((int)HDF5Constants.H5T_STD_REF_OBJ) ? H5.H5Tcopy((int)HDF5Constants.H5T_STD_REF_DSETREG) : H5.H5Tcopy((int)HDF5Constants.H5T_STD_REF_OBJ);
                }
            }
        }
        catch (Exception ex) {
            tid = -1;
        }
        if (this.datatypeClass == 8) {
            int ptid = tid;
            try {
                tid = H5.H5Tenum_create((int)ptid);
                int memval = 0;
                StringTokenizer token = this.enumMembers == null ? new StringTokenizer("0,1", ",") : new StringTokenizer(this.enumMembers, ",");
                while (token.hasMoreTokens()) {
                    String memname;
                    String memstr = token.nextToken();
                    if (memstr != null) {
                        memstr = memstr.trim();
                    }
                    if (memstr == null || memstr.length() < 1) continue;
                    int idx = memstr.indexOf(61);
                    if (idx > 0) {
                        memname = memstr.substring(0, idx);
                        memval = Integer.parseInt(memstr.substring(idx + 1));
                    } else {
                        memname = memstr;
                        ++memval;
                    }
                    H5.H5Tenum_insert((int)tid, (String)memname, (int)memval);
                }
            }
            catch (Exception ex) {
                tid = -1;
            }
            try {
                H5.H5Tclose((int)ptid);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object allocateArray(int tid, int size) throws OutOfMemoryError {
        Object data = null;
        boolean isVL = false;
        boolean is_variable_str = false;
        boolean is_reg_ref = false;
        if (size < 0) {
            return null;
        }
        if (size == 0) {
            size = 1;
        }
        int tclass = -1;
        int tsize = -1;
        int tsign = -1;
        try {
            tclass = H5.H5Tget_class((int)tid);
            tsize = H5.H5Tget_size((int)tid);
            tsign = H5.H5Tget_sign((int)tid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            is_variable_str = H5.H5Tis_variable_str((int)tid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            isVL = tclass == HDF5Constants.H5T_VLEN;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            is_reg_ref = H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_STD_REF_DSETREG);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (is_variable_str || isVL || is_reg_ref) {
            data = new String[size];
            for (int i = 0; i < size; ++i) {
                data[i] = "";
            }
        } else if (tclass == HDF5Constants.H5T_INTEGER) {
            if (tsize == 1) {
                data = new byte[size];
            } else if (tsize == 2) {
                data = new short[size];
            } else if (tsize == 4) {
                data = new int[size];
            } else if (tsize == 8) {
                data = new long[size];
            }
        } else if (tclass == HDF5Constants.H5T_ENUM) {
            int superTid = -1;
            try {
                superTid = H5.H5Tget_super((int)tid);
                data = H5Datatype.allocateArray(superTid, size);
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Tclose((int)superTid);
                }
                catch (Exception ex) {}
            }
        } else if (tclass == HDF5Constants.H5T_FLOAT) {
            if (tsize == 4) {
                data = new float[size];
            } else if (tsize == 8) {
                data = new double[size];
            }
        } else if (tclass == HDF5Constants.H5T_STRING || tclass == HDF5Constants.H5T_REFERENCE || tclass == HDF5Constants.H5T_BITFIELD) {
            data = new byte[size * tsize];
        } else if (tclass == HDF5Constants.H5T_ARRAY) {
            int superTid = -1;
            try {
                int mn = H5.H5Tget_array_ndims((int)tid);
                long[] marray = new long[mn];
                H5.H5Tget_array_dims((int)tid, (long[])marray);
                int asize = 1;
                for (int j = 0; j < mn; ++j) {
                    asize = (int)((long)asize * marray[j]);
                }
                superTid = H5.H5Tget_super((int)tid);
                data = H5Datatype.allocateArray(superTid, size * asize);
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Tclose((int)superTid);
                }
                catch (Exception ex) {}
            }
        } else {
            data = null;
        }
        return data;
    }

    public static final int getDatatypeSize(int tid) {
        int tsize = -1;
        try {
            tsize = H5.H5Tget_size((int)tid);
        }
        catch (Exception ex) {
            tsize = -1;
        }
        return tsize;
    }

    public String getDatatypeDescription() {
        if (this.description == null) {
            int tid = this.toNative();
            this.description = H5Datatype.getDatatypeDescription(tid);
            this.close(tid);
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getDatatypeDescription(int tid) {
        String description;
        block75: {
            description = "Unknown";
            int tclass = -1;
            int tsize = -1;
            int tsign = -1;
            int torder = -1;
            try {
                tclass = H5.H5Tget_class((int)tid);
                tsize = H5.H5Tget_size((int)tid);
                tsign = H5.H5Tget_sign((int)tid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (tclass == HDF5Constants.H5T_INTEGER) {
                if (tsize == 1) {
                    try {
                        if (H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_NATIVE_UCHAR)) {
                            description = "8-bit unsigned character";
                            break block75;
                        }
                        if (H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_NATIVE_CHAR)) {
                            description = "8-bit character";
                            break block75;
                        }
                        if (tsign == HDF5Constants.H5T_SGN_NONE) {
                            description = "8-bit unsigned integer";
                            break block75;
                        }
                        description = "8-bit integer";
                    }
                    catch (Exception ex) {
                        description = "Unknown";
                    }
                } else if (tsize == 2) {
                    description = tsign == HDF5Constants.H5T_SGN_NONE ? "16-bit unsigned integer" : "16-bit integer";
                } else if (tsize == 4) {
                    description = tsign == HDF5Constants.H5T_SGN_NONE ? "32-bit unsigned integer" : "32-bit integer";
                } else if (tsize == 8) {
                    description = tsign == HDF5Constants.H5T_SGN_NONE ? "64-bit unsigned integer" : "64-bit integer";
                }
            } else if (tclass == HDF5Constants.H5T_FLOAT) {
                if (tsize == 4) {
                    description = "32-bit floating-point";
                } else if (tsize == 8) {
                    description = "64-bit floating-point";
                }
            } else if (tclass == HDF5Constants.H5T_STRING) {
                try {
                    if (H5.H5Tis_variable_str((int)tid)) {
                        description = "String, length = variable";
                        break block75;
                    }
                    description = "String, length = " + H5.H5Tget_size((int)tid);
                }
                catch (Exception ex) {
                    description = "String";
                }
            } else if (tclass == HDF5Constants.H5T_REFERENCE) {
                boolean is_reg_ref = false;
                try {
                    is_reg_ref = H5.H5Tequal((int)tid, (int)HDF5Constants.H5T_STD_REF_DSETREG);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                description = is_reg_ref ? "Dataset region reference" : "Object reference";
            } else if (tclass == HDF5Constants.H5T_BITFIELD) {
                description = "Bitfield";
            } else if (tclass == HDF5Constants.H5T_ENUM) {
                description = "enum";
                String enames = " ( ";
                int[] evalue = new int[]{0};
                try {
                    int n = H5.H5Tget_nmembers((int)tid);
                    for (int i = 0; i < n; ++i) {
                        H5.H5Tget_member_value((int)tid, (int)i, (int[])evalue);
                        enames = enames + H5.H5Tget_member_name((int)tid, (int)i);
                        enames = enames + "=" + evalue[0] + "  ";
                    }
                    enames = enames + ")";
                    description = description + enames;
                }
                catch (Exception ex) {}
            } else if (tclass == HDF5Constants.H5T_ARRAY) {
                description = "Array of ";
                int tmptid = -1;
                try {
                    tmptid = H5.H5Tget_super((int)tid);
                    description = description + H5Datatype.getDatatypeDescription(tmptid);
                    int ndims = H5.H5Tget_array_ndims((int)tid);
                    long[] adims = new long[ndims];
                    try {
                        H5.H5Tget_array_dims((int)tid, (long[])adims);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    description = description + " (" + adims[0];
                    for (int j = 1; j < ndims; ++j) {
                        description = description + "x" + adims[j];
                    }
                    description = description + ")";
                }
                catch (Exception ex) {
                }
                finally {
                    try {
                        H5.H5Tclose((int)tmptid);
                    }
                    catch (Exception ex) {}
                }
            } else if (tclass == HDF5Constants.H5T_COMPOUND) {
                description = "Compound ";
                try {
                    description = description + "{";
                    int n = H5.H5Tget_nmembers((int)tid);
                    int mtid = 0;
                    try {
                        H5.H5Tclose((int)mtid);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    for (int i = 0; i < n; ++i) {
                        mtid = H5.H5Tget_member_type((int)tid, (int)i);
                        description = description + H5Datatype.getDatatypeDescription(mtid) + ", ";
                        try {
                            H5.H5Tclose((int)mtid);
                            continue;
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    description = description + "}";
                }
                catch (Exception ex) {}
            } else if (tclass == HDF5Constants.H5T_VLEN) {
                int tmptid = -1;
                try {
                    tmptid = H5.H5Tget_super((int)tid);
                    description = "Variable-length of " + H5Datatype.getDatatypeDescription(tmptid);
                }
                catch (Exception ex) {
                    description = "Variable-length";
                }
                finally {
                    try {
                        H5.H5Tclose((int)tmptid);
                    }
                    catch (Exception ex) {}
                }
            } else {
                description = tclass == HDF5Constants.H5T_OPAQUE ? "Opaque" : "Unknown";
            }
        }
        return description;
    }

    public boolean isUnsigned() {
        return H5Datatype.isUnsigned(this.toNative());
    }

    public static final boolean isUnsigned(int datatype) {
        boolean unsigned = false;
        try {
            int tsign = H5.H5Tget_sign((int)datatype);
            if (tsign == HDF5Constants.H5T_SGN_NONE) {
                unsigned = true;
            }
        }
        catch (Exception ex) {
            unsigned = false;
        }
        return unsigned;
    }

    public int open() {
        int tid = -1;
        try {
            tid = H5.H5Topen((int)this.getFID(), (String)(this.getPath() + this.getName()), (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            tid = -1;
        }
        return tid;
    }

    public void close(int tid) {
        try {
            H5.H5Tclose((int)tid);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    public List<Attribute> getMetadata() throws HDF5Exception {
        return this.getMetadata(this.fileFormat.getIndexType(null), this.fileFormat.getIndexOrder(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getMetadata(int ... attrPropList) throws HDF5Exception {
        if (this.attributeList == null) {
            int tid = this.open();
            int indxType = this.fileFormat.getIndexType(null);
            int order = this.fileFormat.getIndexOrder(null);
            if (attrPropList.length > 0) {
                indxType = attrPropList[0];
                if (attrPropList.length > 1) {
                    order = attrPropList[1];
                }
            }
            try {
                this.attributeList = H5File.getAttribute(tid, indxType, order);
            }
            catch (Exception ex) {
            }
            finally {
                this.close(tid);
            }
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName((HObject)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.attributeList;
    }

    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        boolean attrExisted = false;
        Attribute attr = (Attribute)info;
        String name = attr.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            attrExisted = this.attributeList.contains(attr);
        }
        this.getFileFormat().writeAttribute((HObject)this, attr, attrExisted);
        if (!attrExisted) {
            this.attributeList.add(attr);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(Object info) throws HDF5Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        Attribute attr = (Attribute)info;
        int tid = this.open();
        try {
            H5.H5Adelete((int)tid, (String)attr.getName());
            List<Attribute> attrList = this.getMetadata();
            attrList.remove(attr);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(tid);
        }
    }

    public void setName(String newName) throws Exception {
        H5File.renameObject((HObject)this, newName);
        super.setName(newName);
    }
}

