/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.demo;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.util.OS;
import org.jdesktop.xswingx.NativeSearchFieldSupport;
import org.jdesktop.xswingx.demo.CustomizePanel;
import org.jdesktop.xswingx.demo.InsetsFormatter;
import org.jdesktop.xswingx.demo.TitledSeparator;

public class CustomizeGeneralPanel
extends CustomizePanel {
    private final DefaultFormatterFactory ff = new DefaultFormatterFactory(new InsetsFormatter());
    private TitledSeparator titledSeparator1;
    private JPanel panel3;
    private JLabel label5;
    private JRadioButton rbDefault;
    private JRadioButton rbLine;
    private JSlider lineSlider;
    private JLabel label1;
    private JFormattedTextField txtMargin;
    private JButton btnReset;
    private JLabel label3;
    private JRadioButton rbLeading;
    private JRadioButton rbCenter;
    private JRadioButton rbTrailing;
    private JCheckBox cbFixedSize;
    private JSpinner spColumns;
    private JLabel label2;
    private JPanel panel1;
    private JCheckBox cbEnabled;
    private JCheckBox cbEditable;
    private JCheckBox cbOpaque;

    public CustomizeGeneralPanel() {
        this.initComponents();
    }

    public void setField(JTextComponent textComponent) {
        super.setField(textComponent);
        this.cbOpaque.setSelected(textComponent.isOpaque());
        this.txtMargin.setFormatterFactory(this.ff);
        this.txtMargin.setValue(textComponent.getMargin());
        if (OS.isMacOSX() && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            this.cbOpaque.setSelected(false);
        } else {
            this.cbOpaque.setSelected(true);
        }
        this.columnsChanged(null);
        if (!(textComponent instanceof JTextField)) {
            this.rbLeading.setEnabled(false);
            this.rbCenter.setEnabled(false);
            this.rbTrailing.setEnabled(false);
            this.cbFixedSize.setEnabled(false);
        }
    }

    private void rbBorderStateChanged(ChangeEvent e) {
        if (this.rbDefault.isSelected()) {
            this.getField().setBorder(UIManager.getBorder("TextField.border"));
            if (this.getField() instanceof JTextField) {
                JTextField field = (JTextField)this.getField();
                NativeSearchFieldSupport.setSearchField(field, NativeSearchFieldSupport.isSearchField(field));
            }
        } else {
            this.getField().setBorder(new LineBorder(Color.BLACK, this.lineSlider.getValue()));
        }
        this.changed();
    }

    private void marginChange(PropertyChangeEvent e) {
        this.getField().setMargin((Insets)this.txtMargin.getValue());
        this.changed();
    }

    private void opaqueChanged(ChangeEvent e) {
        this.getField().setOpaque(this.cbOpaque.isSelected());
        this.changed();
    }

    private void columnsChanged(ChangeEvent e) {
        if (this.getField() instanceof JTextField) {
            JTextField field = (JTextField)this.getField();
            if (this.cbFixedSize.isSelected()) {
                field.setColumns((Integer)this.spColumns.getValue());
            } else {
                field.setColumns(0);
            }
            this.changed();
        }
    }

    private void alignmentChanged(ChangeEvent e) {
        if (this.getField() instanceof JTextField) {
            JTextField field = (JTextField)this.getField();
            if (this.rbCenter.isSelected()) {
                field.setHorizontalAlignment(0);
            } else if (this.rbTrailing.isSelected()) {
                field.setHorizontalAlignment(11);
            } else {
                field.setHorizontalAlignment(10);
            }
            this.changed();
        }
    }

    private void cbEnabledStateChanged(ChangeEvent e) {
        this.getField().setEnabled(this.cbEnabled.isSelected());
    }

    private void cbEditableStateChanged(ChangeEvent e) {
        this.getField().setEditable(this.cbEditable.isSelected());
    }

    private void btnResetActionPerformed(ActionEvent e) {
        this.getField().setMargin(UIManager.getInsets("TextField.margin"));
        this.setField(this.getField());
    }

    private void initComponents() {
        this.titledSeparator1 = new TitledSeparator();
        this.panel3 = new JPanel();
        this.label5 = new JLabel();
        this.rbDefault = new JRadioButton();
        this.rbLine = new JRadioButton();
        this.lineSlider = new JSlider();
        this.label1 = new JLabel();
        this.txtMargin = new JFormattedTextField();
        this.btnReset = new JButton();
        this.label3 = new JLabel();
        this.rbLeading = new JRadioButton();
        this.rbCenter = new JRadioButton();
        this.rbTrailing = new JRadioButton();
        this.cbFixedSize = new JCheckBox();
        this.spColumns = new JSpinner();
        this.label2 = new JLabel();
        this.panel1 = new JPanel();
        this.cbEnabled = new JCheckBox();
        this.cbEditable = new JCheckBox();
        this.cbOpaque = new JCheckBox();
        CellConstraints cc = new CellConstraints();
        this.setBorder(null);
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.titledSeparator1.setTitle("General");
        this.add((Component)this.titledSeparator1, cc.xywh(1, 1, 6, 1));
        this.panel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label5.setText("Border:");
        this.panel3.add((Component)this.label5, cc.xy(1, 1));
        this.rbDefault.setText("Default");
        this.rbDefault.setSelected(true);
        this.rbDefault.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.rbBorderStateChanged(e);
            }
        });
        this.panel3.add((Component)this.rbDefault, cc.xywh(3, 1, 7, 1));
        this.rbLine.setText("Line:");
        this.rbLine.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.rbBorderStateChanged(e);
            }
        });
        this.panel3.add((Component)this.rbLine, cc.xy(3, 3));
        this.lineSlider.setMaximum(10);
        this.lineSlider.setValue(1);
        this.lineSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.rbBorderStateChanged(e);
            }
        });
        this.panel3.add((Component)this.lineSlider, cc.xywh(5, 3, 7, 1));
        this.label1.setText("Margin:");
        this.panel3.add((Component)this.label1, cc.xy(1, 5));
        this.txtMargin.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                CustomizeGeneralPanel.this.marginChange(e);
            }
        });
        this.panel3.add((Component)this.txtMargin, cc.xywh(3, 5, 7, 1));
        this.btnReset.setText("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeGeneralPanel.this.btnResetActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.btnReset, cc.xy(11, 5));
        this.label3.setText("Alignment:");
        this.panel3.add((Component)this.label3, cc.xy(1, 7));
        this.rbLeading.setText("Leading");
        this.rbLeading.setSelected(true);
        this.rbLeading.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.alignmentChanged(e);
            }
        });
        this.panel3.add((Component)this.rbLeading, cc.xy(3, 7));
        this.rbCenter.setText("Center");
        this.rbCenter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.alignmentChanged(e);
            }
        });
        this.panel3.add((Component)this.rbCenter, cc.xy(5, 7));
        this.rbTrailing.setText("Trailing");
        this.rbTrailing.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.alignmentChanged(e);
            }
        });
        this.panel3.add((Component)this.rbTrailing, cc.xy(7, 7));
        this.add((Component)this.panel3, cc.xywh(2, 3, 5, 1));
        this.cbFixedSize.setText("Fixed Size:");
        this.cbFixedSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.columnsChanged(e);
            }
        });
        this.add((Component)this.cbFixedSize, cc.xy(2, 5));
        this.spColumns.setModel(new SpinnerNumberModel(15, 0, 80, 1));
        this.spColumns.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.columnsChanged(e);
            }
        });
        this.add((Component)this.spColumns, cc.xy(4, 5));
        this.label2.setText("Columns");
        this.add((Component)this.label2, cc.xy(6, 5));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0)}, RowSpec.decodeSpecs((String)"default")));
        this.cbEnabled.setText("Enabled");
        this.cbEnabled.setSelected(true);
        this.cbEnabled.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.cbEnabledStateChanged(e);
            }
        });
        this.panel1.add((Component)this.cbEnabled, cc.xy(1, 1));
        this.cbEditable.setText("Editable");
        this.cbEditable.setSelected(true);
        this.cbEditable.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.cbEditableStateChanged(e);
            }
        });
        this.panel1.add((Component)this.cbEditable, cc.xy(3, 1));
        this.cbOpaque.setText("Opaque");
        this.cbOpaque.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeGeneralPanel.this.opaqueChanged(e);
            }
        });
        this.panel1.add((Component)this.cbOpaque, cc.xy(5, 1));
        this.add((Component)this.panel1, cc.xywh(2, 7, 5, 1));
        ButtonGroup grpBorder = new ButtonGroup();
        grpBorder.add(this.rbDefault);
        grpBorder.add(this.rbLine);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.rbLeading);
        buttonGroup1.add(this.rbCenter);
        buttonGroup1.add(this.rbTrailing);
    }
}

