/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import ncsa.hdf.object.Datatype;
import ucar.ma2.DataType;

public class NC2Datatype
extends Datatype {
    private static final long serialVersionUID = 5399364372073889764L;
    DataType nativeType = null;

    public NC2Datatype(int tclass, int tsize, int torder, int tsign) {
        super(tclass, tsize, torder, tsign);
    }

    public boolean hasAttribute() {
        return false;
    }

    public NC2Datatype(DataType theType) {
        super(-1);
        this.nativeType = theType;
        this.fromNative(0);
    }

    public static Object allocateArray(DataType dtype, int size) throws OutOfMemoryError {
        Object[] data = null;
        if (size <= 0 || dtype == null) {
            return null;
        }
        if (dtype.equals((Object)DataType.BYTE)) {
            data = new byte[size];
        } else if (dtype.equals((Object)DataType.SHORT)) {
            data = new short[size];
        } else if (dtype.equals((Object)DataType.INT)) {
            data = new int[size];
        } else if (dtype.equals((Object)DataType.LONG)) {
            data = new long[size];
        } else if (dtype.equals((Object)DataType.FLOAT)) {
            data = new float[size];
        } else if (dtype.equals((Object)DataType.DOUBLE)) {
            data = new double[size];
        } else if (dtype.equals((Object)DataType.STRING)) {
            data = new String[size];
        }
        return data;
    }

    public void fromNative(int tid) {
        if (this.nativeType == null) {
            return;
        }
        this.datatypeOrder = -1;
        if (this.nativeType.equals((Object)DataType.BYTE)) {
            this.datatypeClass = 0;
            this.datatypeSize = 1;
        } else if (this.nativeType.equals((Object)DataType.SHORT)) {
            this.datatypeClass = 0;
            this.datatypeSize = 2;
        } else if (this.nativeType.equals((Object)DataType.INT)) {
            this.datatypeClass = 0;
            this.datatypeSize = 4;
        } else if (this.nativeType.equals((Object)DataType.LONG)) {
            this.datatypeClass = 0;
            this.datatypeSize = 8;
        } else if (this.nativeType.equals((Object)DataType.FLOAT)) {
            this.datatypeClass = 1;
            this.datatypeSize = 4;
        } else if (this.nativeType.equals((Object)DataType.DOUBLE)) {
            this.datatypeClass = 1;
            this.datatypeSize = 8;
        } else if (this.nativeType.equals((Object)DataType.STRING)) {
            this.datatypeClass = 3;
            this.datatypeSize = 80;
        }
    }

    public String getDatatypeDescription() {
        if (this.nativeType == null) {
            return "Unknown data type.";
        }
        return this.nativeType.toString();
    }

    public boolean isUnsigned() {
        return false;
    }

    public int toNative() {
        if (this.datatypeClass == 0) {
            if (this.datatypeSize == 1) {
                this.nativeType = DataType.BYTE;
            } else if (this.datatypeSize == 2) {
                this.nativeType = DataType.SHORT;
            } else if (this.datatypeSize == 4) {
                this.nativeType = DataType.INT;
            } else if (this.datatypeSize == 8) {
                this.nativeType = DataType.LONG;
            }
        } else if (this.datatypeClass == 1) {
            if (this.datatypeSize == 4) {
                this.nativeType = DataType.FLOAT;
            } else if (this.datatypeSize == 8) {
                this.nativeType = DataType.DOUBLE;
            }
        } else if (this.datatypeClass == 3) {
            this.nativeType = DataType.STRING;
        }
        return -1;
    }

    public void close(int id) {
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

