/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.optimizers.particleswarm;

import java.util.Arrays;
import java.util.Random;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.jgrasstools.gears.utils.optimizers.particleswarm.IPSFunction;
import org.jgrasstools.gears.utils.optimizers.particleswarm.Particle;

public class PSEngine {
    private double accelerationFactorLocal;
    private double accelerationFactorGlobal;
    private double initDecelerationFactor;
    private int maxIterations;
    private double decayFactor;
    private int particlesNum;
    private Particle[] swarm;
    private double globalBest;
    private double[] globalBestLocations;
    private IPSFunction function;
    private int iterationStep;
    private Random rand;
    private double[][] ranges;
    private String prefix;

    public PSEngine(int particlesNum, int maxIterations, double accelerationFactorLocal, double accelerationFactorGlobal, double initDecelerationFactor, double decayFactor, IPSFunction function, String prefix) {
        this.particlesNum = particlesNum;
        this.accelerationFactorLocal = accelerationFactorLocal;
        this.accelerationFactorGlobal = accelerationFactorGlobal;
        this.initDecelerationFactor = initDecelerationFactor;
        this.decayFactor = decayFactor;
        this.maxIterations = maxIterations;
        this.function = function;
        this.prefix = prefix;
    }

    public void initializeRanges(double[] ... ranges) {
        this.ranges = ranges;
    }

    public void run() throws Exception {
        if (this.ranges == null) {
            throw new ModelsIllegalargumentException("No ranges have been defined for the parameter space.", this);
        }
        this.createSwarm();
        double[] previous = null;
        while (this.iterationStep <= this.maxIterations) {
            this.updateSwarm();
            if (this.printStep()) {
                System.out.println(this.prefix + " - ITER: " + this.iterationStep + " global best: " + this.globalBest + " - for positions: " + Arrays.toString(this.globalBestLocations));
            }
            if (this.function.hasConverged(this.globalBest, this.globalBestLocations, previous)) break;
            previous = (double[])this.globalBestLocations.clone();
        }
    }

    private boolean printStep() {
        if (this.maxIterations > 10000) {
            if (this.iterationStep % 1000 == 0) {
                return true;
            }
        } else if (this.maxIterations > 1000) {
            if (this.iterationStep % 100 == 0) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public double[] getSolution() {
        return (double[])this.globalBestLocations.clone();
    }

    public double getSolutionFittingValue() {
        return this.globalBest;
    }

    private void createSwarm() throws Exception {
        this.rand = new Random();
        this.iterationStep = 0;
        this.globalBest = this.function.getInitialGlobalBest();
        this.swarm = new Particle[this.particlesNum];
        for (int j = 0; j < this.swarm.length; ++j) {
            this.swarm[j] = new Particle(this.ranges);
            double[] currentLocations = this.swarm[j].getInitialLocations();
            double evaluated = this.function.evaluate(this.iterationStep, j, currentLocations, this.ranges);
            this.swarm[j].setParticleBestFunction(evaluated);
            if (this.function.isBetter(evaluated, this.globalBest)) {
                this.globalBest = evaluated;
                if (this.globalBestLocations == null) {
                    this.globalBestLocations = new double[currentLocations.length];
                }
                for (int k = 0; k < currentLocations.length; ++k) {
                    this.globalBestLocations[k] = currentLocations[k];
                }
                continue;
            }
            if (this.globalBestLocations != null) continue;
            throw new RuntimeException("No evaluated value found better than the initial global best: " + evaluated + " vs. " + this.globalBest);
        }
    }

    private void updateSwarm() throws Exception {
        ++this.iterationStep;
        double w = this.initDecelerationFactor * Math.pow(this.iterationStep, -this.decayFactor);
        for (int i = 0; i < this.swarm.length; ++i) {
            Particle particle = this.swarm[i];
            double[] currentLocations = particle.update(w, this.accelerationFactorLocal, this.rand.nextDouble(), this.accelerationFactorGlobal, this.rand.nextDouble(), this.globalBestLocations);
            if (currentLocations == null) continue;
            double evaluated = this.function.evaluate(this.iterationStep, i, currentLocations, this.ranges);
            if (this.function.isBetter(evaluated, particle.getParticleBestFunction())) {
                particle.setParticleBestFunction(evaluated);
                particle.setParticleLocalBeststoCurrent();
            }
            if (!this.function.isBetter(evaluated, this.globalBest)) continue;
            this.globalBest = evaluated;
            for (int j = 0; j < currentLocations.length; ++j) {
                this.globalBestLocations[j] = currentLocations[j];
            }
        }
    }

    public static boolean parametersInRange(double[] parameters, double[] ... ranges) {
        for (int i = 0; i < ranges.length; ++i) {
            if (NumericsUtilities.isBetween(parameters[i], ranges[i])) continue;
            return false;
        }
        return true;
    }
}

