/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.interpolation.splines;

import org.jgrasstools.gears.utils.math.interpolation.splines.Cubic;
import org.jgrasstools.gears.utils.math.interpolation.splines.NatCubic;

public class NatCubicClosed
extends NatCubic {
    @Override
    public Cubic[] calcNaturalCubic(int n, double[] x) {
        int k;
        double[] w = new double[n + 1];
        double[] v = new double[n + 1];
        double[] y = new double[n + 1];
        double[] D = new double[n + 1];
        double z = 0.25;
        v[1] = 0.25;
        w[1] = 0.25;
        y[0] = z * 3.0 * (x[1] - x[n]);
        double H = 4.0;
        double F = 3.0 * (x[0] - x[n - 1]);
        double G = 1.0;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0 / (4.0 - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * (3.0 * (x[k + 1] - x[k - 1]) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        Cubic[] C = new Cubic[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new Cubic(x[k], D[k], 3.0 * (x[k + 1] - x[k]) - 2.0 * D[k] - D[k + 1], 2.0 * (x[k] - x[k + 1]) + D[k] + D[k + 1]);
        }
        C[n] = new Cubic(x[n], D[n], 3.0 * (x[0] - x[n]) - 2.0 * D[n] - D[0], 2.0 * (x[n] - x[0]) + D[n] + D[0]);
        return C;
    }
}

