/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.interpolation.splines;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;
import org.jgrasstools.gears.utils.math.interpolation.splines.ControlCurve;
import org.jgrasstools.gears.utils.math.interpolation.splines.Cubic;

public class NatCubic
extends ControlCurve {
    final int STEPS = 12;

    public Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    @Override
    public List<Coordinate> getInterpolated() {
        ArrayList<Coordinate> p = new ArrayList<Coordinate>();
        if (this.pts.size() >= 2) {
            double[] xs = new double[this.pts.size()];
            double[] ys = new double[this.pts.size()];
            for (int i = 0; i < xs.length; ++i) {
                Coordinate coordinate = (Coordinate)this.pts.get(i);
                xs[i] = coordinate.x;
                ys[i] = coordinate.y;
            }
            Cubic[] X = this.calcNaturalCubic(this.pts.size() - 1, xs);
            Cubic[] Y = this.calcNaturalCubic(this.pts.size() - 1, ys);
            p.add(new Coordinate(X[0].eval(0.0), Y[0].eval(0.0)));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    double u = (double)j / 12.0;
                    p.add(new Coordinate(X[i].eval(u), Y[i].eval(u)));
                }
            }
        }
        return p;
    }
}

