/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.interpolation.splines;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.List;

public abstract class ControlCurve {
    public static final int EPSILON = 36;
    protected List<Coordinate> pts = new ArrayList<Coordinate>();
    protected int selection = -1;

    public int selectPoint(double x, double y) {
        double mind = Double.POSITIVE_INFINITY;
        this.selection = -1;
        for (int i = 0; i < this.pts.size(); ++i) {
            Coordinate coordinate = this.pts.get(i);
            double d = ControlCurve.sqr(coordinate.x - x) + ControlCurve.sqr(coordinate.y - y);
            if (!(d < mind) || !(d < 36.0)) continue;
            mind = d;
            this.selection = i;
        }
        return this.selection;
    }

    static double sqr(double x) {
        return x * x;
    }

    public double addPoint(double x, double y) {
        this.pts.add(new Coordinate(x, y));
        this.selection = this.pts.size() - 1;
        return this.selection;
    }

    public void setPoint(double x, double y) {
        if (this.selection >= 0) {
            Coordinate coordinate = new Coordinate(x, y);
            this.pts.set(this.selection, coordinate);
        }
    }

    public void removePoint() {
        if (this.selection >= 0) {
            this.pts.remove(this.selection);
        }
    }

    public abstract List<Coordinate> getInterpolated();

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.pts.size(); ++i) {
            result.append(" " + this.pts.get(i));
        }
        return result.toString();
    }
}

