/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jgrasstools.gears.utils.chart.IChart;
import org.jgrasstools.gears.utils.chart.PlotFrame;

public class CategoryBoxplot
implements IChart {
    private String[] categories;
    private List<double[]> values;
    private DefaultBoxAndWhiskerCategoryDataset dataset;
    private boolean isMeanVisible;
    private JFreeChart chart;
    private String title;

    public CategoryBoxplot(String[] categories, List<double[]> values, boolean isMeanVisible) {
        this("Boxplot", categories, values, isMeanVisible);
    }

    public CategoryBoxplot(String title, String[] categories, List<double[]> values, boolean isMeanVisible) {
        this.title = title;
        this.categories = categories;
        this.values = values;
        this.isMeanVisible = isMeanVisible;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void createDataset() {
        this.dataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (int i = 0; i < this.categories.length; ++i) {
            ArrayList<Double> list = new ArrayList<Double>();
            double[] catValues = this.values.get(i);
            for (int j = 0; j < catValues.length; ++j) {
                list.add(catValues[j]);
            }
            this.dataset.add(list, (Comparable)((Object)""), (Comparable)((Object)this.categories[i]));
        }
    }

    @Override
    public JFreeChart getChart() {
        if (this.chart == null) {
            this.createDataset();
            this.chart = ChartFactory.createBarChart((String)this.getTitle(), (String)"Category", (String)"Value", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
            CategoryAxis rangeAxis = plot.getDomainAxis();
            rangeAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
            renderer.setFillBox(true);
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new BoxAndWhiskerToolTipGenerator());
            renderer.setMeanVisible(this.isMeanVisible);
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        return this.chart;
    }

    public static void main(String[] args) {
        String[] asd = new String[]{"a", "b"};
        double[] qwe1 = new double[]{1.0, 2.0, 3.0, 2.5, 5.5, 1.0, 2.0};
        double[] qwe2 = new double[]{10.0, 11.0, 15.0, 12.5, 15.5, 11.0, 12.0};
        List<double[]> asList = Arrays.asList(qwe1, qwe2);
        CategoryBoxplot categoryHistogram = new CategoryBoxplot(asd, asList, false);
        PlotFrame frame = new PlotFrame(categoryHistogram);
        frame.setDimension(1600, 1000);
        frame.plot();
    }
}

