/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.PrintStream;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;

public class PrintUtilities {
    private static String separator = " ";
    private static PrintStream printer = System.out;

    public static void printCoverageData(GridCoverage2D coverage) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter renderedImageIterator = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int[] colsRows = CoverageUtilities.getRegionColsRows(coverage);
        for (int r = 0; r < colsRows[1]; ++r) {
            for (int c = 0; c < colsRows[0]; ++c) {
                printer.print(renderedImageIterator.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
    }

    public static void printCoverageDataAsMatrix(GridCoverage2D coverage) {
        printer.println("double[][] matrix = new double[][]{//");
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter renderedImageIterator = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int[] colsRows = CoverageUtilities.getRegionColsRows(coverage);
        for (int r = 0; r < colsRows[1]; ++r) {
            if (r == 0) {
                printer.print("/*    */{");
            } else {
                printer.print("{");
            }
            for (int c = 0; c < colsRows[0]; ++c) {
                printer.print(renderedImageIterator.getSampleDouble(c, r, 0));
                if (c >= colsRows[0] - 1) continue;
                printer.print(", ");
            }
            if (r < colsRows[1] - 1) {
                printer.println("}, //");
                continue;
            }
            printer.println("} //");
        }
        printer.println("};");
        renderedImageIterator.done();
    }

    public static void printRenderedImageData(RenderedImage renderedImage) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int cols = renderedImage.getWidth();
        int rows = renderedImage.getHeight();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                printer.print(iter.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
        iter.done();
    }

    public static void printWritableRasterData(Raster raster) {
        RandomIter iter = RandomIterFactory.create((Raster)raster, null);
        int cols = raster.getWidth();
        int rows = raster.getHeight();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                printer.print(iter.getSampleDouble(c, r, 0));
                printer.print(separator);
            }
            printer.println();
        }
        iter.done();
    }

    public static void printMatrixData(double[][] matrix) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                printer.print(matrix[r][c]);
                printer.print(separator);
            }
            printer.println();
        }
    }

    public static String envelope2WKT(Envelope env) {
        GeometryFactory gf = GeometryUtilities.gf();
        Geometry geometry = gf.toGeometry(env);
        return geometry.toText();
    }

    public static Envelope envelope2D2Envelope(Envelope2D envelope2d) {
        Envelope jtsEnv = new Envelope(envelope2d.getMinX(), envelope2d.getMaxX(), envelope2d.getMinY(), envelope2d.getMaxY());
        return jtsEnv;
    }

    public static String toString(GridCoverage2D coverage) {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        StringBuilder sb = new StringBuilder();
        sb.append(regionMap.toStringJGT()).append("\n");
        Envelope2D envelope2d = coverage.getEnvelope2D();
        Envelope jtsEnvelope = PrintUtilities.envelope2D2Envelope(envelope2d);
        String envelope2wkt = PrintUtilities.envelope2WKT(jtsEnvelope);
        sb.append("WKT bounds: \n");
        sb.append(envelope2wkt);
        return sb.toString();
    }
}

