/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.spatialite;

import com.vividsolutions.jts.geom.Geometry;

public enum SpatialiteGeometryType {
    GEOMETRY_XY(0, "geometry_xy", null, "CastToXY", null),
    POINT_XY(1, "point_xy", "CastToPoint", "CastToXY", "CastToSingle"),
    LINESTRING_XY(2, "linestring_xy", "CastToLinestring", "CastToXY", "CastToSingle"),
    POLYGON_XY(3, "polygon_xy", "CastToPolygon", "CastToXY", "CastToSingle"),
    MULTIPOINT_XY(4, "multipoint_xy", "CastToMultiPoint", "CastToXY", "CastToMulti"),
    MULTILINESTRING_XY(5, "multilinestring_xy", "CastToMultiLinestring", "CastToXY", "CastToMulti"),
    MULTIPOLYGON_XY(6, "multipolygon_xy", "CastToMultiPolygon", "CastToXY", "CastToMulti"),
    GEOMETRYCOLLECTION_XY(7, "geometrycollection_xy", "CastToGeometyCollection", "CastToXY", null),
    GEOMETRY_XYZ(1000, "geometry_xyz", null, "CastToXYZ", null),
    POINT_XYZ(1001, "point_xyz", "CastToPoint", "CastToXYZ", "CastToSingle"),
    LINESTRING_XYZ(1002, "linestring_xyz", "CastToLinestring", "CastToXYZ", "CastToSingle"),
    POLYGON_XYZ(1003, "polygon_xyz", "CastToPolygon", "CastToXYZ", "CastToSingle"),
    MULTIPOINT_XYZ(1004, "multipoint_xyz", "CastToMultiPoint", "CastToXYZ", "CastToMulti"),
    MULTILINESTRING_XYZ(1005, "multilinestring_xyz", "CastToMultiLinestring", "CastToXYZ", "CastToMulti"),
    MULTIPOLYGON_XYZ(1006, "multipolygon_xyz", "CastToMultiPolygon", "CastToXYZ", "CastToMulti"),
    GEOMETRYCOLLECTION_XYZ(1007, "geometrycollection_xyz", "CastToGeometyCollection", "CastToXYZ", null),
    GEOMETRY_XYM(2000, "geometry_xym", null, "CastToXYM", null),
    POINT_XYM(2001, "point_xym", "CastToPoint", "CastToXYM", "CastToSingle"),
    LINESTRING_XYM(2002, "linestring_xym", "CastToLinestring", "CastToXYM", "CastToSingle"),
    POLYGON_XYM(2003, "polygon_xym", "CastToPolygon", "CastToXYM", "CastToSingle"),
    MULTIPOINT_XYM(2004, "multipoint_xym", "CastToMultiPoint", "CastToXYM", "CastToMulti"),
    MULTILINESTRING_XYM(2005, "multilinestring_xym", "CastToMultiLinestring", "CastToXYM", "CastToMulti"),
    MULTIPOLYGON_XYM(2006, "multipolygon_xym", "CastToMultiPolygon", "CastToXYM", "CastToMulti"),
    GEOMETRYCOLLECTION_XYM(2007, "geometrycollection_xym", "CastToGeometyCollection", "CastToXYM", null),
    GEOMETRY_XYZM(3000, "geometry_xyzm", null, "CastToXYZM", null),
    POINT_XYZM(3001, "point_xyzm", "CastToPoint", "CastToXYZM", "CastToSingle"),
    LINESTRING_XYZM(3002, "linestring_xyzm", "CastToLinestring", "CastToXYZM", "CastToSingle"),
    POLYGON_XYZM(3003, "polygon_xyzm", "CastToPolygon", "CastToXYZM", "CastToSingle"),
    MULTIPOINT_XYZM(3004, "multipoint_xyzm", "CastToMultiPoint", "CastToXYZM", "CastToMulti"),
    MULTILINESTRING_XYZM(3005, "multilinestring_xyzm", "CastToMultiLinestring", "CastToXYZM", "CastToMulti"),
    MULTIPOLYGON_XYZM(3006, "multipolygon_xyzm", "CastToMultiPolygon", "CastToXYZM", "CastToMulti"),
    GEOMETRYCOLLECTION_XYZM(3007, "geometrycollection_xyzm", "CastToGeometyCollection", "CastToXYZM", null);

    private final int type;
    private final String description;
    private String geometryTypeCast;
    private String spaceDimensionsCast;
    private String multiSingleCast;

    private SpatialiteGeometryType(int type, String description, String geometryTypeCast, String spaceDimensionsCast, String multiSingleCast) {
        this.type = type;
        this.description = description;
        this.geometryTypeCast = geometryTypeCast;
        this.spaceDimensionsCast = spaceDimensionsCast;
        this.multiSingleCast = multiSingleCast;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeometryTypeCast() {
        return this.geometryTypeCast;
    }

    public String getSpaceDimensionsCast() {
        return this.spaceDimensionsCast;
    }

    public String getMultiSingleCast() {
        return this.multiSingleCast;
    }

    public static SpatialiteGeometryType forValue(int value) {
        switch (value) {
            case 0: {
                return GEOMETRY_XY;
            }
            case 1: {
                return POINT_XY;
            }
            case 2: {
                return LINESTRING_XY;
            }
            case 3: {
                return POLYGON_XY;
            }
            case 4: {
                return MULTIPOINT_XY;
            }
            case 5: {
                return MULTILINESTRING_XY;
            }
            case 6: {
                return MULTIPOLYGON_XY;
            }
            case 7: {
                return GEOMETRYCOLLECTION_XY;
            }
            case 1000: {
                return GEOMETRY_XYZ;
            }
            case 1001: {
                return POINT_XYZ;
            }
            case 1002: {
                return LINESTRING_XYZ;
            }
            case 1003: {
                return POLYGON_XYZ;
            }
            case 1004: {
                return MULTIPOINT_XYZ;
            }
            case 1005: {
                return MULTILINESTRING_XYZ;
            }
            case 1006: {
                return MULTIPOLYGON_XYZ;
            }
            case 1007: {
                return GEOMETRYCOLLECTION_XYZ;
            }
            case 2000: {
                return GEOMETRY_XYM;
            }
            case 2001: {
                return POINT_XYM;
            }
            case 2002: {
                return LINESTRING_XYM;
            }
            case 2003: {
                return POLYGON_XYM;
            }
            case 2004: {
                return MULTIPOINT_XYM;
            }
            case 2005: {
                return MULTILINESTRING_XYM;
            }
            case 2006: {
                return MULTIPOLYGON_XYM;
            }
            case 2007: {
                return GEOMETRYCOLLECTION_XYM;
            }
            case 3000: {
                return GEOMETRY_XYZM;
            }
            case 3001: {
                return POINT_XYZM;
            }
            case 3002: {
                return LINESTRING_XYZM;
            }
            case 3003: {
                return POLYGON_XYZM;
            }
            case 3004: {
                return MULTIPOINT_XYZM;
            }
            case 3005: {
                return MULTILINESTRING_XYZM;
            }
            case 3006: {
                return MULTIPOLYGON_XYZM;
            }
            case 3007: {
                return GEOMETRYCOLLECTION_XYZM;
            }
        }
        return null;
    }

    public boolean isGeometryCompatible(Geometry geometry) {
        String multiSingleCast;
        String geometryType = geometry.getGeometryType().toLowerCase();
        String description = this.getDescription().toLowerCase();
        if (!description.startsWith(geometryType) && (multiSingleCast = this.getMultiSingleCast().toLowerCase()).contains("tomulti") && !description.startsWith("multi" + geometryType)) {
            return false;
        }
        multiSingleCast = this.getMultiSingleCast().toLowerCase();
        return !multiSingleCast.contains("tosingle") || !geometryType.contains("multi");
    }

    public boolean isGeometryTypeCompatible(SpatialiteGeometryType geometryType) {
        String otherDescription = geometryType.getDescription();
        String thisDescription = this.getDescription();
        String multiSingleCast = this.getMultiSingleCast().toLowerCase();
        if (multiSingleCast.contains("tosingle") && otherDescription.contains("multi")) {
            return false;
        }
        String otherBaseDescription = otherDescription.split("\\_")[0].replaceFirst("multi", "");
        String baseDescription = thisDescription.split("\\_")[0].replaceFirst("multi", "");
        return baseDescription.equals(otherBaseDescription);
    }

    public static int forValue(String name) {
        if (name.toUpperCase().startsWith("POINT")) {
            return POINT_XY.getType();
        }
        if (name.toUpperCase().startsWith("MULTIPOINT")) {
            return MULTIPOINT_XY.getType();
        }
        if (name.toUpperCase().startsWith("LINESTRING")) {
            return LINESTRING_XY.getType();
        }
        if (name.toUpperCase().startsWith("MULTILINESTRING")) {
            return MULTILINESTRING_XY.getType();
        }
        if (name.toUpperCase().startsWith("POLYGON")) {
            return POLYGON_XY.getType();
        }
        if (name.toUpperCase().startsWith("MULTIPOLYGON")) {
            return MULTIPOLYGON_XY.getType();
        }
        if (name.toUpperCase().startsWith("GEOMETRYCOLLECTION")) {
            return GEOMETRYCOLLECTION_XY.getType();
        }
        return -1;
    }
}

