/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorsimplifier;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Collection of vector simplification algorithms.")
@Documentation(value="OmsVectorSimplifier.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Simplify, OmsLineSmootherMcMaster, OmsLineSmootherJaitools")
@Label(value="Vector Processing")
@Name(value="vsimplify")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorSimplifier
extends JGTModel {
    @Description(value="The vector to be simplified.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The simplification type: TopologyPreservingSimplifier = 0, Douglas Peucker = 1 (default = 0).")
    @In
    public int pType = 0;
    @Description(value="The distance tolerance for the simplification.")
    @In
    public double pTolerance = 0.2;
    @Description(value="The simplified vector.")
    @Out
    public SimpleFeatureCollection outVector;
    private GeometryFactory gF = GeometryUtilities.gf();

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        SimpleFeatureIterator inFeatureIterator = this.inVector.features();
        this.outVector = new DefaultFeatureCollection();
        FeatureGeometrySubstitutor fGS = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inVector.getSchema());
        int size = this.inVector.size();
        this.pm.beginTask("Simplifing features...", size);
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            ArrayList<Geometry> geomList = new ArrayList<Geometry>();
            int numGeometries = geometry.getNumGeometries();
            block5: for (int i = 0; i < numGeometries; ++i) {
                Geometry geometryN = geometry.getGeometryN(i);
                switch (this.pType) {
                    case 0: {
                        TopologyPreservingSimplifier tpSimplifier = new TopologyPreservingSimplifier(geometryN);
                        tpSimplifier.setDistanceTolerance(this.pTolerance);
                        Geometry tpsGeometry = tpSimplifier.getResultGeometry();
                        geomList.add(tpsGeometry);
                        continue block5;
                    }
                    case 1: {
                        DouglasPeuckerSimplifier dpSimplifier = new DouglasPeuckerSimplifier(geometryN);
                        dpSimplifier.setDistanceTolerance(this.pTolerance);
                        Geometry dpsGeometry = dpSimplifier.getResultGeometry();
                        geomList.add(dpsGeometry);
                        continue block5;
                    }
                }
            }
            Geometry newGeometry = null;
            if (geomList.size() == 1) {
                newGeometry = (Geometry)geomList.get(0);
            } else {
                Geometry[] geomArray = geomList.toArray(new Geometry[geomList.size()]);
                newGeometry = new GeometryCollection(geomArray, this.gF);
            }
            SimpleFeature newFeature = fGS.substituteGeometry(feature, newGeometry);
            ((DefaultFeatureCollection)this.outVector).add(newFeature);
            this.pm.worked(1);
        }
        this.pm.done();
        inFeatureIterator.close();
    }
}

