/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectoroverlayoperators;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that performs overlay operations on a pure geometric layer. The resulting feature layer does not consider original attributes tables.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, Overlay, Union, Intersect, SymDifference, Difference")
@Label(value="Vector Processing")
@Name(value="overlay")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsVectorOverlayOperators
extends JGTModel {
    @Description(value="The first vector map.")
    @In
    public SimpleFeatureCollection inMap1 = null;
    @Description(value="The second vector map.")
    @In
    public SimpleFeatureCollection inMap2 = null;
    @Description(value="The overlay type to perform.")
    @UI(value="combo:intersection,union,difference,symdifference")
    @In
    public String pType = "intersection";
    @Description(value="Allow holes in the result.")
    @In
    public boolean doAllowHoles = true;
    @Description(value="The resulting vector map.")
    @Out
    public SimpleFeatureCollection outMap = null;
    public static final String OMSVECTOROVERLAYOPERATORS_DESCRIPTION = "A module that performs overlay operations on a pure geometric layer. The resulting feature layer does not consider original attributes tables.";
    public static final String OMSVECTOROVERLAYOPERATORS_DOCUMENTATION = "";
    public static final String OMSVECTOROVERLAYOPERATORS_KEYWORDS = "JTS, Overlay, Union, Intersect, SymDifference, Difference";
    public static final String OMSVECTOROVERLAYOPERATORS_LABEL = "Vector Processing";
    public static final String OMSVECTOROVERLAYOPERATORS_NAME = "overlay";
    public static final int OMSVECTOROVERLAYOPERATORS_STATUS = 5;
    public static final String OMSVECTOROVERLAYOPERATORS_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSVECTOROVERLAYOPERATORS_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTOROVERLAYOPERATORS_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSVECTOROVERLAYOPERATORS_inMap1_DESCRIPTION = "The first vector map.";
    public static final String OMSVECTOROVERLAYOPERATORS_inMap2_DESCRIPTION = "The second vector map.";
    public static final String OMSVECTOROVERLAYOPERATORS_pType_DESCRIPTION = "The overlay type to perform.";
    public static final String OMSVECTOROVERLAYOPERATORS_outMap_DESCRIPTION = "The resulting vector map.";
    private static final String doAllowHoles_DESCRIPTION = "Allow holes in the result.";

    @Execute
    public void process() throws Exception {
        if (this.pType.equals("union")) {
            this.checkNull(this.inMap1);
        } else {
            this.checkNull(this.inMap1, this.inMap2);
        }
        CoordinateReferenceSystem crs = ((SimpleFeatureType)this.inMap1.getSchema()).getCoordinateReferenceSystem();
        this.outMap = new DefaultFeatureCollection();
        SimpleFeatureBuilder builder = null;
        this.pm.message("Preparing geometry layers...");
        List<Geometry> geoms1 = FeatureUtilities.featureCollectionToGeometriesList(this.inMap1, false, null);
        GeometryCollection geometryCollection1 = new GeometryCollection(geoms1.toArray(new Geometry[geoms1.size()]), this.gf);
        Geometry g1 = geometryCollection1.buffer(0.0);
        Geometry g2 = null;
        if (this.inMap2 != null) {
            List<Geometry> geoms2 = FeatureUtilities.featureCollectionToGeometriesList(this.inMap2, false, null);
            String geometryCollection2 = new GeometryCollection(geoms2.toArray(new Geometry[geoms2.size()]), this.gf);
            g2 = geometryCollection2.buffer(0.0);
        }
        this.pm.beginTask("Performing overlay operation...", -1);
        Geometry resultingGeometryCollection = null;
        switch (this.pType) {
            case "intersection": {
                resultingGeometryCollection = g1.intersection(g2);
                break;
            }
            case "union": {
                if (this.inMap2 != null) {
                    resultingGeometryCollection = g1.union(g2);
                    break;
                }
                resultingGeometryCollection = g1.union();
                break;
            }
            case "difference": {
                resultingGeometryCollection = g1.difference(g2);
                break;
            }
            case "symdifference": {
                resultingGeometryCollection = g1.symDifference(g2);
                break;
            }
            default: {
                throw new ModelsIllegalargumentException("The overlay type is not supported: " + this.pType, this, this.pm);
            }
        }
        this.pm.done();
        this.pm.message("Preparing final layer...");
        int numGeometries = resultingGeometryCollection.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometryN = resultingGeometryCollection.getGeometryN(i);
            int numGeometries2 = geometryN.getNumGeometries();
            for (int j = 0; j < numGeometries2; ++j) {
                Geometry geometryN2 = geometryN.getGeometryN(j);
                if (builder == null) {
                    SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                    b.setName(OMSVECTOROVERLAYOPERATORS_NAME);
                    b.setCRS(crs);
                    if (geometryN2 instanceof Polygon) {
                        b.add("the_geom", Polygon.class);
                    } else if (geometryN2 instanceof LineString) {
                        b.add("the_geom", LineString.class);
                    } else if (geometryN2 instanceof Point) {
                        b.add("the_geom", Point.class);
                    } else {
                        throw new ModelsRuntimeException("An unexpected geometry type has been created: " + geometryN2.getGeometryType(), this);
                    }
                    b.add("id", Integer.class);
                    SimpleFeatureType type = b.buildFeatureType();
                    builder = new SimpleFeatureBuilder(type);
                }
                if (geometryN2 instanceof Polygon && !this.doAllowHoles) {
                    Polygon polygon = (Polygon)geometryN2;
                    LineString exteriorRing = polygon.getExteriorRing();
                    Coordinate[] coordinates = exteriorRing.getCoordinates();
                    geometryN2 = this.gf.createPolygon(coordinates);
                }
                Object[] values = new Object[]{geometryN2, i};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                ((DefaultFeatureCollection)this.outMap).add(feature);
            }
        }
    }
}

