/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectorconverter;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.io.dxfdwg.libs.DxfUtils;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLE_LAYER_ITEM;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLE_LTYPE_ITEM;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLE_STYLE_ITEM;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureMate;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;

@Description(value="Shapefiles to dxf converter (Based on work of Michael Michaud)")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="dxf, vector, converter")
@Label(value="Vector Processing")
@Name(value="_shp2dxfconverter")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsShp2DxfConverter
extends JGTModel {
    @Description(value="The folder containing the shapefiles.")
    @UI(value="infolder")
    @In
    public String inFolder = null;
    @Description(value="Optional field name for elevation value (in case of lines it will be applied to the whole feature).")
    @In
    public String fElev = null;
    @Description(value="Do the suffix.")
    @In
    public boolean doSuffix = false;
    @Description(value="The output dxf file path.")
    @UI(value="outfile")
    @In
    public String inDxfpath = null;
    public static final String NAME = "shp2dxfconverter";
    public static final String KEYWORDS = "dxf, vector, converter";
    public static final String DESCRIPTION = "Shapefiles to dxf converter (Based on work of Michael Michaud)";
    public static final String THE_FOLDER_CONTAINING_THE_SHAPEFILES = "The folder containing the shapefiles.";
    public static final String FIELD_NAME_FOR_ELEVATION_VALUE = "Optional field name for elevation value (in case of lines it will be applied to the whole feature).";
    public static final String DO_THE_SUFFIX = "Do the suffix.";
    public static final String THE_OUTPUT_DXF_FILE_PATH = "The output dxf file path.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        List featuresList;
        this.checkNull(this.inFolder, this.inDxfpath);
        File fodlerFile = new File(this.inFolder);
        if (!fodlerFile.exists()) {
            throw new ModelsIllegalargumentException("Folder doesn't exist: " + this.inFolder, this);
        }
        File[] shpFiles = fodlerFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String name) {
                return name.endsWith(".shp");
            }
        });
        ReferencedEnvelope envelope = null;
        int count = 0;
        LinkedHashMap<String, List> layer2FeaturesMap = new LinkedHashMap<String, List>();
        for (File shpFile : shpFiles) {
            String path = shpFile.getAbsolutePath();
            String string = FileUtilities.getNameWithoutExtention(shpFile);
            SimpleFeatureCollection vector = this.getVector(path);
            featuresList = FeatureUtilities.featureCollectionToMatesList(vector);
            layer2FeaturesMap.put(string, featuresList);
            count += featuresList.size();
            if (envelope == null) {
                envelope = vector.getBounds();
                continue;
            }
            envelope.expandToInclude((Envelope)vector.getBounds());
        }
        Date date = new Date(System.currentTimeMillis());
        try (FileWriter fw = new FileWriter(this.inDxfpath);){
            fw.write(DxfGroup.toString(999, Integer.toString(count) + " features"));
            fw.write(DxfGroup.toString(999, "TRANSLATION BY fr.michaelm.jump.drivers.dxf.DxfFile (version jgrasstools)"));
            fw.write(DxfGroup.toString(999, "DATE : " + date.toString()));
            fw.write(DxfGroup.toString(0, "SECTION"));
            fw.write(DxfGroup.toString(2, "HEADER"));
            fw.write(DxfGroup.toString(9, "$ACADVER"));
            fw.write(DxfGroup.toString(1, "AC1009"));
            fw.write(DxfGroup.toString(9, "$CECOLOR"));
            fw.write(DxfGroup.toString(62, 256));
            fw.write(DxfGroup.toString(9, "$CELTYPE"));
            fw.write(DxfGroup.toString(6, "DUPLAN"));
            fw.write(DxfGroup.toString(9, "$CLAYER"));
            fw.write(DxfGroup.toString(8, "0"));
            fw.write(DxfGroup.toString(9, "$ELEVATION"));
            fw.write(DxfGroup.toString(40, 0.0, 3));
            fw.write(DxfGroup.toString(9, "$EXTMAX"));
            fw.write(DxfGroup.toString(10, envelope.getMaxX(), 6));
            fw.write(DxfGroup.toString(20, envelope.getMaxY(), 6));
            fw.write(DxfGroup.toString(9, "$EXTMIN"));
            fw.write(DxfGroup.toString(10, envelope.getMinX(), 6));
            fw.write(DxfGroup.toString(20, envelope.getMinY(), 6));
            fw.write(DxfGroup.toString(9, "$INSBASE"));
            fw.write(DxfGroup.toString(10, 0.0, 1));
            fw.write(DxfGroup.toString(20, 0.0, 1));
            fw.write(DxfGroup.toString(30, 0.0, 1));
            fw.write(DxfGroup.toString(9, "$LIMCHECK"));
            fw.write(DxfGroup.toString(70, 1));
            fw.write(DxfGroup.toString(9, "$LIMMAX"));
            fw.write(DxfGroup.toString(10, envelope.getMaxX(), 6));
            fw.write(DxfGroup.toString(20, envelope.getMaxY(), 6));
            fw.write(DxfGroup.toString(9, "$LIMMIN"));
            fw.write(DxfGroup.toString(10, envelope.getMinX(), 6));
            fw.write(DxfGroup.toString(20, envelope.getMinY(), 6));
            fw.write(DxfGroup.toString(9, "$LUNITS"));
            fw.write(DxfGroup.toString(70, 2));
            fw.write(DxfGroup.toString(9, "$LUPREC"));
            fw.write(DxfGroup.toString(70, 2));
            fw.write(DxfGroup.toString(0, "ENDSEC"));
            fw.write(DxfGroup.toString(0, "SECTION"));
            fw.write(DxfGroup.toString(2, "TABLES"));
            fw.write(DxfGroup.toString(0, "TABLE"));
            fw.write(DxfGroup.toString(2, "STYLE"));
            fw.write(DxfGroup.toString(70, 1));
            fw.write(DxfGroup.toString(0, "STYLE"));
            DxfTABLE_STYLE_ITEM style = new DxfTABLE_STYLE_ITEM("STANDARD", 0, 0.0f, 1.0f, 0.0f, 0, 1.0f, "xxx.txt", "yyy.txt");
            fw.write(style.toString());
            fw.write(DxfGroup.toString(0, "ENDTAB"));
            fw.write(DxfGroup.toString(0, "TABLE"));
            fw.write(DxfGroup.toString(2, "LTYPE"));
            fw.write(DxfGroup.toString(70, 1));
            fw.write(DxfGroup.toString(0, "LTYPE"));
            DxfTABLE_LTYPE_ITEM ltype = new DxfTABLE_LTYPE_ITEM("CONTINUE", 0, "", 65, 0.0f, new float[0]);
            fw.write(ltype.toString());
            fw.write(DxfGroup.toString(0, "ENDTAB"));
            fw.write(DxfGroup.toString(0, "TABLE"));
            fw.write(DxfGroup.toString(2, "LAYER"));
            fw.write(DxfGroup.toString(70, 2));
            for (String string : layer2FeaturesMap.keySet()) {
                DxfTABLE_LAYER_ITEM layer = new DxfTABLE_LAYER_ITEM(string, 0, 131, "CONTINUE");
                fw.write(DxfGroup.toString(0, "LAYER"));
                fw.write(layer.toString());
                if (!this.doSuffix) continue;
                layer = new DxfTABLE_LAYER_ITEM(string + "_", 0, 131, "CONTINUE");
                fw.write(DxfGroup.toString(0, "LAYER"));
                fw.write(layer.toString());
            }
            fw.write(DxfGroup.toString(0, "ENDTAB"));
            fw.write(DxfGroup.toString(0, "ENDSEC"));
            fw.write(DxfGroup.toString(0, "SECTION"));
            fw.write(DxfGroup.toString(2, "ENTITIES"));
            for (Map.Entry entry : layer2FeaturesMap.entrySet()) {
                String layerName = (String)entry.getKey();
                featuresList = (List)entry.getValue();
                for (FeatureMate feature : featuresList) {
                    fw.write(DxfUtils.feature2Dxf(feature, layerName, this.fElev, this.doSuffix, false));
                }
            }
            fw.write(DxfGroup.toString(0, "ENDSEC"));
            fw.write(DxfGroup.toString(0, "EOF"));
            fw.flush();
        }
    }
}

