/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.smoothing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.jaitools.jts.PolygonSmoother;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="The polygon smoother from the jaitools project.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Smoothing, Vector")
@Label(value="Vector Processing")
@Name(value="polygonsmootherjai")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsPolygonSmootherJaitools
extends JGTModel {
    @Description(value="The vector containing the polygons to be smoothed.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="A value between 0 and 1 (inclusive) specifying the tightness of fit of the smoothed boundary (0 is loose).")
    @In
    public double pAlpha = 0.0;
    @Description(value="The smoothed features.")
    @Out
    public SimpleFeatureCollection outVector;
    private GeometryFactory gF = GeometryUtilities.gf();

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.outVector = new DefaultFeatureCollection();
        this.pm.message("Collecting geometries...");
        List<SimpleFeature> polygonsList = FeatureUtilities.featureCollectionToList(this.inVector);
        int size = this.inVector.size();
        FeatureGeometrySubstitutor fGS = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inVector.getSchema());
        this.pm.beginTask("Smoothing features...", size);
        PolygonSmoother smoother = new PolygonSmoother(this.gF);
        for (SimpleFeature polygonsFeature : polygonsList) {
            Geometry geometry = (Geometry)polygonsFeature.getDefaultGeometry();
            int numGeometries = geometry.getNumGeometries();
            ArrayList<Polygon> smoothedList = new ArrayList<Polygon>();
            for (int i = 0; i < numGeometries; ++i) {
                Geometry geometryN = geometry.getGeometryN(i);
                if (!(geometryN instanceof Polygon)) continue;
                Polygon polygon = (Polygon)geometryN;
                Polygon smoothed = smoother.smooth(polygon, this.pAlpha);
                smoothedList.add(smoothed);
            }
            if (smoothedList.size() != 0) {
                Polygon[] lsArray = smoothedList.toArray(new Polygon[smoothedList.size()]);
                MultiPolygon multiPolygonString = this.gF.createMultiPolygon(lsArray);
                SimpleFeature newFeature = fGS.substituteGeometry(polygonsFeature, (Geometry)multiPolygonString);
                ((DefaultFeatureCollection)this.outVector).add(newFeature);
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

