/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.grids;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.DefaultGridFeatureBuilder;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Grids;
import org.geotools.grid.Lines;
import org.geotools.grid.oblong.Oblongs;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLineDef;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Generates grid of lines or polygons.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Vector, Grid")
@Label(value="Vector Processing")
@Name(value="gridgenerator")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsGridsGenerator
extends JGTModel {
    @Description(value="Optional vector map from which to take the bounds (if supplied, all other bounds related parameter are ignored). This needs pRows and pCols to be defined.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="Optional raster map from which to take the bounds (if supplied, all other bounds related parameter are ignored. This needs pRows and pCols to be defined.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The lower left longitude (needed if no map is supplied).")
    @In
    public Double pLon;
    @Description(value="The lower left latitude (needed if no map is supplied).")
    @In
    public Double pLat;
    @Description(value="The optional grid cell width.")
    @In
    public Double pWidth;
    @Description(value="The optional grid cell height.")
    @In
    public Double pHeight;
    @Description(value="The number of rows.")
    @In
    public int pRows = 10;
    @Description(value="The number of cols.")
    @In
    public int pCols = 10;
    @Description(value="The vertex spacing to use.")
    @In
    public Double pSpacing = null;
    @Description(value="The output type.")
    @UI(value="combo: polygon,line,point")
    @In
    public String pType = "polygon";
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The grid.")
    @Out
    public SimpleFeatureCollection outMap = null;
    public static final String POINT = "point";
    public static final String LINE = "line";
    public static final String POLYGON = "polygon";
    public static final String OMSGRIDSGENERATOR_DESCRIPTION = "Generates grid of lines or polygons.";
    public static final String OMSGRIDSGENERATOR_DOCUMENTATION = "";
    public static final String OMSGRIDSGENERATOR_KEYWORDS = "Vector, Grid";
    public static final String OMSGRIDSGENERATOR_LABEL = "Vector Processing";
    public static final String OMSGRIDSGENERATOR_NAME = "gridgenerator";
    public static final int OMSGRIDSGENERATOR_STATUS = 40;
    public static final String OMSGRIDSGENERATOR_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSGRIDSGENERATOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSGRIDSGENERATOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSGRIDSGENERATOR_inVector_DESCRIPTION = "Optional vector map from which to take the bounds (if supplied, all other bounds related parameter are ignored). This needs pRows and pCols to be defined.";
    public static final String OMSGRIDSGENERATOR_inRaster_DESCRIPTION = "Optional raster map from which to take the bounds (if supplied, all other bounds related parameter are ignored. This needs pRows and pCols to be defined.";
    public static final String OMSGRIDSGENERATOR_pLon_DESCRIPTION = "The lower left longitude (needed if no map is supplied).";
    public static final String OMSGRIDSGENERATOR_pLat_DESCRIPTION = "The lower left latitude (needed if no map is supplied).";
    public static final String OMSGRIDSGENERATOR_pWidth_DESCRIPTION = "The optional grid cell width.";
    public static final String OMSGRIDSGENERATOR_pHeight_DESCRIPTION = "The optional grid cell height.";
    public static final String OMSGRIDSGENERATOR_pRows_DESCRIPTION = "The number of rows.";
    public static final String OMSGRIDSGENERATOR_pCols_DESCRIPTION = "The number of cols.";
    public static final String OMSGRIDSGENERATOR_pSpacing_DESCRIPTION = "The vertex spacing to use.";
    public static final String OMSGRIDSGENERATOR_pType_DESCRIPTION = "The output type.";
    public static final String OMSGRIDSGENERATOR_pCode_DESCRIPTION = "The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.";
    public static final String OMSGRIDSGENERATOR_outMap_DESCRIPTION = "The grid.";

    @Execute
    public void process() throws Exception {
        double e;
        double w;
        double n;
        double s;
        CoordinateReferenceSystem crs;
        ReferencedEnvelope bounds;
        if (this.inVector != null) {
            bounds = this.inVector.getBounds();
            crs = ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem();
            s = bounds.getMinY();
            n = bounds.getMaxY();
            w = bounds.getMinX();
            e = bounds.getMaxX();
            this.pWidth = bounds.getWidth() / (double)this.pCols;
            this.pHeight = bounds.getHeight() / (double)this.pRows;
        } else if (this.inRaster != null) {
            bounds = this.inRaster.getGridGeometry().getEnvelope2D();
            crs = this.inRaster.getCoordinateReferenceSystem();
            s = bounds.getMinY();
            w = bounds.getMinX();
            if (this.pWidth != null && this.pHeight != null) {
                n = s + this.pWidth * (double)this.pCols;
                e = w + this.pHeight * (double)this.pRows;
            } else {
                n = bounds.getMaxY();
                e = bounds.getMaxX();
                this.pWidth = bounds.getWidth() / (double)this.pCols;
                this.pHeight = bounds.getHeight() / (double)this.pRows;
            }
        } else {
            this.checkNull(this.pCode, this.pLat, this.pLon);
            s = this.pLat;
            n = this.pLat + (double)this.pRows * this.pHeight;
            w = this.pLon;
            e = this.pLon + (double)this.pCols * this.pWidth;
            crs = CRS.decode((String)this.pCode);
        }
        boolean isSquare = NumericsUtilities.dEq(this.pWidth, this.pHeight);
        this.outMap = new DefaultFeatureCollection();
        double delta = 1.0E-6;
        ReferencedEnvelope env = new ReferencedEnvelope(w, e + delta, s, n + delta, crs);
        this.pm.beginTask("Generating grid...", -1);
        DefaultGridFeatureBuilder builder = new DefaultGridFeatureBuilder(crs);
        switch (this.pType) {
            case "polygon": {
                SimpleFeatureSource grid = isSquare ? (this.pSpacing != null ? Grids.createSquareGrid((ReferencedEnvelope)env, (double)this.pWidth, (double)this.pSpacing) : Grids.createSquareGrid((ReferencedEnvelope)env, (double)this.pWidth)) : (this.pSpacing != null ? Oblongs.createGrid((ReferencedEnvelope)env, (double)this.pWidth, (double)this.pHeight, (double)this.pSpacing, (GridFeatureBuilder)builder) : Oblongs.createGrid((ReferencedEnvelope)env, (double)this.pWidth, (double)this.pHeight, (GridFeatureBuilder)builder));
                this.outMap = grid.getFeatures();
                List<Geometry> geomsList = FeatureUtilities.featureCollectionToGeometriesList(this.outMap, true, null);
                this.createPolygons(crs, this.gf, geomsList);
                break;
            }
            case "line": 
            case "point": {
                List<OrthoLineDef> lineDefs = Arrays.asList(new OrthoLineDef(LineOrientation.VERTICAL, 1, this.pHeight.doubleValue()), new OrthoLineDef(LineOrientation.HORIZONTAL, 1, this.pWidth.doubleValue()));
                SimpleFeatureSource grid = this.pSpacing != null ? Lines.createOrthoLines((ReferencedEnvelope)env, lineDefs, (double)this.pSpacing, (GridFeatureBuilder)builder) : Lines.createOrthoLines((ReferencedEnvelope)env, lineDefs);
                this.outMap = grid.getFeatures();
                GeometryFactory gf = GeometryUtilities.gf();
                List<Geometry> geoms = FeatureUtilities.featureCollectionToGeometriesList(this.outMap, true, null);
                ArrayList<LineString> verticals = new ArrayList<LineString>();
                ArrayList<LineString> horizontals = new ArrayList<LineString>();
                for (Geometry geometry : geoms) {
                    Envelope envelope = geometry.getEnvelopeInternal();
                    Coordinate first = new Coordinate(envelope.getMinX(), envelope.getMinY());
                    Coordinate last = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
                    LineString lineString = gf.createLineString(new Coordinate[]{first, last});
                    if (envelope.getWidth() > envelope.getHeight()) {
                        horizontals.add(lineString);
                        continue;
                    }
                    verticals.add(lineString);
                }
                if (this.pType.equals(LINE)) {
                    this.createLines(crs, verticals, horizontals);
                    break;
                }
                this.createPoints(crs, gf, verticals, horizontals);
                break;
            }
            default: {
                throw new ModelsIllegalargumentException("The supplied pType is not supported.", this, this.pm);
            }
        }
        this.pm.done();
    }

    private void createPolygons(CoordinateReferenceSystem crs, GeometryFactory gf, List<Geometry> polygons) {
        this.outMap = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(POLYGON);
        b.setCRS(crs);
        b.add("the_geom", Polygon.class);
        b.add("id", Long.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        long index = 0L;
        int numGeometries = polygons.size();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometry = polygons.get(i);
            Object[] values = new Object[]{geometry, index++};
            fbuilder.addAll(values);
            SimpleFeature feature = fbuilder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMap).add(feature);
        }
    }

    private void createPoints(CoordinateReferenceSystem crs, GeometryFactory gf, List<LineString> verticals, List<LineString> horizontals) {
        this.outMap = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(POINT);
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("id", Long.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        MultiLineString gVer = gf.createMultiLineString(verticals.toArray(new LineString[0]));
        MultiLineString gHor = gf.createMultiLineString(horizontals.toArray(new LineString[0]));
        Geometry intersection = gHor.intersection((Geometry)gVer);
        long index = 0L;
        int numGeometries = intersection.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometry = intersection.getGeometryN(i);
            Object[] values = new Object[]{geometry, index++};
            fbuilder.addAll(values);
            SimpleFeature feature = fbuilder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMap).add(feature);
        }
    }

    private void createLines(CoordinateReferenceSystem crs, List<LineString> verticals, List<LineString> horizontals) {
        SimpleFeature feature;
        Object[] values;
        this.outMap = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(LINE);
        b.setCRS(crs);
        b.add("the_geom", MultiLineString.class);
        b.add("id", Long.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        long index = 0L;
        for (LineString lineString : horizontals) {
            values = new Object[]{lineString, index++};
            fbuilder.addAll(values);
            feature = fbuilder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMap).add(feature);
        }
        for (LineString lineString : verticals) {
            values = new Object[]{lineString, index++};
            fbuilder.addAll(values);
            feature = fbuilder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMap).add(feature);
        }
    }
}

