/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.tmsgenerator;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.imageio.ImageIO;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;

public class MBTilesHelper {
    public static final String TABLE_TILES = "tiles";
    public static final String COL_TILES_ZOOM_LEVEL = "zoom_level";
    public static final String COL_TILES_TILE_COLUMN = "tile_column";
    public static final String COL_TILES_TILE_ROW = "tile_row";
    public static final String COL_TILES_TILE_DATA = "tile_data";
    private static final String CREATE_TILES = "CREATE TABLE tiles( zoom_level INTEGER, tile_column INTEGER, tile_row INTEGER, tile_data BLOB)";
    public static final String TABLE_METADATA = "metadata";
    public static final String COL_METADATA_NAME = "name";
    public static final String COL_METADATA_VALUE = "value";
    private static final String CREATE_METADATA = "CREATE TABLE metadata( name TEXT, value TEXT )";
    private static final String INDEX_TILES = "CREATE UNIQUE INDEX tile_index ON tiles (zoom_level, tile_column, tile_row)";
    private static final String INDEX_METADATA = "CREATE UNIQUE INDEX name ON metadata( name)";
    private Connection connection;

    public void open(File dbFile) throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new ModelsRuntimeException("An error occurred while closing the database connection.", this);
        }
    }

    public void createTables(boolean makeIndexes) throws SQLException {
        try (Statement statement = null;){
            statement = this.connection.createStatement();
            statement.addBatch("DROP TABLE IF EXISTS tiles");
            statement.addBatch("DROP TABLE IF EXISTS metadata");
            statement.addBatch(CREATE_TILES);
            statement.addBatch(CREATE_METADATA);
            if (makeIndexes) {
                statement.addBatch(INDEX_TILES);
                statement.addBatch(INDEX_METADATA);
            }
            statement.executeBatch();
        }
    }

    public void createIndexes() throws SQLException {
        try (Statement statement = null;){
            statement = this.connection.createStatement();
            statement.addBatch(INDEX_TILES);
            statement.addBatch(INDEX_METADATA);
            statement.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillMetadata(float n, float s, float w, float e, String name, String format, int minZoom, int maxZoom) throws SQLException {
        try (Statement statement = null;){
            statement = this.connection.createStatement();
            String query = this.toMetadataQuery(COL_METADATA_NAME, name);
            statement.addBatch(query);
            query = this.toMetadataQuery("description", name);
            statement.addBatch(query);
            query = this.toMetadataQuery("format", format);
            statement.addBatch(query);
            query = this.toMetadataQuery("minZoom", minZoom + "");
            statement.addBatch(query);
            query = this.toMetadataQuery("maxZoom", maxZoom + "");
            statement.addBatch(query);
            query = this.toMetadataQuery("type", "baselayer");
            statement.addBatch(query);
            query = this.toMetadataQuery("version", "1.1");
            statement.addBatch(query);
            query = this.toMetadataQuery("bounds", w + "," + s + "," + e + "," + n);
            statement.addBatch(query);
            statement.executeBatch();
        }
    }

    private String toMetadataQuery(String key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO metadata ");
        sb.append("(");
        sb.append(COL_METADATA_NAME);
        sb.append(",");
        sb.append(COL_METADATA_VALUE);
        sb.append(") values ('");
        sb.append(key);
        sb.append("','");
        sb.append(value);
        sb.append("')");
        String query = sb.toString();
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTile(int x, int y, int z, BufferedImage image, String format) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, baos);
        byte[] res = baos.toByteArray();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO tiles ");
        sb.append("(");
        sb.append(COL_TILES_ZOOM_LEVEL);
        sb.append(",");
        sb.append(COL_TILES_TILE_COLUMN);
        sb.append(",");
        sb.append(COL_TILES_TILE_ROW);
        sb.append(",");
        sb.append(COL_TILES_TILE_DATA);
        sb.append(") values (");
        sb.append(z);
        sb.append(",");
        sb.append(x);
        sb.append(",");
        sb.append(y);
        sb.append(",");
        sb.append("?");
        sb.append(")");
        String query = sb.toString();
        try (PreparedStatement statement = null;){
            statement = this.connection.prepareStatement(query);
            statement.setBytes(1, res);
            statement.execute();
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

