/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.scanline;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.image.WritableRaster;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module for polygon vector to raster conversion.")
@Documentation(value="OmsScanLineRasterizer.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Rasterize")
@Label(value="Raster Processing")
@Name(value="rscanline")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsScanLineRasterizer
extends JGTModel {
    @Description(value="The vector to rasterize.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The value to use as raster value if no field is given.")
    @In
    public Double pValue = null;
    @Description(value="The field to use to retrieve the category value for the raster.")
    @In
    public String fCat = null;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="An optional raster to take the values and region from.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;
    private WritableRaster outWR;
    private int height;
    private int width;
    private GeometryFactory gf = GeometryUtilities.gf();
    private RegionMap paramsMap;
    private double xRes;
    private RandomIter inIter;

    @Execute
    public void process() throws Exception {
        GeometryType type;
        this.checkNull(this.inVector);
        if (this.pValue == null && this.fCat == null) {
            throw new ModelsIllegalargumentException("One of pValue or the fCat have to be defined.", this, this.pm);
        }
        if ((this.pNorth == null || this.pSouth == null || this.pWest == null || this.pEast == null || this.pRows == null || this.pCols == null) && this.inRaster == null) {
            throw new ModelsIllegalargumentException("It is necessary to supply all the information about the processing region. Did you set the boundaries and rows/cols?", this, this.pm);
        }
        if (this.inRaster != null) {
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
            this.pNorth = regionMap.getNorth();
            this.pSouth = regionMap.getSouth();
            this.pWest = regionMap.getWest();
            this.pEast = regionMap.getEast();
            this.pRows = regionMap.getRows();
            this.pCols = regionMap.getCols();
            this.inIter = CoverageUtilities.getRandomIterator(this.inRaster);
        }
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        GridGeometry2D pGrid = this.inRaster != null ? this.inRaster.getGridGeometry() : CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, this.pCols, this.pRows, crs);
        if (this.outWR == null) {
            this.paramsMap = CoverageUtilities.gridGeometry2RegionParamsMap(pGrid);
            this.height = this.paramsMap.getRows();
            this.width = this.paramsMap.getCols();
            this.xRes = this.paramsMap.getXres();
            this.outWR = CoverageUtilities.createDoubleWritableRaster(this.width, this.height, null, null, Double.NaN);
        }
        if (GeometryUtilities.getGeometryType(type = schema.getGeometryDescriptor().getType()) == org.jgrasstools.gears.utils.geometry.GeometryType.POINT || GeometryUtilities.getGeometryType(type) == org.jgrasstools.gears.utils.geometry.GeometryType.MULTIPOINT) {
            throw new ModelsRuntimeException("Not implemented yet for points", this.getClass().getSimpleName());
        }
        if (GeometryUtilities.getGeometryType(type) == org.jgrasstools.gears.utils.geometry.GeometryType.LINE || GeometryUtilities.getGeometryType(type) == org.jgrasstools.gears.utils.geometry.GeometryType.MULTILINE) {
            throw new ModelsRuntimeException("Not implemented yet for lines", this.getClass().getSimpleName());
        }
        if (GeometryUtilities.getGeometryType(type) != org.jgrasstools.gears.utils.geometry.GeometryType.POLYGON && GeometryUtilities.getGeometryType(type) != org.jgrasstools.gears.utils.geometry.GeometryType.MULTIPOLYGON) {
            throw new ModelsIllegalargumentException("Couldn't recognize the geometry type of the file.", this.getClass().getSimpleName(), this.pm);
        }
        this.rasterizepolygon(pGrid);
        this.outRaster = CoverageUtilities.buildCoverage("rasterized", this.outWR, (HashMap<String, Double>)this.paramsMap, ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem());
    }

    private void rasterizepolygon(final GridGeometry2D gridGeometry) throws InvalidGridGeometryException, TransformException {
        int size = this.inVector.size();
        this.pm.beginTask("Rasterizing features...", size);
        SimpleFeatureIterator featureIterator = this.inVector.features();
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(OmsScanLineRasterizer.getDefaultThreadsNum());
        while (featureIterator.hasNext()) {
            final SimpleFeature feature = (SimpleFeature)featureIterator.next();
            double tmpValue = -1.0;
            tmpValue = this.pValue == null ? ((Number)feature.getAttribute(this.fCat)).doubleValue() : this.pValue.doubleValue();
            final double value = tmpValue;
            final double delta = this.xRes / 4.0;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        Geometry geometry = (Geometry)feature.getDefaultGeometry();
                        int numGeometries = geometry.getNumGeometries();
                        for (int i = 0; i < numGeometries; ++i) {
                            Geometry geometryN = geometry.getGeometryN(i);
                            for (int r = 0; r < OmsScanLineRasterizer.this.height; ++r) {
                                double[] westPos = gridGeometry.gridToWorld(new GridCoordinates2D(0, r)).getCoordinate();
                                double[] eastPos = gridGeometry.gridToWorld(new GridCoordinates2D(OmsScanLineRasterizer.this.width - 1, r)).getCoordinate();
                                Coordinate west = new Coordinate(westPos[0], westPos[1]);
                                Coordinate east = new Coordinate(eastPos[0], eastPos[1]);
                                LineString line = OmsScanLineRasterizer.this.gf.createLineString(new Coordinate[]{west, east});
                                if (!geometryN.intersects((Geometry)line)) continue;
                                Geometry internalLines = geometryN.intersection((Geometry)line);
                                int lineNums = internalLines.getNumGeometries();
                                for (int l = 0; l < lineNums; ++l) {
                                    Coordinate[] coords = internalLines.getGeometryN(l).getCoordinates();
                                    if (coords.length == 2) {
                                        for (int j = 0; j < coords.length; j += 2) {
                                            DirectPosition2D endDP;
                                            DirectPosition2D startDP;
                                            Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                                            Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                                            if (startC.x < endC.x) {
                                                startDP = new DirectPosition2D(startC.x, startC.x);
                                                endDP = new DirectPosition2D(endC.x, endC.x);
                                            } else {
                                                startDP = new DirectPosition2D(endC.x, endC.x);
                                                endDP = new DirectPosition2D(startC.x, startC.x);
                                            }
                                            GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)startDP);
                                            GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)endDP);
                                            for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                                                if (OmsScanLineRasterizer.this.inIter != null && OmsScanLineRasterizer.this.fCat == null) {
                                                    double v = OmsScanLineRasterizer.this.inIter.getSampleDouble(k, r, 0);
                                                    OmsScanLineRasterizer.this.outWR.setSample(k, r, 0, v);
                                                    continue;
                                                }
                                                OmsScanLineRasterizer.this.outWR.setSample(k, r, 0, value);
                                            }
                                        }
                                        continue;
                                    }
                                    if (coords.length == 1) {
                                        OmsScanLineRasterizer.this.pm.errorMessage(MessageFormat.format("Found a cusp in: {0}/{1}", coords[0].x, coords[0].y));
                                        continue;
                                    }
                                    throw new ModelsIOException(MessageFormat.format("Found intersection with more than 2 points in: {0}/{1}", coords[0].x, coords[0].y), this);
                                }
                            }
                        }
                        OmsScanLineRasterizer.this.pm.worked(1);
                    }
                    catch (Exception e) {
                        OmsScanLineRasterizer.this.pm.errorMessage(e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            };
            fixedThreadPool.execute(runner);
        }
        try {
            fixedThreadPool.shutdown();
            fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
            fixedThreadPool.shutdownNow();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pm.done();
        featureIterator.close();
    }
}

