/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.houghes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Point2D;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.io.rasterreader.OmsRasterReader;
import org.jgrasstools.gears.io.vectorwriter.OmsVectorWriter;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.modules.ThreadedRunnable;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Hough Transform implementation.")
@Author(name="Hemerson Pistori (pistori@ec.ucdb.br) and Eduardo Rocha Costa, Mark A. Schulze (http://www.markschulze.net/), Andrea Antonello (www.hydrologis.com)", contact="")
@Keywords(value="Hough, circle")
@Label(value="Raster Processing")
@Name(value="houghcirclesraster")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsHoughCirclesRaster
extends JGTModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The minimum radius to look for.")
    @Unit(value="m")
    @In
    public Double pMinRadius;
    @Description(value="The maximum radius to look for.")
    @Unit(value="m")
    @In
    public Double pMaxRadius;
    @Description(value="The radius increment to use.")
    @Unit(value="m")
    @In
    public Double pRadiusIncrement;
    @Description(value="The maximum circle count to look for.")
    @In
    public int pMaxCircleCount = 50;
    @Description(value="The output circles.")
    @In
    public SimpleFeatureCollection outCircles;
    public static final String NAME = "houghcirclesraster";
    public static final String KEYWORDS = "Hough, circle";
    public static final String AUTHORS = "Hemerson Pistori (pistori@ec.ucdb.br) and Eduardo Rocha Costa, Mark A. Schulze (http://www.markschulze.net/), Andrea Antonello (www.hydrologis.com)";
    public static final String DESCRIPTIO = "Hough Transform implementation.";
    public static final String outCircles_DESCR = "The output circles.";
    public static final String pMaxCircleCount_DESCR = "The maximum circle count to look for.";
    public static final String pRadiusIncrement_DESCR = "The radius increment to use.";
    public static final String pMaxRadius_DESCR = "The maximum radius to look for.";
    public static final String pMinRadius_DESCR = "The minimum radius to look for.";
    public static final String inRaster_DESCR = "The input raster.";
    private int radiusMinPixel;
    private int radiusMaxPixel;
    private int radiusIncPixel;
    private int maxCircles;
    private byte[] imageValues;
    private int width;
    private int height;
    private int depth;
    private int offset;
    private int offx;
    private int offy;
    private int[][][] lut;
    private double xRes;
    private double referenceImageValue = Double.NaN;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster, this.pMinRadius, this.pMaxRadius, this.pRadiusIncrement);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        this.offx = 0;
        this.offy = 0;
        this.width = regionMap.getCols();
        this.height = regionMap.getRows();
        this.offset = this.width;
        this.xRes = regionMap.getXres();
        this.radiusMinPixel = (int)Math.round((double)this.width * this.pMinRadius / (regionMap.getEast() - regionMap.getWest()));
        this.radiusMaxPixel = (int)Math.round((double)this.width * this.pMaxRadius / (regionMap.getEast() - regionMap.getWest()));
        this.radiusIncPixel = (int)Math.round((double)this.width * this.pRadiusIncrement / (regionMap.getEast() - regionMap.getWest()));
        if (this.radiusIncPixel < 1) {
            this.radiusIncPixel = 1;
        }
        this.maxCircles = this.pMaxCircleCount;
        this.depth = (this.radiusMaxPixel - this.radiusMinPixel) / this.radiusIncPixel + 1;
        Geometry[] circles = this.getCircles();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("houghcircles");
        b.setCRS(this.inRaster.getCoordinateReferenceSystem());
        b.add("the_geom", Polygon.class);
        b.add("value", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        DefaultFeatureCollection outFC = new DefaultFeatureCollection();
        for (Geometry geometry : circles) {
            Object[] values = new Object[]{geometry, this.referenceImageValue};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            outFC.add(feature);
        }
        this.outCircles = outFC;
    }

    public Geometry[] getCircles() throws Exception {
        RandomIter renderedImageIterator = CoverageUtilities.getRandomIterator(this.inRaster);
        this.imageValues = new byte[this.width * this.height];
        int count = 0;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                double sample = renderedImageIterator.getSampleDouble(c, r, 0);
                if (JGTConstants.isNovalue(sample)) {
                    this.imageValues[count++] = 0;
                    continue;
                }
                this.referenceImageValue = sample;
                this.imageValues[count++] = 1;
            }
        }
        renderedImageIterator.done();
        double[][][] houghValues = this.houghTransform();
        Coordinate[] centerPoints = this.getCenterPoints(houghValues, this.maxCircles);
        Geometry[] geoms = new Geometry[centerPoints.length];
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        for (int i = 0; i < centerPoints.length; ++i) {
            Geometry circle;
            Coordinate c = centerPoints[i];
            Point2D world = CoverageUtilities.gridToWorld(gridGeometry, (int)c.x, (int)c.y);
            double radius = c.z * this.xRes;
            Coordinate w = new Coordinate(world.getX(), world.getY(), radius);
            Point point = this.gf.createPoint(w);
            geoms[i] = circle = point.buffer(radius);
        }
        return geoms;
    }

    private int buildLookUpTable() {
        int i = 0;
        int incDen = Math.round(8.0f * (float)this.radiusMinPixel);
        this.lut = new int[2][incDen][this.depth];
        for (int radius = this.radiusMinPixel; radius <= this.radiusMaxPixel; radius += this.radiusIncPixel) {
            i = 0;
            for (int incNun = 0; incNun < incDen; ++incNun) {
                int rsin;
                int rcos;
                double angle = Math.PI * 2 * (double)incNun / (double)incDen;
                int indexR = (radius - this.radiusMinPixel) / this.radiusIncPixel;
                if (!(i == 0 | (rcos = (int)Math.round((double)radius * Math.cos(angle))) != this.lut[0][i][indexR] & (rsin = (int)Math.round((double)radius * Math.sin(angle))) != this.lut[1][i][indexR])) continue;
                this.lut[0][i][indexR] = rcos;
                this.lut[1][i][indexR] = rsin;
                ++i;
            }
        }
        return i;
    }

    private double[][][] houghTransform() {
        int lutSize = this.buildLookUpTable();
        double[][][] houghValues = new double[this.width][this.height][this.depth];
        int k = this.width - 1;
        int l = this.height - 1;
        this.pm.beginTask("Hough transform...", l);
        for (int y = 1; y < l; ++y) {
            if (this.pm.isCanceled()) {
                throw new ModelsRuntimeException("Module interrupted.", this);
            }
            for (int x = 1; x < k; ++x) {
                for (int radius = this.radiusMinPixel; radius <= this.radiusMaxPixel; radius += this.radiusIncPixel) {
                    if (this.imageValues[x + this.offx + (y + this.offy) * this.offset] == 0) continue;
                    int indexR = (radius - this.radiusMinPixel) / this.radiusIncPixel;
                    for (int i = 0; i < lutSize; ++i) {
                        int a;
                        int b = y + this.lut[0][i][indexR];
                        if (!(b >= 0 & b < this.height & (a = x + this.lut[1][i][indexR]) >= 0 & a < this.width)) continue;
                        double[] dArray = houghValues[a][b];
                        int n = indexR;
                        dArray[n] = dArray[n] + 1.0;
                    }
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
        return houghValues;
    }

    private Coordinate[] getCenterPoints(double[][][] houghValues, int maxCircles) {
        Coordinate[] centerPoints = new Coordinate[maxCircles];
        int xMax = 0;
        int yMax = 0;
        int rMax = 0;
        this.pm.beginTask("Search for circles...", maxCircles);
        for (int c = 0; c < maxCircles; ++c) {
            double counterMax = -1.0;
            for (int radius = this.radiusMinPixel; radius <= this.radiusMaxPixel; radius += this.radiusIncPixel) {
                int indexR = (radius - this.radiusMinPixel) / this.radiusIncPixel;
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        if (!(houghValues[x][y][indexR] > counterMax)) continue;
                        counterMax = houghValues[x][y][indexR];
                        xMax = x;
                        yMax = y;
                        rMax = radius;
                    }
                }
            }
            centerPoints[c] = new Coordinate((double)xMax, (double)yMax, (double)rMax);
            this.clearNeighbours(houghValues, xMax, yMax, rMax);
            this.pm.worked(1);
        }
        this.pm.done();
        return centerPoints;
    }

    private void clearNeighbours(double[][][] houghValues, int x, int y, int radius) {
        double halfRadius = (float)radius / 2.0f;
        double halfSquared = halfRadius * halfRadius;
        int y1 = (int)Math.floor((double)y - halfRadius);
        int y2 = (int)Math.ceil((double)y + halfRadius) + 1;
        int x1 = (int)Math.floor((double)x - halfRadius);
        int x2 = (int)Math.ceil((double)x + halfRadius) + 1;
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > this.height) {
            y2 = this.height;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > this.width) {
            x2 = this.width;
        }
        for (int r = this.radiusMinPixel; r <= this.radiusMaxPixel; r += this.radiusIncPixel) {
            int indexR = (r - this.radiusMinPixel) / this.radiusIncPixel;
            for (int i = y1; i < y2; ++i) {
                for (int j = x1; j < x2; ++j) {
                    if (!(Math.pow(j - x, 2.0) + Math.pow(i - y, 2.0) < halfSquared)) continue;
                    houghValues[j][i][indexR] = 0.0;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int[] i;
        ThreadedRunnable runner = new ThreadedRunnable(OmsHoughCirclesRaster.getDefaultThreadsNum(), null);
        int[] nArray = i = new int[]{2};
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            int index;
            final int _index = index = nArray[j];
            runner.executeRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        String inRaster = "/home/hydrologis/data/rilievo_tls/avgres/las/vertical_slices/slice_" + _index + ".0.asc";
                        String outShp = "/home/hydrologis/data/rilievo_tls/avgres/las/vertical_slices/slice_vector_" + _index + ".0.shp";
                        GridCoverage2D src = OmsRasterReader.readRaster(inRaster);
                        OmsHoughCirclesRaster h = new OmsHoughCirclesRaster();
                        h.inRaster = src;
                        h.pMinRadius = 0.1;
                        h.pMaxRadius = 0.5;
                        h.pRadiusIncrement = 0.01;
                        h.pMaxCircleCount = 500;
                        h.process();
                        OmsVectorWriter.writeVector(outShp, h.outCircles);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        runner.waitAndClose();
    }
}

