/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.monitor;

import org.geotools.util.SimpleInternationalString;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.math.NumericsUtilities;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class GeotoolsProgressMonitorAdapter
implements IJGTProgressMonitor {
    private final ProgressListener geotoolsMonitor;
    private int totalWork;
    protected int runningWork;
    protected float lastPercentage = -1.0f;

    public GeotoolsProgressMonitorAdapter(ProgressListener geotoolsMonitor) {
        this.geotoolsMonitor = geotoolsMonitor;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.runningWork = 0;
        this.geotoolsMonitor.started();
        SimpleInternationalString iName = new SimpleInternationalString(name);
        this.geotoolsMonitor.setTask((InternationalString)iName);
    }

    public void beginTask(String name) {
        SimpleInternationalString iName = new SimpleInternationalString(name);
        this.geotoolsMonitor.setTask((InternationalString)iName);
    }

    @Override
    public void done() {
        this.geotoolsMonitor.complete();
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.geotoolsMonitor.isCanceled();
    }

    @Override
    public void setCanceled(boolean value) {
        this.geotoolsMonitor.setCanceled(value);
    }

    @Override
    public void setTaskName(String name) {
        SimpleInternationalString iName = new SimpleInternationalString(name);
        this.geotoolsMonitor.setTask((InternationalString)iName);
    }

    @Override
    public void subTask(String name) {
        SimpleInternationalString iName = new SimpleInternationalString(name);
        this.geotoolsMonitor.setTask((InternationalString)iName);
    }

    @Override
    public void worked(int work) {
        if (this.totalWork != -1) {
            this.runningWork += work;
            float percentage = (float)(100 * this.runningWork) / (float)this.totalWork;
            if (percentage % 10.0f == 0.0f && NumericsUtilities.fEq(percentage, this.lastPercentage)) {
                this.geotoolsMonitor.progress(percentage);
                this.lastPercentage = percentage;
            }
        }
    }

    @Override
    public <T> T adapt(Class<T> adaptee) {
        if (adaptee.isAssignableFrom(ProgressListener.class)) {
            return adaptee.cast(this.geotoolsMonitor);
        }
        return null;
    }

    @Override
    public void errorMessage(String message) {
    }

    @Override
    public void message(String message) {
    }

    @Override
    public void exceptionThrown(String message) {
    }

    @Override
    public void onModuleExit() {
    }
}

