/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;

public class Node {
    public final int row;
    public final int col;
    public final int cols;
    public final int rows;
    protected boolean isValid;
    protected boolean touchesBound = false;
    protected final RandomIter gridIter;

    public Node(RandomIter gridIter, int cols, int rows, int col, int row) {
        this.gridIter = gridIter;
        this.cols = cols;
        this.rows = rows;
        this.col = col;
        this.row = row;
    }

    public double getValueFromMap(RandomIter map) {
        try {
            if (map == null) {
                return Double.NaN;
            }
            double value = map.getSampleDouble(this.col, this.row, 0);
            return value;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void setValueInMap(WritableRandomIter map, double value) {
        if (map == null) {
            return;
        }
        try {
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean touchesBound() {
        return this.touchesBound;
    }
}

