/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class JGTProcessingRegion {
    private double north = Double.NaN;
    private double south = Double.NaN;
    private double west = Double.NaN;
    private double east = Double.NaN;
    private double ns_res = Double.NaN;
    private double we_res = Double.NaN;
    private int rows = 0;
    private int cols = 0;

    public JGTProcessingRegion(double west, double east, double south, double north, int rows, int cols) {
        this.west = west;
        this.east = east;
        this.south = south;
        this.north = north;
        this.rows = rows;
        this.cols = cols;
        this.fixResolution();
    }

    public JGTProcessingRegion(double west, double east, double south, double north, double weres, double nsres) {
        this.west = west;
        this.east = east;
        this.south = south;
        this.north = north;
        this.we_res = weres;
        this.ns_res = nsres;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public JGTProcessingRegion(JGTProcessingRegion region) {
        this.west = region.getWest();
        this.east = region.getEast();
        this.south = region.getSouth();
        this.north = region.getNorth();
        this.rows = region.getRows();
        this.cols = region.getCols();
        this.fixResolution();
    }

    public JGTProcessingRegion(Envelope2D envelope2D) {
        this.west = envelope2D.getMinX();
        this.east = envelope2D.getMaxX();
        this.south = envelope2D.getMinY();
        this.north = envelope2D.getMaxY();
        this.we_res = envelope2D.getHeight();
        this.ns_res = envelope2D.getWidth();
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public JGTProcessingRegion(GridCoverage2D gridCoverage) {
        RegionMap regionParams = CoverageUtilities.getRegionParamsFromGridCoverage(gridCoverage);
        this.west = (Double)regionParams.get("WEST");
        this.east = (Double)regionParams.get("EAST");
        this.south = (Double)regionParams.get("SOUTH");
        this.north = (Double)regionParams.get("NORTH");
        this.we_res = (Double)regionParams.get("XRES");
        this.ns_res = (Double)regionParams.get("YRES");
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public JGTProcessingRegion(String west, String east, String south, String north, String ewres, String nsres) {
        double[] nsew = this.nsewStringsToNumbers(north, south, east, west);
        double[] xyRes = this.xyResStringToNumbers(ewres, nsres);
        double no = nsew[0];
        double so = nsew[1];
        double ea = nsew[2];
        double we = nsew[3];
        double xres = xyRes[0];
        double yres = xyRes[1];
        JGTProcessingRegion tmp = new JGTProcessingRegion(we, ea, so, no, xres, yres);
        this.setExtent(tmp);
    }

    public JGTProcessingRegion(String west, String east, String south, String north, int rows, int cols) {
        double[] nsew = this.nsewStringsToNumbers(north, south, east, west);
        double no = nsew[0];
        double so = nsew[1];
        double ea = nsew[2];
        double we = nsew[3];
        JGTProcessingRegion tmp = new JGTProcessingRegion(we, ea, so, no, rows, cols);
        this.setExtent(tmp);
    }

    public void setExtent(JGTProcessingRegion region) {
        this.west = region.getWest();
        this.east = region.getEast();
        this.south = region.getSouth();
        this.north = region.getNorth();
        this.rows = region.getRows();
        this.cols = region.getCols();
        this.fixResolution();
        this.fixRowsAndCols();
    }

    public Envelope getEnvelope() {
        return new Envelope(new Coordinate(this.west, this.north), new Coordinate(this.east, this.south));
    }

    public Rectangle2D.Double getRectangle() {
        return new Rectangle2D.Double(this.west, this.south, this.east - this.west, this.north - this.south);
    }

    public String toString() {
        return "region:\nwest=" + this.west + "\neast=" + this.east + "\nsouth=" + this.south + "\nnorth=" + this.north + "\nwe_res=" + this.we_res + "\nns_res=" + this.ns_res + "\nrows=" + this.rows + "\ncols=" + this.cols;
    }

    public JGTProcessingRegion reproject(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws Exception {
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)lenient);
        Envelope envelope = this.getEnvelope();
        Envelope targetEnvelope = JTS.transform((Envelope)envelope, (MathTransform)transform);
        return new JGTProcessingRegion(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY(), this.getRows(), this.getCols());
    }

    private void fixResolution() {
        this.we_res = (this.east - this.west) / (double)this.cols;
        this.ns_res = (this.north - this.south) / (double)this.rows;
    }

    private void fixRowsAndCols() {
        this.rows = (int)Math.round((this.north - this.south) / this.ns_res);
        if (this.rows < 1) {
            this.rows = 1;
        }
        this.cols = (int)Math.round((this.east - this.west) / this.we_res);
        if (this.cols < 1) {
            this.cols = 1;
        }
    }

    public static Coordinate snapToNextHigherInRegionResolution(double x, double y, JGTProcessingRegion region) {
        double minx = region.getRectangle().getBounds2D().getMinX();
        double ewres = region.getWEResolution();
        double xsnap = minx + Math.ceil((x - minx) / ewres) * ewres;
        double miny = region.getRectangle().getBounds2D().getMinY();
        double nsres = region.getNSResolution();
        double ysnap = miny + Math.ceil((y - miny) / nsres) * nsres;
        return new Coordinate(xsnap, ysnap);
    }

    public List<JGTProcessingRegion> toSubRegions(int subregionsNum) {
        int tmpR = this.getRows();
        int tmpC = this.getCols();
        double tmpWest = this.getWest();
        double tmpSouth = this.getSouth();
        double tmpWERes = this.getWEResolution();
        double tmpNSRes = this.getNSResolution();
        if (subregionsNum > tmpR || subregionsNum > tmpC) {
            throw new IllegalArgumentException("The number of subregions has to be smaller than the number of rows and columns.");
        }
        int subregRows = (int)Math.floor((double)tmpR / (double)subregionsNum);
        int subregCols = (int)Math.floor((double)tmpC / (double)subregionsNum);
        ArrayList<JGTProcessingRegion> regions = new ArrayList<JGTProcessingRegion>();
        double runningEasting = tmpWest;
        double runningNorthing = tmpSouth;
        for (int i = 0; i < subregionsNum; ++i) {
            double n = runningNorthing + (double)subregRows * tmpNSRes;
            double s = runningNorthing;
            for (int j = 0; j < subregionsNum; ++j) {
                JGTProcessingRegion r;
                double w = runningEasting;
                double e = runningEasting + (double)subregCols * tmpWERes;
                if (e > this.getEast()) {
                    e = this.getEast();
                }
                if (n > this.getNorth()) {
                    n = this.getNorth();
                }
                if ((r = new JGTProcessingRegion(w, e, s, n, tmpWERes, tmpNSRes)).getWEResolution() == 0.0 || r.getNSResolution() == 0.0) continue;
                regions.add(r);
                runningEasting = e;
            }
            runningEasting = tmpWest;
            runningNorthing = n;
        }
        return regions;
    }

    private double degreeToNumber(String value) {
        double number = -1.0;
        String[] valueSplit = value.trim().split(":");
        if (valueSplit.length == 3) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            double sec = Double.parseDouble(valueSplit[2]);
            number = deg + min / 60.0 + sec / 60.0 / 60.0;
        } else if (valueSplit.length == 2) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            number = deg + min / 60.0;
        } else if (valueSplit.length == 1) {
            number = Double.parseDouble(valueSplit[0]);
        }
        return number;
    }

    private double[] xyResStringToNumbers(String ewres, String nsres) {
        double xres = -1.0;
        double yres = -1.0;
        xres = ewres.indexOf(58) != -1 ? this.degreeToNumber(ewres) : Double.parseDouble(ewres);
        yres = nsres.indexOf(58) != -1 ? this.degreeToNumber(nsres) : Double.parseDouble(nsres);
        return new double[]{xres, yres};
    }

    private double[] nsewStringsToNumbers(String north, String south, String east, String west) {
        double no = -1.0;
        double so = -1.0;
        double ea = -1.0;
        double we = -1.0;
        if (north.indexOf("N") != -1 || north.indexOf("n") != -1) {
            north = north.substring(0, north.length() - 1);
            no = this.degreeToNumber(north);
        } else if (north.indexOf("S") != -1 || north.indexOf("s") != -1) {
            north = north.substring(0, north.length() - 1);
            no = -this.degreeToNumber(north);
        } else {
            no = Double.parseDouble(north);
        }
        if (south.indexOf("N") != -1 || south.indexOf("n") != -1) {
            south = south.substring(0, south.length() - 1);
            so = this.degreeToNumber(south);
        } else if (south.indexOf("S") != -1 || south.indexOf("s") != -1) {
            south = south.substring(0, south.length() - 1);
            so = -this.degreeToNumber(south);
        } else {
            so = Double.parseDouble(south);
        }
        if (west.indexOf("E") != -1 || west.indexOf("e") != -1) {
            west = west.substring(0, west.length() - 1);
            we = this.degreeToNumber(west);
        } else if (west.indexOf("W") != -1 || west.indexOf("w") != -1) {
            west = west.substring(0, west.length() - 1);
            we = -this.degreeToNumber(west);
        } else {
            we = Double.parseDouble(west);
        }
        if (east.indexOf("E") != -1 || east.indexOf("e") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = this.degreeToNumber(east);
        } else if (east.indexOf("W") != -1 || east.indexOf("w") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = -this.degreeToNumber(east);
        } else {
            ea = Double.parseDouble(east);
        }
        return new double[]{no, so, ea, we};
    }

    public double getNorth() {
        return this.north;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public double getSouth() {
        return this.south;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getWest() {
        return this.west;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getEast() {
        return this.east;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getNSResolution() {
        return this.ns_res;
    }

    public void setNSResolution(double ns_res) {
        this.ns_res = ns_res;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public double getWEResolution() {
        return this.we_res;
    }

    public void setWEResolution(double we_res) {
        this.we_res = we_res;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.fixResolution();
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
        this.fixResolution();
    }

    public GridGeometry2D getGridGeometry(CoordinateReferenceSystem crs) {
        GridGeometry2D gridGeometry = CoverageUtilities.gridGeometryFromRegionParams(this.getRegionParams(), crs);
        return gridGeometry;
    }

    public HashMap<String, Double> getRegionParams() {
        RegionMap paramsMap = CoverageUtilities.makeRegionParamsMap(this.north, this.south, this.west, this.east, this.we_res, this.ns_res, this.cols, this.rows);
        return paramsMap;
    }
}

