/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.index.strtree.STRtreeJGT;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Reads indexes of Las files.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, lidar")
@Label(value="Lesto")
@Name(value="lasindexreader")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsLasIndexReader
extends JGTModel {
    @Description(value="The las index file.")
    @UI(value="infolder")
    @In
    public String inFile;
    @Description(value="The bounds of data to extract.")
    @In
    public SimpleFeatureCollection inBounds;
    @Description(value="The optional code defining the target coordinate reference system. This is needed only if the file has no prj file. If set, it will be used over the prj file.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="Flag to create only the boundary polygon from the envelope.")
    @In
    public boolean doBounds;
    @Description(value="The extracted data or bounds.")
    @Out
    public SimpleFeatureCollection outData;
    public boolean doInternal = false;
    public List<LasRecord> lasPoints = new ArrayList<LasRecord>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        SimpleFeatureType featureType;
        List<Object> boundsList;
        this.checkNull(this.inFile);
        if (!this.doBounds) {
            this.checkNull(this.inBounds);
        }
        CoordinateReferenceSystem crs = null;
        try {
            crs = CrsUtilities.readProjectionFile(this.inFile, "lasfolder");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (crs == null && this.pCode == null) {
            throw new ModelsIllegalargumentException("Either a .prj file of an EPSG code needs to be supplied.", this);
        }
        if (crs == null) {
            crs = CRS.decode((String)this.pCode);
        }
        GeometryFactory gf = GeometryUtilities.gf();
        File parentFolder = new File(this.inFile).getParentFile();
        STRtreeJGT mainIndexTree = OmsLasIndexReader.readIndex(this.inFile);
        if (!this.doBounds) {
            boundsList = FeatureUtilities.featureCollectionToGeometriesList(this.inBounds, true, null);
        } else {
            boundsList = new ArrayList<Polygon>();
            boundsList.add(gf.createPolygon(new Coordinate[]{new Coordinate(-1.7976931348623157E308, -1.7976931348623157E308), new Coordinate(-1.7976931348623157E308, Double.MAX_VALUE), new Coordinate(Double.MAX_VALUE, Double.MAX_VALUE), new Coordinate(Double.MAX_VALUE, -1.7976931348623157E308), new Coordinate(-1.7976931348623157E308, -1.7976931348623157E308)}));
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        SimpleFeatureBuilder builder = null;
        if (!this.doBounds) {
            b.setName("lasdata");
            b.setCRS(crs);
            b.add("the_geom", Point.class);
            b.add("elev", Double.class);
            b.add("intensity", Double.class);
            b.add("classification", Integer.class);
            b.add("impulse", Double.class);
            b.add("numimpulse", Double.class);
            featureType = b.buildFeatureType();
            builder = new SimpleFeatureBuilder(featureType);
        } else {
            b.setName("lasdatabounds");
            b.setCRS(crs);
            b.add("the_geom", Polygon.class);
            b.add("file", String.class);
            featureType = b.buildFeatureType();
            builder = new SimpleFeatureBuilder(featureType);
        }
        this.outData = new DefaultFeatureCollection();
        for (Geometry geometry : boundsList) {
            Envelope env = geometry.getEnvelopeInternal();
            List filesList = mainIndexTree.query(env);
            for (Object fileName : filesList) {
                if (!(fileName instanceof String)) continue;
                this.pm.message("Processing: " + fileName);
                String name = (String)fileName;
                File lasFile = new File(parentFolder, name);
                File lasIndexFile = FileUtilities.substituteExtention(lasFile, "lasfix");
                if (!lasIndexFile.exists() || !lasFile.exists()) continue;
                reader.open();
                try (ALasReader reader = ALasReader.getReader(lasFile, crs);){
                    ILasHeader header = reader.getHeader();
                    if (!this.doBounds) {
                        STRtreeJGT lasIndex = OmsLasIndexReader.readIndex(lasIndexFile.getAbsolutePath());
                        List lasIndexStoreInfoList = lasIndex.query(env);
                        this.pm.beginTask("Read data...", lasIndexStoreInfoList.size());
                        for (Object obj : lasIndexStoreInfoList) {
                            if (obj instanceof double[]) {
                                double[] addresses = (double[])obj;
                                long from = (long)addresses[0];
                                long to = (long)addresses[1];
                                for (long pointNum = from; pointNum < to; ++pointNum) {
                                    LasRecord lasDot = reader.getPointAt(pointNum);
                                    if (this.doInternal) {
                                        this.lasPoints.add(lasDot);
                                        continue;
                                    }
                                    double x = lasDot.x;
                                    double y = lasDot.y;
                                    double z = lasDot.z;
                                    double intensity = lasDot.intensity;
                                    byte classification = lasDot.classification;
                                    double impulse = lasDot.returnNumber;
                                    double impulseNumber = lasDot.numberOfReturns;
                                    Coordinate tmp = new Coordinate(x, y, z);
                                    Point point = gf.createPoint(tmp);
                                    Object[] values = new Object[]{point, z, intensity, (int)classification, impulse, impulseNumber};
                                    builder.addAll(values);
                                    SimpleFeature feature = builder.buildFeature(null);
                                    ((DefaultFeatureCollection)this.outData).add(feature);
                                }
                            }
                            this.pm.worked(1);
                        }
                        this.pm.done();
                        continue;
                    }
                    ReferencedEnvelope3D dataEnvelope = header.getDataEnvelope();
                    Polygon polygon = OmsLasIndexReader.envelopeToPolygon((Envelope)dataEnvelope);
                    Object[] values = new Object[]{polygon, name};
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(null);
                    ((DefaultFeatureCollection)this.outData).add(feature);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STRtreeJGT readIndex(String path) throws Exception {
        File file = new File(path);
        try (RandomAccessFile raf = null;){
            STRtreeJGT indexObj;
            raf = new RandomAccessFile(file, "r");
            long length = raf.length();
            byte[] bytes = new byte[(int)length];
            int read = raf.read(bytes);
            if ((long)read != length) {
                throw new IOException();
            }
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object readObject = in.readObject();
            STRtreeJGT sTRtreeJGT = indexObj = (STRtreeJGT)readObject;
            return sTRtreeJGT;
        }
    }

    public static Polygon envelopeToPolygon(Envelope envelope) {
        double w = envelope.getMinX();
        double e = envelope.getMaxX();
        double s = envelope.getMinY();
        double n = envelope.getMaxY();
        Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
        GeometryFactory gf = GeometryUtilities.gf();
        LinearRing linearRing = gf.createLinearRing(coords);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    @Finalize
    public void close() throws Exception {
    }
}

