/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.v_1_0;

import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.utils.LasUtils;
import org.joda.time.DateTime;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LasHeader
implements ILasHeader {
    String signature;
    short fileSourceId;
    int gpsTimeType;
    long projectIdGuidData1;
    short projectIdGuidData2;
    short projectIdGuidData3;
    String projectIdGuidData4;
    byte versionMajor;
    byte versionMinor;
    String systemIdentifier;
    String generatingSoftware;
    short dayOfYear;
    short year;
    short headerSize;
    long offset;
    long variableLengthRecordNum;
    byte pointDataFormat;
    short recordLength;
    long records;
    double xScale;
    double yScale;
    double zScale;
    double xOffset;
    double yOffset;
    double zOffset;
    double xMin;
    double yMin;
    double zMin;
    double xMax;
    double yMax;
    double zMax;
    private ReferencedEnvelope3D dataEnvelope;
    private CoordinateReferenceSystem crs;

    public LasHeader(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public String getVersion() {
        return this.versionMajor + "." + this.versionMinor;
    }

    @Override
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public long getRecordsCount() {
        return this.records;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public double[] getXYZScale() {
        return new double[]{this.xScale, this.yScale, this.zScale};
    }

    @Override
    public double[] getXYZOffset() {
        return new double[]{this.xOffset, this.yOffset, this.zOffset};
    }

    @Override
    public short getRecordLength() {
        return this.recordLength;
    }

    @Override
    public ReferencedEnvelope3D getDataEnvelope() {
        if (this.dataEnvelope == null) {
            this.dataEnvelope = new ReferencedEnvelope3D(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.getCrs());
        }
        return this.dataEnvelope;
    }

    @Override
    public boolean hasGpsTime() {
        return this.pointDataFormat == 1 || this.pointDataFormat == 3;
    }

    @Override
    public int getGpsTimeType() {
        return this.gpsTimeType;
    }

    @Override
    public boolean hasRGB() {
        return this.pointDataFormat == 2 || this.pointDataFormat == 3;
    }

    @Override
    public byte getPointDataFormat() {
        return this.pointDataFormat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File signature: ").append(this.signature).append("\n");
        sb.append("File source ID: ").append(this.fileSourceId).append("\n");
        sb.append("Project ID - data 1: ").append(this.projectIdGuidData1).append("\n");
        sb.append("Project ID - data 2: ").append(this.projectIdGuidData2).append("\n");
        sb.append("Project ID - data 3: ").append(this.projectIdGuidData3).append("\n");
        sb.append("Project ID - data 4: ").append(this.projectIdGuidData4).append("\n");
        sb.append("Version: ").append(this.versionMajor).append(".").append(this.versionMinor).append("\n");
        sb.append("System identifier: ").append(this.systemIdentifier).append("\n");
        sb.append("Generating software: ").append(this.generatingSoftware).append("\n");
        if (this.dayOfYear != 0 && this.year != 0) {
            DateTime dateTime = new DateTime();
            dateTime = dateTime.withYear((int)this.year).withDayOfYear((int)this.dayOfYear);
            String dtString = dateTime.toString(LasUtils.dateTimeFormatterYYYYMMDD);
            sb.append("File creation date: ").append(dtString).append("\n");
        } else {
            sb.append("File creation Day of Year: ").append(this.dayOfYear).append("\n");
            sb.append("File creation Year: ").append(this.year).append("\n");
        }
        sb.append("Header size: ").append(this.headerSize).append("\n");
        sb.append("Offset to data: ").append(this.offset).append("\n");
        sb.append("Variable length records: ").append(this.variableLengthRecordNum).append("\n");
        sb.append("Point data format ID (0-99 for spec): ").append(this.pointDataFormat).append("\n");
        sb.append("Number of point records: ").append(this.records).append("\n");
        sb.append("Record length: ").append(this.recordLength).append("\n");
        sb.append("Scale: [").append(this.xScale).append(", ").append(this.yScale).append(", ").append(this.zScale).append("]\n");
        sb.append("Offset: [").append(this.xOffset).append(", ").append(this.yOffset).append(", ").append(this.zOffset).append("]\n");
        sb.append("X Range: [").append(this.xMin).append(", ").append(this.xMax).append("]\n");
        sb.append("Y Range: [").append(this.yMin).append(", ").append(this.yMax).append("]\n");
        sb.append("Z Range: [").append(this.zMin).append(", ").append(this.zMax).append("]\n");
        sb.append("Has gps time info: ").append(this.hasGpsTime()).append("\n");
        sb.append("Has color info: ").append(this.hasRGB()).append("\n");
        sb.append("Gps time type: ").append(this.gpsTimeType).append("\n");
        return sb.toString();
    }
}

