/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.liblas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.core.liblas.LiblasHeader;
import org.jgrasstools.gears.io.las.core.liblas.LiblasJNALibrary;
import org.jgrasstools.gears.io.las.core.liblas.LiblasWrapper;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LiblasReader
extends ALasReader {
    private File lasFile;
    private long fileHandle;
    private long currentPointRef;
    private LiblasHeader headerHandle = null;
    private CoordinateReferenceSystem crs;
    private byte pointDataFormat;
    private long offset;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double zOffset = 0.0;
    private short recordLength;
    private LiblasJNALibrary WRAPPER;

    public LiblasReader(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        this.lasFile = lasFile;
        if (crs != null) {
            this.crs = crs;
        } else {
            try {
                this.crs = CrsUtilities.readProjectionFile(lasFile.getAbsolutePath(), "las");
            }
            catch (Exception e) {
                this.crs = CrsUtilities.readProjectionFile(lasFile.getAbsolutePath(), "laz");
            }
        }
        this.WRAPPER = LiblasWrapper.getWrapper();
    }

    @Override
    public void open() throws FileNotFoundException {
        if (!this.lasFile.exists()) {
            throw new FileNotFoundException(this.lasFile.getAbsolutePath());
        }
        this.fileHandle = this.WRAPPER.LASReader_Create(this.lasFile.getAbsolutePath());
        LiblasHeader header = this.getHeader();
        this.pointDataFormat = header.getPointDataFormat();
        this.offset = header.getOffset();
        this.recordLength = header.getRecordLength();
    }

    @Override
    public LiblasHeader getHeader() {
        if (this.headerHandle == null) {
            this.headerHandle = new LiblasHeader(this.WRAPPER, this.WRAPPER.LASReader_GetHeader(this.fileHandle), this.crs);
        }
        return this.headerHandle;
    }

    @Override
    public boolean hasNextPoint() {
        this.currentPointRef = this.WRAPPER.LASReader_GetNextPoint(this.fileHandle);
        return this.currentPointRef != 0L;
    }

    @Override
    public LasRecord getNextPoint() {
        return this.getPointAtRef(this.currentPointRef);
    }

    private LasRecord getPointAtRef(long ref) {
        double x = this.WRAPPER.LASPoint_GetX(ref);
        double y = this.WRAPPER.LASPoint_GetY(ref);
        double z = this.WRAPPER.LASPoint_GetZ(ref);
        LasRecord dot = new LasRecord();
        dot.x = x;
        dot.y = y;
        dot.z = z;
        short intensity = this.WRAPPER.LASPoint_GetIntensity(ref);
        short returnNumber = this.WRAPPER.LASPoint_GetReturnNumber(ref);
        short numberOfReturns = this.WRAPPER.LASPoint_GetNumberOfReturns(ref);
        byte classification = this.WRAPPER.LASPoint_GetClassification(ref);
        dot.intensity = intensity;
        dot.classification = classification;
        dot.returnNumber = returnNumber;
        dot.numberOfReturns = numberOfReturns;
        if (this.pointDataFormat == 1) {
            dot.gpsTime = this.WRAPPER.LASPoint_GetTime(ref);
        } else if (this.pointDataFormat == 2) {
            long colorHandle = this.WRAPPER.LASPoint_GetColor(ref);
            dot.color[0] = this.WRAPPER.LASColor_GetRed(colorHandle);
            dot.color[1] = this.WRAPPER.LASColor_GetGreen(colorHandle);
            dot.color[2] = this.WRAPPER.LASColor_GetBlue(colorHandle);
        } else if (this.pointDataFormat == 3) {
            dot.gpsTime = this.WRAPPER.LASPoint_GetTime(ref);
            long colorHandle = this.WRAPPER.LASPoint_GetColor(ref);
            dot.color[0] = this.WRAPPER.LASColor_GetRed(colorHandle);
            dot.color[1] = this.WRAPPER.LASColor_GetGreen(colorHandle);
            dot.color[2] = this.WRAPPER.LASColor_GetBlue(colorHandle);
        }
        return dot;
    }

    @Override
    public LasRecord getPointAt(long position) {
        this.currentPointRef = this.WRAPPER.LASReader_GetPointAt(this.fileHandle, position);
        return this.getPointAtRef(this.currentPointRef);
    }

    @Override
    public LasRecord getPointAtAddress(long address) {
        long pointNum = (address - this.offset) / (long)this.recordLength;
        this.currentPointRef = this.WRAPPER.LASReader_GetPointAt(this.fileHandle, pointNum);
        return this.getPointAtRef(this.currentPointRef);
    }

    @Override
    public void close() {
        this.WRAPPER.LASReader_Destroy(this.fileHandle);
    }

    @Override
    public File getLasFile() {
        return this.lasFile;
    }

    @Override
    public double[] readNextLasXYZAddress() throws IOException {
        throw new RuntimeException("not implemented yet: readNextLasXYZAddress");
    }

    @Override
    public void seek(long pointNumber) throws IOException {
        this.WRAPPER.LASReader_Seek(this.fileHandle, pointNumber);
        this.currentPointRef = this.WRAPPER.LASReader_GetNextPoint(this.fileHandle);
    }

    @Override
    public void setOverrideGpsTimeType(int type) {
    }
}

