/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.json;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Utility class for reading JSON files to geotools featurecollections. Each line represents a json feature.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, JSON, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="jsonfeaturereader")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsJsonFeatureReader
extends JGTModel {
    @Description(value="The JSON file to convert (it has to contain a lat and lon attribute).")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection geodata = null;

    @Execute
    public void readFeatureCollection() throws Exception {
        if (!this.concatOr(this.geodata == null, this.doReset)) {
            return;
        }
        this.pm.beginTask("Reading json data...", -1);
        List<String> jsonStringList = FileUtilities.readFileToLinesList(new File(this.file));
        this.pm.done();
        this.pm.message("Found records: " + jsonStringList.size());
        ArrayList<String> namesSet = new ArrayList<String>();
        ArrayList classSet = new ArrayList();
        int checkNum = 1000;
        this.pm.message("Define feature type based on the first " + checkNum + " records...");
        int count = 0;
        String latString = null;
        String lonString = null;
        for (String jsonString : jsonStringList) {
            if (count++ > checkNum) break;
            JSONObject jsonObject = new JSONObject(jsonString);
            String[] names = JSONObject.getNames((JSONObject)jsonObject);
            for (String name : names) {
                if (namesSet.contains(name)) continue;
                namesSet.add(name);
                Class<?> class1 = jsonObject.get(name).getClass();
                classSet.add(class1);
                this.pm.message("added: " + name);
                if (name.toLowerCase().equals("lat")) {
                    latString = name;
                }
                if (!name.toLowerCase().equals("lon")) continue;
                lonString = name;
            }
        }
        if (latString == null || lonString == null) {
            throw new ModelsIllegalargumentException("No lat or lon data found", this, this.pm);
        }
        this.geodata = new DefaultFeatureCollection();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("json");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", Point.class);
        int prefix = 1;
        for (int i = 0; i < namesSet.size(); ++i) {
            String name = (String)namesSet.get(i);
            Class class1 = (Class)classSet.get(i);
            b.add(prefix + name, class1);
            ++prefix;
        }
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        this.pm.beginTask("Converting json data...", jsonStringList.size());
        for (String jsonString : jsonStringList) {
            JSONObject jsonObject = new JSONObject(jsonString);
            Object latObj = jsonObject.get(latString);
            if (!(latObj instanceof Double)) {
                this.pm.errorMessage("no lat found in: " + jsonString);
                this.pm.worked(1);
                continue;
            }
            Object lonObj = jsonObject.get(lonString);
            if (!(lonObj instanceof Double)) {
                this.pm.errorMessage("no lon found in: " + jsonString);
                this.pm.worked(1);
                continue;
            }
            double lat = (Double)latObj;
            double lon = (Double)lonObj;
            Point point = this.gf.createPoint(new Coordinate(lon, lat));
            ArrayList<Object> objs = new ArrayList<Object>();
            objs.add(point);
            for (String name : namesSet) {
                Object value = null;
                if (jsonObject.has(name)) {
                    value = jsonObject.get(name);
                }
                objs.add(value);
            }
            builder.addAll(objs);
            SimpleFeature feature = builder.buildFeature(null);
            ((DefaultFeatureCollection)this.geodata).add(feature);
            this.pm.worked(1);
        }
        this.pm.done();
    }

    public static SimpleFeatureCollection readJsonfile(String path) throws Exception {
        OmsJsonFeatureReader reader = new OmsJsonFeatureReader();
        reader.file = path;
        reader.readFeatureCollection();
        return reader.geodata;
    }
}

