/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class Window {
    public static final String BLACKBOARD_KEY = "eu.hydrologis.jgrass.libs.region";
    public static final String BLANK_WINDOW = "proj:           0\nzone:           0\nnorth:          1\nsouth:          0\nwest:           0\neast:           1\nrows:           1\ncols:           1\ne-w resol:      1\nn-s resol:      1";
    private int proj = 0;
    private int zone = 0;
    private double n = -9999.0;
    private double s = -9999.0;
    private double w = -9999.0;
    private double e = -9999.0;
    private double ns_res = -9999.0;
    private double we_res = -9999.0;
    private int rows = 0;
    private int cols = 0;
    private LinkedHashMap<String, String> additionalGrassEntries;

    public Window(String windowFile) {
        Window.readWindowFile(windowFile, this);
    }

    public Window(double west, double east, double south, double north, int _rows, int _cols) {
        this.w = west;
        this.e = east;
        this.s = south;
        this.n = north;
        this.rows = _rows;
        this.cols = _cols;
        this.fixResolution();
    }

    public Window(double west, double east, double south, double north, double weres, double nsres) {
        this.w = west;
        this.e = east;
        this.s = south;
        this.n = north;
        this.we_res = weres;
        this.ns_res = nsres;
        this.fixRowsAndCols();
        this.fixResolution();
    }

    public Window(Window win) {
        this.w = win.getWest();
        this.e = win.getEast();
        this.s = win.getSouth();
        this.n = win.getNorth();
        this.rows = win.getRows();
        this.cols = win.getCols();
        this.fixResolution();
    }

    public Window(String west, String east, String south, String north, String ewres, String nsres) {
        double no = -1.0;
        double so = -1.0;
        double ea = -1.0;
        double we = -1.0;
        double xres = -1.0;
        double yres = -1.0;
        if (north.indexOf("N") != -1 || north.indexOf("n") != -1) {
            north = north.substring(0, north.length() - 1);
            no = this.degreeToNumber(north);
        } else if (north.indexOf("S") != -1 || north.indexOf("s") != -1) {
            north = north.substring(0, north.length() - 1);
            no = -this.degreeToNumber(north);
        } else {
            no = Double.parseDouble(north);
        }
        if (south.indexOf("N") != -1 || south.indexOf("n") != -1) {
            south = south.substring(0, south.length() - 1);
            so = this.degreeToNumber(south);
        } else if (south.indexOf("S") != -1 || south.indexOf("s") != -1) {
            south = south.substring(0, south.length() - 1);
            so = -this.degreeToNumber(south);
        } else {
            so = Double.parseDouble(south);
        }
        if (west.indexOf("E") != -1 || west.indexOf("e") != -1) {
            west = west.substring(0, west.length() - 1);
            we = this.degreeToNumber(west);
        } else if (west.indexOf("W") != -1 || west.indexOf("w") != -1) {
            west = west.substring(0, west.length() - 1);
            we = -this.degreeToNumber(west);
        } else {
            we = Double.parseDouble(west);
        }
        if (east.indexOf("E") != -1 || east.indexOf("e") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = this.degreeToNumber(east);
        } else if (east.indexOf("W") != -1 || east.indexOf("w") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = -this.degreeToNumber(east);
        } else {
            ea = Double.parseDouble(east);
        }
        xres = ewres.indexOf(58) != -1 ? this.degreeToNumber(ewres) : Double.parseDouble(ewres);
        yres = nsres.indexOf(58) != -1 ? this.degreeToNumber(nsres) : Double.parseDouble(nsres);
        Window tmp = new Window(we, ea, so, no, xres, yres);
        this.setExtent(tmp);
    }

    private double degreeToNumber(String value) {
        double number = -1.0;
        String[] valueSplit = value.trim().split(":");
        if (valueSplit.length == 3) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            double sec = Double.parseDouble(valueSplit[2]);
            number = deg + min / 60.0 + sec / 60.0 / 60.0;
        } else if (valueSplit.length == 2) {
            double deg = Double.parseDouble(valueSplit[0]);
            double min = Double.parseDouble(valueSplit[1]);
            number = deg + min / 60.0;
        } else if (valueSplit.length == 1) {
            number = Double.parseDouble(valueSplit[0]);
        }
        return number;
    }

    public Window(String west, String east, String south, String north, int rows, int cols) {
        double no = -1.0;
        double so = -1.0;
        double ea = -1.0;
        double we = -1.0;
        if (north.indexOf("N") != -1 || north.indexOf("n") != -1) {
            north = north.substring(0, north.length() - 1);
            no = this.degreeToNumber(north);
        } else if (north.indexOf("S") != -1 || north.indexOf("s") != -1) {
            north = north.substring(0, north.length() - 1);
            no = -this.degreeToNumber(north);
        } else {
            no = Double.parseDouble(north);
        }
        if (south.indexOf("N") != -1 || south.indexOf("n") != -1) {
            south = south.substring(0, south.length() - 1);
            so = this.degreeToNumber(south);
        } else if (south.indexOf("S") != -1 || south.indexOf("s") != -1) {
            south = south.substring(0, south.length() - 1);
            so = -this.degreeToNumber(south);
        } else {
            so = Double.parseDouble(south);
        }
        if (west.indexOf("E") != -1 || west.indexOf("e") != -1) {
            west = west.substring(0, west.length() - 1);
            we = this.degreeToNumber(west);
        } else if (west.indexOf("W") != -1 || west.indexOf("w") != -1) {
            west = west.substring(0, west.length() - 1);
            we = -this.degreeToNumber(west);
        } else {
            we = Double.parseDouble(west);
        }
        if (east.indexOf("E") != -1 || east.indexOf("e") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = this.degreeToNumber(east);
        } else if (east.indexOf("W") != -1 || east.indexOf("w") != -1) {
            east = east.substring(0, east.length() - 1);
            ea = -this.degreeToNumber(east);
        } else {
            ea = Double.parseDouble(east);
        }
        Window tmp = new Window(we, ea, so, no, rows, cols);
        this.setExtent(tmp);
    }

    public Envelope getEnvelope() {
        return new Envelope(new Coordinate(this.w, this.n), new Coordinate(this.e, this.s));
    }

    public void limitRowsCols(int _rows, int _cols) {
        if (this.rows > _rows) {
            this.rows = _rows;
        }
        if (this.cols > _cols) {
            this.cols = _cols;
        }
        this.fixResolution();
    }

    public void setExtent(Window win) {
        this.w = win.getWest();
        this.e = win.getEast();
        this.n = win.getNorth();
        this.s = win.getSouth();
        this.rows = win.getRows();
        this.cols = win.getCols();
        this.fixResolution();
        this.fixRowsAndCols();
    }

    public Rectangle2D.Double getRectangle() {
        return new Rectangle2D.Double(this.w, this.s, this.getXExtent(), this.getYExtent());
    }

    public String toString() {
        return "window:\nwest=" + this.w + "\neast=" + this.e + "\nsouth=" + this.s + "\nnorth=" + this.n + "\nwe_res=" + this.we_res + "\nns_res=" + this.ns_res + "\nrows=" + this.rows + "\ncols=" + this.cols;
    }

    public void fixResolution() {
        this.we_res = (this.e - this.w) / (double)this.cols;
        this.ns_res = (this.n - this.s) / (double)this.rows;
    }

    public void fixRowsAndCols() {
        this.rows = (int)Math.round((this.n - this.s) / this.ns_res);
        if (this.rows < 1) {
            this.rows = 1;
        }
        this.cols = (int)Math.round((this.e - this.w) / this.we_res);
        if (this.cols < 1) {
            this.cols = 1;
        }
    }

    public int getProj() {
        return this.proj;
    }

    public void setProj(int _proj) {
        this.proj = _proj;
    }

    public int getZone() {
        return this.zone;
    }

    public void setZone(int _zone) {
        this.zone = _zone;
    }

    public double getWest() {
        return this.w;
    }

    public double getEast() {
        return this.e;
    }

    public double getSouth() {
        return this.s;
    }

    public double getNorth() {
        return this.n;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public double getWEResolution() {
        return this.we_res;
    }

    public double getNSResolution() {
        return this.ns_res;
    }

    public double getXExtent() {
        return this.e - this.w;
    }

    public double getYExtent() {
        return this.n - this.s;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setEast(double e) {
        this.e = e;
    }

    public void setNorth(double n) {
        this.n = n;
    }

    public void setNSResolution(double ns_res) {
        this.ns_res = ns_res;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setSouth(double s) {
        this.s = s;
    }

    public void setWest(double w) {
        this.w = w;
    }

    public void setWEResolution(double we_res) {
        this.we_res = we_res;
    }

    public void setAdditionalGrassEntries(LinkedHashMap<String, String> adds) {
        this.additionalGrassEntries = adds;
    }

    public LinkedHashMap<String, String> getAdditionalGrassEntries() {
        return this.additionalGrassEntries;
    }

    public static Point2D.Double snapToNextHigherInActiveRegionResolution(double x, double y, Window activeWindow) {
        double minx = activeWindow.getRectangle().getBounds2D().getMinX();
        double ewres = activeWindow.getWEResolution();
        double xsnap = minx + Math.ceil((x - minx) / ewres) * ewres;
        double miny = activeWindow.getRectangle().getBounds2D().getMinY();
        double nsres = activeWindow.getNSResolution();
        double ysnap = miny + Math.ceil((y - miny) / nsres) * nsres;
        return new Point2D.Double(xsnap, ysnap);
    }

    public static Window getActiveWindowFromMapset(String mapsetPath) {
        File windFile = new File(mapsetPath + File.separator + "WIND");
        if (!windFile.exists()) {
            return null;
        }
        return new Window(windFile.getAbsolutePath());
    }

    public static void writeActiveWindowToMapset(String mapsetPath, Window window) throws IOException {
        Window.writeWindowFile(mapsetPath + File.separator + "WIND", window);
    }

    public static void writeDefaultWindowToLocation(String locationPath, Window window) throws IOException {
        Window.writeWindowFile(locationPath + File.separator + "PERMANENT" + File.separator + "DEFAULT_WIND", window);
    }

    public static Window adaptActiveRegionToEnvelope(Envelope bounds, Window activeRegion) {
        Point2D.Double eastNorth = Window.snapToNextHigherInActiveRegionResolution(bounds.getMaxX(), bounds.getMaxY(), activeRegion);
        Point2D.Double westsouth = Window.snapToNextHigherInActiveRegionResolution(bounds.getMinX() - activeRegion.getWEResolution(), bounds.getMinY() - activeRegion.getNSResolution(), activeRegion);
        Window tmp = new Window(((Point2D)westsouth).getX(), ((Point2D)eastNorth).getX(), ((Point2D)westsouth).getY(), ((Point2D)eastNorth).getY(), activeRegion.getWEResolution(), activeRegion.getNSResolution());
        return tmp;
    }

    private static Throwable readWindowFile(String filePath, Window w) {
        try {
            String line;
            BufferedReader windReader = new BufferedReader(new FileReader(filePath));
            LinkedHashMap<String, String> store = new LinkedHashMap<String, String>();
            while ((line = windReader.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line = line.replaceFirst(":", "@@@@"), "@@@@");
                if (tok.countTokens() != 2) continue;
                String key = tok.nextToken().trim();
                String value = tok.nextToken().trim();
                if (key.indexOf("res") != -1 && key.indexOf("resol") == -1 || key.indexOf("res3") != -1) {
                    if (key.startsWith("compressed")) continue;
                    store.put(key.replaceAll("res", "resol"), value);
                    continue;
                }
                store.put(key, value);
            }
            try {
                w.setProj(Integer.parseInt((String)store.get("proj")));
                w.setZone(Integer.parseInt((String)store.get("zone")));
                store.remove("proj");
                store.remove("zone");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Window tmpWindow = null;
            if (store.containsKey("n-s res")) {
                tmpWindow = new Window((String)store.get("west"), (String)store.get("east"), (String)store.get("south"), (String)store.get("north"), (String)store.get("e-w res"), (String)store.get("n-s res"));
                store.remove("e-w resol");
                store.remove("n-s resol");
            } else if (store.containsKey("cols")) {
                tmpWindow = new Window((String)store.get("west"), (String)store.get("east"), (String)store.get("south"), (String)store.get("north"), Integer.parseInt((String)store.get("rows")), Integer.parseInt((String)store.get("cols")));
                store.remove("cols");
                store.remove("rows");
            } else {
                throw new RuntimeException();
            }
            store.remove("north");
            store.remove("south");
            store.remove("east");
            store.remove("west");
            tmpWindow.setAdditionalGrassEntries(store);
            w.setExtent(tmpWindow);
            windReader.close();
            windReader = null;
            store = null;
        }
        catch (FileNotFoundException e) {
            return new RuntimeException().initCause(e);
        }
        catch (IOException e) {
            return new RuntimeException().initCause(e);
        }
        return null;
    }

    private static void writeWindowFile(String filepath, Window w) throws IOException {
        String line;
        File file = new File(filepath);
        if (!file.exists()) {
            String nameLower = file.getName().toLowerCase();
            String nameUpper = file.getName().toUpperCase();
            String baseDir = file.getParent();
            File tmpFile = null;
            tmpFile = new File(baseDir + File.separator + nameLower);
            if (tmpFile.exists()) {
                file = tmpFile;
            } else {
                tmpFile = new File(baseDir + File.separator + nameUpper);
                if (tmpFile.exists()) {
                    file = tmpFile;
                } else {
                    BufferedWriter out = new BufferedWriter(new FileWriter(file));
                    out.write(BLANK_WINDOW);
                    out.close();
                }
            }
        }
        BufferedReader windReader = new BufferedReader(new FileReader(file));
        LinkedHashMap<String, String> store = new LinkedHashMap<String, String>();
        while ((line = windReader.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, ":");
            if (tok.countTokens() != 2) continue;
            String key = tok.nextToken().trim();
            String value = tok.nextToken().trim();
            if (key.indexOf("res") != -1 && key.indexOf("resol") == -1 || key.indexOf("res3") != -1) {
                store.put(key.replaceAll("res", "resol"), value);
                continue;
            }
            store.put(key, value);
        }
        store.put("north", new Double(w.getNorth()).toString());
        store.put("south", new Double(w.getSouth()).toString());
        store.put("east", new Double(w.getEast()).toString());
        store.put("west", new Double(w.getWest()).toString());
        store.put("n-s resol", new Double(w.getNSResolution()).toString());
        store.put("e-w resol", new Double(w.getWEResolution()).toString());
        store.put("cols", new Integer(w.getCols()).toString());
        store.put("rows", new Integer(w.getRows()).toString());
        windReader.close();
        windReader = null;
        StringBuffer data = new StringBuffer(512);
        for (String key : store.keySet()) {
            data.append(key + ":   " + (String)store.get(key) + "\n");
        }
        BufferedWriter windWriter = new BufferedWriter(new FileWriter(file));
        windWriter.write(data.toString());
        windWriter.flush();
        windWriter.close();
    }
}

