/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.io;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.zip.Deflater;
import org.jgrasstools.gears.io.grasslegacy.io.RasterWritingFailureException;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;

public class CompressesRasterWriter {
    private static final String ERROR_IN_WRITING_RASTER = "Error in writing raster: ";
    private int outputToDiskType = 0;
    private double[] range = null;
    private long pointerInFilePosition = 0L;
    private long[] rowaddresses = null;
    private Window dataWindow = null;

    public CompressesRasterWriter(int _outputToDiskType, double[] _range, long _pointerInFilePosition, long[] _rowaddresses, Window _dataWindow) {
        this.outputToDiskType = _outputToDiskType;
        this.range = _range;
        this.range[0] = Double.POSITIVE_INFINITY;
        this.range[1] = Double.NEGATIVE_INFINITY;
        this.pointerInFilePosition = _pointerInFilePosition;
        this.rowaddresses = _rowaddresses;
        this.dataWindow = _dataWindow;
    }

    public boolean compressAndWriteObj(RandomAccessFile theCreatedFile, RandomAccessFile theCreatedNullFile, Object dataObject) throws RasterWritingFailureException {
        if (!(dataObject instanceof double[][])) {
            throw new RasterWritingFailureException("Raster type not supported.");
        }
        this.compressAndWrite(theCreatedFile, theCreatedNullFile, (double[][])dataObject);
        return true;
    }

    private boolean compressAndWrite(RandomAccessFile theCreatedFile, RandomAccessFile theCreatedNullFile, double[][] rastermatrix) throws RasterWritingFailureException {
        try {
            int i;
            int numberofbytes = this.outputToDiskType * 4;
            byte[] rowAsBytes = new byte[rastermatrix[0].length * numberofbytes];
            ByteBuffer rowAsByteBuffer = ByteBuffer.wrap(rowAsBytes);
            int numberOfValuesPerRow = rastermatrix[0].length;
            int rest = numberOfValuesPerRow % 8;
            int paddings = 0;
            if (rest != 0) {
                paddings = 8 - rest;
            }
            BitSet nullbits = new BitSet(numberOfValuesPerRow + paddings);
            int k = 0;
            for (i = 0; i < rastermatrix.length; ++i) {
                for (int j = 0; j < rastermatrix[0].length; ++j) {
                    if (!Double.isNaN(rastermatrix[i][j])) {
                        if (rastermatrix[i][j] < this.range[0]) {
                            this.range[0] = rastermatrix[i][j];
                        }
                        if (rastermatrix[i][j] > this.range[1]) {
                            this.range[1] = rastermatrix[i][j];
                        }
                        if (numberofbytes == 8) {
                            rowAsByteBuffer.putDouble(rastermatrix[i][j]);
                        } else {
                            rowAsByteBuffer.putFloat((float)rastermatrix[i][j]);
                        }
                        ++k;
                        continue;
                    }
                    if (numberofbytes == 8) {
                        rowAsByteBuffer.putDouble(0.0);
                    } else {
                        rowAsByteBuffer.putFloat(0.0f);
                    }
                    nullbits.set(k);
                    ++k;
                }
                int l = 0;
                byte[] bytearray = new byte[(numberOfValuesPerRow + paddings) / 8];
                for (int e = 0; e < (numberOfValuesPerRow + paddings) / 8; ++e) {
                    bytearray[e] = 0;
                    for (int f = 0; f < 8; ++f) {
                        if (nullbits.get(l)) {
                            int n = e;
                            bytearray[n] = (byte)(bytearray[n] + (byte)Math.pow(2.0, 7 - f));
                        }
                        ++l;
                    }
                }
                theCreatedNullFile.write(bytearray);
                nullbits.clear();
                k = 0;
                byte[] output = new byte[rowAsBytes.length * 2];
                Deflater compresser = new Deflater();
                compresser.setInput(rowAsBytes);
                compresser.finish();
                int compressedDataLength = compresser.deflate(output);
                theCreatedFile.seek(this.pointerInFilePosition);
                theCreatedFile.write(49);
                theCreatedFile.write(output, 0, compressedDataLength);
                this.rowaddresses[i + 1] = this.pointerInFilePosition = theCreatedFile.getFilePointer();
                rowAsByteBuffer.clear();
            }
            theCreatedFile.seek(1L);
            for (i = 0; i < this.rowaddresses.length; ++i) {
                theCreatedFile.writeInt((int)this.rowaddresses[i]);
            }
        }
        catch (Exception e) {
            throw new RasterWritingFailureException(ERROR_IN_WRITING_RASTER + e.getLocalizedMessage());
        }
        return true;
    }

    public Window getDataWindow() {
        return this.dataWindow;
    }

    public int getOutputToDiskType() {
        return this.outputToDiskType;
    }

    public long getPointerInFilePosition() {
        return this.pointerInFilePosition;
    }

    public double[] getRange() {
        return this.range;
    }

    public long[] getRowaddresses() {
        return this.rowaddresses;
    }
}

