/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.HashMap;
import java.util.Set;
import javax.media.jai.Interpolation;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.io.grasslegacy.utils.GrassLegacyUtilities;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GrassLegacyGridCoverage2D
extends GridCoverage2D {
    private static final long serialVersionUID = 1L;
    private Window window;
    private double[][] data;
    private CoordinateReferenceSystem jgCrs;
    private HashMap<String, Double> regionParamsMap;
    private GridGeometry2D jgGridGeometry;

    public GrassLegacyGridCoverage2D(CharSequence name, GridCoverage2D coverage) {
        super(name, coverage);
    }

    public GrassLegacyGridCoverage2D(Window window, double[][] data, CoordinateReferenceSystem crs) {
        super((CharSequence)"dummy", CoverageUtilities.buildDummyCoverage());
        this.window = window;
        this.data = data;
        this.jgCrs = crs;
        this.regionParamsMap = CoverageUtilities.makeRegionParamsMap(window.getNorth(), window.getSouth(), window.getWest(), window.getEast(), window.getWEResolution(), window.getNSResolution(), window.getCols(), window.getRows());
        this.jgGridGeometry = CoverageUtilities.gridGeometryFromRegionParams(this.regionParamsMap, this.jgCrs);
    }

    public boolean isDataEditable() {
        return true;
    }

    public GridGeometry2D getGridGeometry() {
        return this.jgGridGeometry;
    }

    public org.opengis.geometry.Envelope getEnvelope() {
        Envelope envelope = this.window.getEnvelope();
        ReferencedEnvelope env = new ReferencedEnvelope(envelope, this.jgCrs);
        return env;
    }

    public Envelope2D getEnvelope2D() {
        return this.jgGridGeometry.getEnvelope2D();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
        return this.jgGridGeometry.getCoordinateReferenceSystem2D();
    }

    public int getNumSampleDimensions() {
        return 1;
    }

    public GridSampleDimension getSampleDimension(int index) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridSampleDimension[] getSampleDimensions() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Interpolation getInterpolation() {
        return Interpolation.getInstance((int)0);
    }

    private double getValue(Coordinate coordinate) {
        int[] rowCol = GrassLegacyUtilities.coordinateToNearestRowCol(this.window, coordinate);
        return this.getValue(rowCol[0], rowCol[1]);
    }

    private double getValue(int x, int y) {
        if (y < 0 || y >= this.data.length) {
            return Double.NaN;
        }
        if (x < 0 || x >= this.data[0].length) {
            return Double.NaN;
        }
        return this.data[y][x];
    }

    private double getValue(DirectPosition point) {
        double[] coordinateArray = point.getCoordinate();
        Coordinate coordinate = new Coordinate(coordinateArray[0], coordinateArray[1]);
        return this.getValue(coordinate);
    }

    private double getValue(Point2D coord) {
        Coordinate coordinate = new Coordinate(coord.getX(), coord.getY());
        return this.getValue(coordinate);
    }

    private double getValue(GridCoordinates2D coord) {
        return this.getValue(coord.x, coord.y);
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        return this.getValue(point);
    }

    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new int[]{};
        }
        dest[0] = (int)this.getValue(coord);
        return dest;
    }

    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new float[]{};
        }
        dest[0] = (float)this.getValue(coord);
        return dest;
    }

    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new double[]{};
        }
        dest[0] = this.getValue(coord);
        return dest;
    }

    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new int[]{};
        }
        dest[0] = (int)this.getValue(coord);
        return dest;
    }

    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new float[]{};
        }
        dest[0] = (float)this.getValue(coord);
        return dest;
    }

    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        if (dest == null) {
            dest = new double[]{};
        }
        dest[0] = this.getValue(coord);
        return dest;
    }

    public int[] evaluate(GridCoordinates2D coord, int[] dest) {
        if (dest == null) {
            dest = new int[]{};
        }
        dest[0] = (int)this.getValue(coord);
        return dest;
    }

    public float[] evaluate(GridCoordinates2D coord, float[] dest) {
        if (dest == null) {
            dest = new float[]{};
        }
        dest[0] = (float)this.getValue(coord);
        return dest;
    }

    public double[] evaluate(GridCoordinates2D coord, double[] dest) {
        if (dest == null) {
            dest = new double[]{};
        }
        dest[0] = this.getValue(coord);
        return dest;
    }

    public synchronized String getDebugString(DirectPosition coord) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int[] getOptimalDataBlockSizes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public RenderedImage getRenderedImage() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void show(String title, int xAxis, int yAxis) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void show(String title) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void prefetch(Rectangle2D area) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridCoverage2D geophysics(boolean geo) {
        return this;
    }

    public GridCoverage2D view(ViewType type) {
        return this;
    }

    public synchronized Set<ViewType> getViewTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public synchronized boolean dispose(boolean force) {
        this.data = null;
        return true;
    }

    public String toString() {
        return this.window.toString();
    }

    public double[][] getData() {
        return this.data;
    }
}

