/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.geopap4;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public enum TimeUtilities {
    INSTANCE;

    private static final String UTC = "UTC";
    public final Locale dateLocale = Locale.US;
    public final SimpleDateFormat TIMESTAMPFORMATTER_LOCAL = new SimpleDateFormat("yyyyMMdd_HHmmss", this.dateLocale);
    public final SimpleDateFormat TIMESTAMPFORMATTER_UTC = new SimpleDateFormat("yyyyMMdd_HHmmss", this.dateLocale);
    public final SimpleDateFormat DATEONLY_FORMATTER = new SimpleDateFormat("yyyy-MM-dd", this.dateLocale);
    public final SimpleDateFormat TIMEONLY_FORMATTER = new SimpleDateFormat("HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat TIME_FORMATTER_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat TIME_FORMATTER_LOCAL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat TIME_FORMATTER_SQLITE_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat TIME_FORMATTER_SQLITE_LOCAL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", this.dateLocale);
    public final SimpleDateFormat TIME_FORMATTER_GPX_UTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", this.dateLocale);
    public final SimpleDateFormat EXIFFORMATTER = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", this.dateLocale);

    private TimeUtilities() {
        this.TIME_FORMATTER_SQLITE_UTC.setTimeZone(TimeZone.getTimeZone(UTC));
        this.TIME_FORMATTER_GPX_UTC.setTimeZone(TimeZone.getTimeZone(UTC));
        this.TIME_FORMATTER_UTC.setTimeZone(TimeZone.getTimeZone(UTC));
        this.TIMESTAMPFORMATTER_UTC.setTimeZone(TimeZone.getTimeZone(UTC));
        this.EXIFFORMATTER.setTimeZone(TimeZone.getTimeZone(UTC));
    }

    public static String utcToLocalTime(String dateTime) throws Exception {
        Date date = TimeUtilities.INSTANCE.TIME_FORMATTER_UTC.parse(dateTime);
        return TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(date);
    }
}

