/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.geopap4;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jgrasstools.gears.io.geopaparazzi.OmsGeopaparazziProject3To4Converter;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TimeUtilities;

public class DaoGpsLog {
    public static void createTables(Connection connection) throws IOException, SQLException {
        StringBuilder sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("gpslogs");
        sB.append(" (");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_ID.getFieldName() + " INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_LOG_STARTTS.getFieldName()).append(" LONG NOT NULL,");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_LOG_ENDTS.getFieldName()).append(" LONG NOT NULL,");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_LOG_LENGTHM.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_LOG_ISDIRTY.getFieldName()).append(" INTEGER NOT NULL, ");
        sB.append(TableDescriptions.GpsLogsTableFields.COLUMN_LOG_TEXT.getFieldName()).append(" TEXT NOT NULL ");
        sB.append(");");
        String CREATE_TABLE_GPSLOGS = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("gpslogsdata");
        sB.append(" (");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_ID.getFieldName() + " INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LON.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LAT.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_ALTIM.getFieldName()).append(" REAL NOT NULL,");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_TS.getFieldName()).append(" DATE NOT NULL,");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName()).append(" INTEGER NOT NULL ");
        sB.append("CONSTRAINT ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName());
        sB.append(" REFERENCES ");
        sB.append("gpslogs");
        sB.append("(" + TableDescriptions.GpsLogsTableFields.COLUMN_ID.getFieldName() + ") ON DELETE CASCADE");
        sB.append(");");
        String CREATE_TABLE_GPSLOG_DATA = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX gpslog_id_idx ON ");
        sB.append("gpslogsdata");
        sB.append(" ( ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_GPSLOG_ID = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX gpslog_ts_idx ON ");
        sB.append("gpslogsdata");
        sB.append(" ( ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_TS.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_GPSLOG_TS = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX gpslog_x_by_y_idx ON ");
        sB.append("gpslogsdata");
        sB.append(" ( ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LON.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LAT.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_GPSLOG_X_BY_Y = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE INDEX gpslog_logid_x_y_idx ON ");
        sB.append("gpslogsdata");
        sB.append(" ( ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LON.getFieldName());
        sB.append(", ");
        sB.append(TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LAT.getFieldName());
        sB.append(" );");
        String CREATE_INDEX_GPSLOG_LOGID_X_Y = sB.toString();
        sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("gpslogsproperties");
        sB.append(" (");
        sB.append(TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_ID.getFieldName());
        sB.append(" INTEGER PRIMARY KEY, ");
        sB.append(TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_LOGID.getFieldName());
        sB.append(" INTEGER NOT NULL ");
        sB.append("CONSTRAINT " + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_LOGID.getFieldName() + " REFERENCES ");
        sB.append("gpslogs");
        sB.append("(");
        sB.append((Object)TableDescriptions.GpsLogsTableFields.COLUMN_ID);
        sB.append(") ON DELETE CASCADE,");
        sB.append(TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_COLOR.getFieldName()).append(" TEXT NOT NULL, ");
        sB.append(TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_WIDTH.getFieldName()).append(" REAL NOT NULL, ");
        sB.append(TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_VISIBLE.getFieldName()).append(" INTEGER NOT NULL");
        sB.append(");");
        String CREATE_TABLE_GPSLOGS_PROPERTIES = sB.toString();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(CREATE_TABLE_GPSLOGS);
            statement.executeUpdate(CREATE_TABLE_GPSLOG_DATA);
            statement.executeUpdate(CREATE_INDEX_GPSLOG_ID);
            statement.executeUpdate(CREATE_INDEX_GPSLOG_TS);
            statement.executeUpdate(CREATE_INDEX_GPSLOG_X_BY_Y);
            statement.executeUpdate(CREATE_INDEX_GPSLOG_LOGID_X_Y);
            statement.executeUpdate(CREATE_TABLE_GPSLOGS_PROPERTIES);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static void addGpsLog(Connection connection, OmsGeopaparazziProject3To4Converter.GpsLog log, float width, String color, boolean visible) throws Exception {
        Date startTS = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.parse(log.startTime);
        Date endTS = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.parse(log.endTime);
        String insertSQL1 = "INSERT INTO gpslogs(" + TableDescriptions.GpsLogsTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_STARTTS.getFieldName() + ", " + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_ENDTS.getFieldName() + ", " + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_LENGTHM.getFieldName() + ", " + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_TEXT.getFieldName() + ", " + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_ISDIRTY.getFieldName() + ") VALUES" + "(?,?,?,?,?,?)";
        PreparedStatement writeStatement = connection.prepareStatement(insertSQL1);
        Object object = null;
        try {
            writeStatement.setLong(1, log.id);
            writeStatement.setLong(2, startTS.getTime());
            writeStatement.setLong(3, endTS.getTime());
            writeStatement.setDouble(4, 0.0);
            writeStatement.setString(5, log.text);
            writeStatement.setInt(6, 1);
            writeStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writeStatement != null) {
                if (object != null) {
                    try {
                        writeStatement.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    writeStatement.close();
                }
            }
        }
        String insertSQL2 = "INSERT INTO gpslogsproperties(" + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_LOGID.getFieldName() + ", " + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_COLOR.getFieldName() + ", " + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_WIDTH.getFieldName() + ", " + TableDescriptions.GpsLogsPropertiesTableFields.COLUMN_PROPERTIES_VISIBLE.getFieldName() + ") VALUES" + "(?,?,?,?,?)";
        try (PreparedStatement writeStatement2 = connection.prepareStatement(insertSQL2);){
            writeStatement2.setLong(1, log.id);
            writeStatement2.setLong(2, log.id);
            writeStatement2.setString(3, color);
            writeStatement2.setFloat(4, width);
            writeStatement2.setInt(5, visible ? 1 : 0);
            writeStatement2.executeUpdate();
        }
        for (OmsGeopaparazziProject3To4Converter.GpsPoint point : log.points) {
            DaoGpsLog.addGpsLogDataPoint(connection, point, log.id);
        }
    }

    public static void addGpsLogDataPoint(Connection connection, OmsGeopaparazziProject3To4Converter.GpsPoint point, long gpslogId) throws Exception {
        Date timestamp = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.parse(point.utctime);
        String insertSQL = "INSERT INTO gpslogsdata(" + TableDescriptions.GpsLogsDataTableFields.COLUMN_ID.getFieldName() + ", " + TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName() + ", " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LON.getFieldName() + ", " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LAT.getFieldName() + ", " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_ALTIM.getFieldName() + ", " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_TS.getFieldName() + ") VALUES" + "(?,?,?,?,?,?)";
        try (PreparedStatement writeStatement = connection.prepareStatement(insertSQL);){
            writeStatement.setLong(1, point.id);
            writeStatement.setLong(2, gpslogId);
            writeStatement.setDouble(3, point.lon);
            writeStatement.setDouble(4, point.lat);
            writeStatement.setDouble(5, point.altim);
            writeStatement.setLong(6, timestamp.getTime());
            writeStatement.executeUpdate();
        }
    }

    public static List<GpsLog> getLogsList(Connection connection) throws SQLException {
        ArrayList<GpsLog> logsList = new ArrayList<GpsLog>();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            String sql = "select " + TableDescriptions.GpsLogsTableFields.COLUMN_ID.getFieldName() + "," + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_STARTTS.getFieldName() + "," + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_ENDTS.getFieldName() + "," + TableDescriptions.GpsLogsTableFields.COLUMN_LOG_TEXT.getFieldName() + " from " + "gpslogs";
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                long id = rs.getLong(1);
                long startDateTimeString = rs.getLong(2);
                long endDateTimeString = rs.getLong(3);
                String text = rs.getString(4);
                GpsLog log = new GpsLog();
                log.id = id;
                log.startTime = startDateTimeString;
                log.endTime = endDateTimeString;
                log.text = text;
                logsList.add(log);
            }
        }
        return logsList;
    }

    public static void collectDataForLog(Connection connection, GpsLog log) throws SQLException {
        long logId = log.id;
        String query = "select " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LAT.getFieldName() + "," + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_LON.getFieldName() + "," + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_ALTIM.getFieldName() + "," + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_TS.getFieldName() + " from " + "gpslogsdata" + " where " + TableDescriptions.GpsLogsDataTableFields.COLUMN_LOGID.getFieldName() + " = " + logId + " order by " + TableDescriptions.GpsLogsDataTableFields.COLUMN_DATA_TS.getFieldName();
        try (Statement newStatement = connection.createStatement();){
            newStatement.setQueryTimeout(30);
            ResultSet result = newStatement.executeQuery(query);
            while (result.next()) {
                double lat = result.getDouble(1);
                double lon = result.getDouble(2);
                double altim = result.getDouble(3);
                long ts = result.getLong(4);
                GpsPoint gPoint = new GpsPoint();
                gPoint.lon = lon;
                gPoint.lat = lat;
                gPoint.altim = altim;
                gPoint.utctime = ts;
                log.points.add(gPoint);
            }
        }
    }

    public static class GpsLog {
        public long id;
        public long startTime;
        public long endTime;
        public String text;
        public List<GpsPoint> points = new ArrayList<GpsPoint>();
    }

    public static class GpsPoint {
        public double lat;
        public double lon;
        public double altim;
        public long utctime;
    }
}

