/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.forms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jgrasstools.gears.io.geopaparazzi.forms.Form;
import org.jgrasstools.gears.io.geopaparazzi.forms.MainFrame;
import org.jgrasstools.gears.io.geopaparazzi.forms.Section;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.Item;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.ItemBoolean;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.ItemCombo;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.ItemLabel;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.ItemText;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.ItemTextArea;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utilities {
    public static final String ATTR_SECTIONNAME = "sectionname";
    public static final String ATTR_SECTIONOBJECTSTR = "sectionobjectstr";
    public static final String ATTR_FORMS = "forms";
    public static final String ATTR_FORMNAME = "formname";
    public static final String TAG_LONGNAME = "longname";
    public static final String TAG_SHORTNAME = "shortname";
    public static final String TAG_FORMS = "forms";
    public static final String TAG_FORMITEMS = "formitems";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String TAG_VALUES = "values";
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEM = "item";
    public static final String TAG_TYPE = "type";
    public static final String TAG_READONLY = "readonly";
    public static final String TAG_SIZE = "size";
    public static final String TAG_URL = "url";

    public static void properties2Mainframe(MainFrame mainFrame, File templateFile) throws Exception {
        List<String> templateLinesList = FileUtilities.readFileToLinesList(templateFile);
        String name = FileUtilities.getNameWithoutExtention(templateFile);
        Section currentSection = new Section(name);
        mainFrame.addSection(currentSection);
        Form currentForm = null;
        for (int i = 0; i < templateLinesList.size(); ++i) {
            Item item;
            String value;
            String mandatory;
            String field;
            String line = templateLinesList.get(i).trim();
            if (line.length() == 0) continue;
            if (line.startsWith("#")) {
                String title = line.substring(1).trim();
                currentForm = new Form(title);
                currentSection.addForms(currentForm);
                continue;
            }
            String[] split = line.split("\\|");
            String type = split[0].trim();
            if (type.equals("text")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                item = new ItemText(field, value, Boolean.parseBoolean(mandatory), false);
                currentForm.addItem(item);
                continue;
            }
            if (type.startsWith("textarea")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                item = new ItemTextArea(field, value, Boolean.parseBoolean(mandatory), false);
                currentForm.addItem(item);
                continue;
            }
            if (type.startsWith("combo")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                String comboItems = type.replaceFirst("combo:", "");
                String[] itemsSplit = comboItems.split(",");
                for (int j = 0; j < itemsSplit.length; ++j) {
                    itemsSplit[j] = itemsSplit[j].trim();
                }
                ItemCombo combo = new ItemCombo(field, itemsSplit, value, Boolean.parseBoolean(mandatory));
                currentForm.addItem(combo);
                continue;
            }
            if (type.equals("checkbox")) {
                field = split[1].trim();
                mandatory = split[2].trim();
                value = "false";
                if (split.length == 4) {
                    value = split[3].trim();
                }
                ItemBoolean checkbox = new ItemBoolean(field, value, Boolean.parseBoolean(mandatory));
                currentForm.addItem(checkbox);
                continue;
            }
            if (!type.equals("label")) continue;
            String label = "";
            if (split.length > 1) {
                label = split[1].trim();
            }
            ItemLabel labelItem = new ItemLabel(label, 20, false);
            currentForm.addItem(labelItem);
        }
    }

    public static List<String> getFormNames4Section(JSONObject section) throws JSONException {
        ArrayList<String> names = new ArrayList<String>();
        JSONArray jsonArray = section.getJSONArray("forms");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(ATTR_FORMNAME)) continue;
                String formName = jsonObject.getString(ATTR_FORMNAME);
                names.add(formName);
            }
        }
        return names;
    }

    public static JSONObject getForm4Name(String formName, JSONObject section) throws JSONException {
        JSONArray jsonArray = section.getJSONArray("forms");
        if (jsonArray != null && jsonArray.length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String tmpFormName;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.has(ATTR_FORMNAME) || !(tmpFormName = jsonObject.getString(ATTR_FORMNAME)).equals(formName)) continue;
                return jsonObject;
            }
        }
        return null;
    }

    public static JSONArray getFormItems(JSONObject formObj) throws JSONException {
        if (formObj.has(TAG_FORMITEMS)) {
            JSONArray formItemsArray = formObj.getJSONArray(TAG_FORMITEMS);
            return formItemsArray;
        }
        return null;
    }
}

