/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jgrasstools.gears.io.geopaparazzi.forms.Utilities;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.DaoGpsLog;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.DaoImages;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.Image;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TimeUtilities;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsRuntimeException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.chart.Scatter;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Converts a geopaparazzi 4 project database into shapefiles.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="_geopapconvert_v4")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsGeopaparazzi4Converter
extends JGTModel {
    @Description(value="The geopaparazzi database file (*.gpap).")
    @UI(value="infile")
    @In
    public String inGeopaparazzi = null;
    @Description(value="Flag to create notes")
    @In
    public boolean doNotes = true;
    @Description(value="Flag to create log lines")
    @In
    public boolean doLoglines = true;
    @Description(value="Flag to create log points")
    @In
    public boolean doLogpoints = false;
    @Description(value="Flag to create media points")
    @In
    public boolean doMedia = true;
    @Description(value="The output folder")
    @UI(value="outfolder")
    @In
    public String outFolder = null;
    public static final String THE_GEOPAPARAZZI_DATABASE_FILE = "The geopaparazzi database file (*.gpap).";
    public static final String DESCRIPTION = "Converts a geopaparazzi 4 project database into shapefiles.";
    public static final String EMPTY_STRING = " - ";
    public static final String MEDIA_FOLDER_NAME = "media";
    public static final String CHARTS_FOLDER_NAME = "charts";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final String TAG_TYPE = "type";
    private static boolean hasDriver = false;
    private File chartsFolderFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeopaparazzi);
        if (!hasDriver) {
            throw new ModelsIllegalargumentException("Can't find any sqlite driver. Check your settings.", this, this.pm);
        }
        File geopapDatabaseFile = new File(this.inGeopaparazzi);
        if (!geopapDatabaseFile.exists()) {
            throw new ModelsIllegalargumentException("The geopaparazzi database file (*.gpap) is missing. Check the inserted path.", this, this.pm);
        }
        File outputFolderFile = new File(this.outFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        File mediaFolderFile = new File(outputFolderFile, MEDIA_FOLDER_NAME);
        mediaFolderFile.mkdir();
        this.chartsFolderFile = new File(outputFolderFile, CHARTS_FOLDER_NAME);
        this.chartsFolderFile.mkdir();
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + geopapDatabaseFile.getAbsolutePath());){
            this.projectInfo(connection, outputFolderFile);
            if (this.doNotes) {
                this.simpleNotesToShapefile(connection, outputFolderFile, this.pm);
                this.complexNotesToShapefile(connection, outputFolderFile, this.pm);
            }
            this.gpsLogToShapefiles(connection, outputFolderFile, this.pm);
            this.mediaToShapeFile(connection, mediaFolderFile, this.pm);
        }
    }

    private void projectInfo(Connection connection, File outputFolderFile) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("PROJECT INFO\n");
        sb.append("----------------------\n\n");
        LinkedHashMap<String, String> metadataMap = OmsGeopaparazzi4Converter.getMetadataMap(connection);
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        FileUtilities.writeFile(sb.toString(), new File(outputFolderFile, "project_info.txt"));
    }

    public static LinkedHashMap<String, String> getMetadataMap(Connection connection) throws SQLException {
        LinkedHashMap<String, String> metadataMap = new LinkedHashMap<String, String>();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            String sql = "select " + TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName() + ", " + TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName() + " from " + "metadata";
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String key = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName());
                String value = rs.getString(TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName());
                if (!key.endsWith("ts")) {
                    metadataMap.put(key, value);
                    continue;
                }
                try {
                    long ts = Long.parseLong(value);
                    String dateTimeString = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                    metadataMap.put(key, dateTimeString);
                }
                catch (Exception e) {
                    metadataMap.put(key, value);
                }
            }
        }
        return metadataMap;
    }

    private void simpleNotesToShapefile(Connection connection, File outputFolderFile, IJGTProgressMonitor pm) throws Exception {
        File outputShapeFile = new File(outputFolderFile, "notes_simple.shp");
        SimpleFeatureCollection newCollection = OmsGeopaparazzi4Converter.simpleNotes2featurecollection(connection, pm);
        this.dumpVector(newCollection, outputShapeFile.getAbsolutePath());
    }

    private void complexNotesToShapefile(Connection connection, File outputFolderFile, IJGTProgressMonitor pm) throws Exception {
        HashMap<String, SimpleFeatureCollection> name2CollectionMap = OmsGeopaparazzi4Converter.complexNotes2featurecollections(connection, pm);
        pm.beginTask("Writing layers to shapefile...", name2CollectionMap.size());
        Set<Map.Entry<String, SimpleFeatureCollection>> entrySet2 = name2CollectionMap.entrySet();
        for (Map.Entry<String, SimpleFeatureCollection> entry : entrySet2) {
            String name = entry.getKey();
            SimpleFeatureCollection collection = entry.getValue();
            File outFile = new File(outputFolderFile, "notes_" + name + ".shp");
            this.dumpVector(collection, outFile.getAbsolutePath());
            pm.worked(1);
        }
        pm.done();
    }

    public static List<String> getLayerNamesList(Connection connection) throws SQLException {
        ArrayList<String> layerNames = new ArrayList<String>();
        String sql = "select count(*) from notes";
        int count = OmsGeopaparazzi4Converter.countRows(connection, sql);
        if (count > 0) {
            layerNames.add("Simple Notes");
        }
        if ((count = OmsGeopaparazzi4Converter.countRows(connection, sql = "select count(*) from images")) > 0) {
            layerNames.add("Media Notes");
        }
        if ((count = OmsGeopaparazzi4Converter.countRows(connection, sql = "select count(*) from gpslogs")) > 0) {
            layerNames.add("GPS logs");
        }
        String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
        String textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
        sql = "select distinct " + textFN + " from " + "notes" + " where " + formFN + " is not null and " + formFN + "<>''";
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String formName = rs.getString(1);
                layerNames.add(formName);
            }
        }
        return layerNames;
    }

    private static int countRows(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                int notesCount;
                int n = notesCount = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public static SimpleFeatureCollection simpleNotes2featurecollection(Connection connection, IJGTProgressMonitor pm) throws SQLException {
        String textFN = TableDescriptions.NotesTableFields.COLUMN_TEXT.getFieldName();
        String descFN = TableDescriptions.NotesTableFields.COLUMN_DESCRIPTION.getFieldName();
        String tsFN = TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName();
        String altimFN = TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName();
        String dirtyFN = TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName();
        String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
        String latFN = TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName();
        String lonFN = TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName();
        GeometryFactory gf = GeometryUtilities.gf();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("gpsimplenotes");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", Point.class);
        b.add(textFN, String.class);
        b.add(descFN, String.class);
        b.add(tsFN, String.class);
        b.add(altimFN, Double.class);
        b.add(dirtyFN, Integer.class);
        String sql = "select " + latFN + "," + lonFN + "," + altimFN + "," + tsFN + "," + textFN + "," + descFN + "," + dirtyFN + "," + formFN + " from " + "notes";
        SimpleFeatureType featureType = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        pm.beginTask("Processing simple notes...", -1);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String form = rs.getString(formFN);
                if (form != null && form.trim().length() != 0) continue;
                double lat = rs.getDouble(latFN);
                double lon = rs.getDouble(lonFN);
                double altim = rs.getDouble(altimFN);
                long ts = rs.getLong(tsFN);
                String dateTimeString = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                String text = rs.getString(textFN);
                String descr = rs.getString(descFN);
                if (descr == null) {
                    descr = EMPTY_STRING;
                }
                int isDirty = rs.getInt(dirtyFN);
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = gf.createPoint(c);
                Object[] values = new Object[]{point, text, descr, dateTimeString, altim, isDirty};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
            }
        }
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, SimpleFeatureCollection> complexNotes2featurecollections(Connection connection, IJGTProgressMonitor pm) throws SQLException, Exception {
        pm.beginTask("Import complex notes...", -1);
        GeometryFactory gf = GeometryUtilities.gf();
        String tsFN = TableDescriptions.NotesTableFields.COLUMN_TS.getFieldName();
        String altimFN = TableDescriptions.NotesTableFields.COLUMN_ALTIM.getFieldName();
        String dirtyFN = TableDescriptions.NotesTableFields.COLUMN_ISDIRTY.getFieldName();
        String formFN = TableDescriptions.NotesTableFields.COLUMN_FORM.getFieldName();
        String latFN = TableDescriptions.NotesTableFields.COLUMN_LAT.getFieldName();
        String lonFN = TableDescriptions.NotesTableFields.COLUMN_LON.getFieldName();
        HashMap<String, BuilderAndCollectionPair> forms2PropertiesMap = new HashMap<String, BuilderAndCollectionPair>();
        HashMap<String, SimpleFeatureCollection> name2CollectionMap = new HashMap<String, SimpleFeatureCollection>();
        String sql = "select " + latFN + "," + lonFN + "," + altimFN + "," + tsFN + "," + dirtyFN + "," + formFN + " from " + "notes";
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                Object type;
                Object value;
                int i;
                String formString = rs.getString(formFN);
                if (formString == null || formString.trim().length() == 0) continue;
                double lat = rs.getDouble(latFN);
                double lon = rs.getDouble(lonFN);
                double altim = rs.getDouble(altimFN);
                long ts = rs.getLong(tsFN);
                String dateTimeString = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                int isDirty = rs.getInt(dirtyFN);
                if (lat == 0.0 || lon == 0.0) continue;
                Coordinate c = new Coordinate(lon, lat);
                Point point = gf.createPoint(c);
                JSONObject sectionObject = new JSONObject(formString);
                String sectionName = sectionObject.getString("sectionname");
                sectionName = sectionName.replaceAll("\\s+", "_");
                List<String> formNames4Section = Utilities.getFormNames4Section(sectionObject);
                LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> typesMap = new LinkedHashMap<String, String>();
                for (String formName : formNames4Section) {
                    JSONObject form4Name = Utilities.getForm4Name(formName, sectionObject);
                    JSONArray formItems = Utilities.getFormItems(form4Name);
                    int length = formItems.length();
                    for (i = 0; i < length; ++i) {
                        JSONObject jsonObject = formItems.getJSONObject(i);
                        if (!jsonObject.has(TAG_KEY)) continue;
                        String key = jsonObject.getString(TAG_KEY).trim();
                        value = null;
                        if (jsonObject.has(TAG_VALUE)) {
                            value = jsonObject.get(TAG_VALUE).toString().trim();
                        }
                        type = null;
                        if (jsonObject.has(TAG_TYPE)) {
                            type = jsonObject.getString(TAG_TYPE).trim();
                        }
                        if (value == null) continue;
                        valuesMap.put(key, (String)value);
                        typesMap.put(key, (String)type);
                    }
                }
                Set entrySet = valuesMap.entrySet();
                TreeMap<String, Integer> namesMap = new TreeMap<String, Integer>();
                BuilderAndCollectionPair builderAndCollectionPair = (BuilderAndCollectionPair)forms2PropertiesMap.get(sectionName);
                if (builderAndCollectionPair == null) {
                    SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
                    b.setName(sectionName);
                    b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    b.add("the_geom", Point.class);
                    b.add(tsFN, String.class);
                    b.add(altimFN, Double.class);
                    b.add(dirtyFN, Integer.class);
                    for (Map.Entry entry : entrySet) {
                        Integer nCount;
                        String key = (String)entry.getKey();
                        if ((key = key.replaceAll("\\s+", "_")).length() > 10) {
                            pm.errorMessage("Need to trim key: " + key);
                            key = key.substring(0, 10);
                        }
                        if ((nCount = (Integer)namesMap.get(key)) == null) {
                            nCount = 1;
                            namesMap.put(key, 1);
                        } else {
                            value = nCount;
                            nCount = nCount + 1;
                            type = nCount;
                            namesMap.put(key, nCount);
                            key = nCount < 10 ? key.substring(0, key.length() - 1) + nCount : key.substring(0, key.length() - 2) + nCount;
                        }
                        b.add(key, String.class);
                    }
                    SimpleFeatureType featureType = b.buildFeatureType();
                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                    DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
                    builderAndCollectionPair = new BuilderAndCollectionPair();
                    builderAndCollectionPair.builder = builder;
                    builderAndCollectionPair.collection = newCollection;
                    forms2PropertiesMap.put(sectionName, builderAndCollectionPair);
                }
                int size = entrySet.size();
                Object[] values = new Object[size + 4];
                values[0] = point;
                values[1] = dateTimeString;
                values[2] = altim;
                values[3] = isDirty;
                i = 4;
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    String value2 = (String)entry.getValue();
                    String type2 = (String)typesMap.get(key);
                    if (OmsGeopaparazzi4Converter.isMedia(type2)) {
                        String[] imageSplit = value2.split(";");
                        StringBuilder sb = new StringBuilder();
                        for (String image : imageSplit) {
                            if ((image = image.trim()).length() == 0) continue;
                            long imageId = Long.parseLong(image);
                            String imageName = DaoImages.getImageName(connection, imageId);
                            sb.append(";");
                            sb.append("media/").append(imageName);
                        }
                        value2 = sb.length() > 0 ? sb.substring(1) : "";
                    }
                    if (value2.length() > 253) {
                        pm.errorMessage("Need to trim value: " + value2);
                        value2 = value2.substring(0, 252);
                    }
                    values[i] = value2;
                    ++i;
                }
                builderAndCollectionPair.builder.addAll(values);
                SimpleFeature feature = builderAndCollectionPair.builder.buildFeature(null);
                builderAndCollectionPair.collection.add(feature);
            }
            Set entrySet = forms2PropertiesMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String name = (String)entry.getKey();
                DefaultFeatureCollection collection = ((BuilderAndCollectionPair)entry.getValue()).collection;
                name2CollectionMap.put(name, (SimpleFeatureCollection)collection);
            }
        }
        finally {
            pm.done();
        }
        return name2CollectionMap;
    }

    public static List<DaoGpsLog.GpsLog> getGpsLogsList(Connection connection) throws SQLException {
        List<DaoGpsLog.GpsLog> logsList = DaoGpsLog.getLogsList(connection);
        try {
            for (DaoGpsLog.GpsLog log : logsList) {
                DaoGpsLog.collectDataForLog(connection, log);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ModelsRuntimeException("An error occurred while reading the gps logs.", OmsGeopaparazzi4Converter.class.getSimpleName());
        }
        return logsList;
    }

    public static DefaultFeatureCollection getLogLinesFeatureCollection(IJGTProgressMonitor pm, List<DaoGpsLog.GpsLog> logsList) {
        GeometryFactory gf = GeometryUtilities.gf();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("geopaparazzilogs");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", MultiLineString.class);
        b.add("STARTDATE", String.class);
        b.add("ENDDATE", String.class);
        b.add("DESCR", String.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        pm.beginTask("Import gps to lines...", logsList.size());
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        for (DaoGpsLog.GpsLog log : logsList) {
            List<DaoGpsLog.GpsPoint> points = log.points;
            ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
            String startDate = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(log.startTime));
            String endDate = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(log.endTime));
            for (DaoGpsLog.GpsPoint gpsPoint : points) {
                Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                coordList.add(c);
            }
            Coordinate[] coordArray = coordList.toArray(new Coordinate[coordList.size()]);
            if (coordArray.length < 2) continue;
            LineString lineString = gf.createLineString(coordArray);
            MultiLineString multiLineString = gf.createMultiLineString(new LineString[]{lineString});
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            Object[] values = new Object[]{multiLineString, startDate, endDate, log.text};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
            pm.worked(1);
        }
        pm.done();
        return newCollection;
    }

    public static boolean isMedia(String type) {
        return type.equals("pictures") || type.equals("map") || type.equals("sketch");
    }

    public static void populateProfilesForSingleLog(DaoGpsLog.GpsLog log, int size, double[] xProfile, double[] yProfile, double[] xPlanim, double[] yPlanim, long[] timestampArray) {
        GeodeticCalculator gc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double runningDistance = 0.0;
        for (int i = 0; i < size - 1; ++i) {
            DaoGpsLog.GpsPoint p1 = log.points.get(i);
            DaoGpsLog.GpsPoint p2 = log.points.get(i + 1);
            double lon1 = p1.lon;
            double lat1 = p1.lat;
            double altim1 = p1.altim;
            long utc1 = p1.utctime;
            double lon2 = p2.lon;
            double lat2 = p2.lat;
            double altim2 = p2.altim;
            long utc2 = p2.utctime;
            gc.setStartingGeographicPoint(lon1, lat1);
            gc.setDestinationGeographicPoint(lon2, lat2);
            double distance = gc.getOrthodromicDistance();
            runningDistance += distance;
            if (i == 0) {
                xProfile[i] = 0.0;
                yProfile[i] = altim1;
                xPlanim[i] = lon1;
                yPlanim[i] = lat1;
                timestampArray[i] = utc1;
            }
            xProfile[i + 1] = runningDistance;
            yProfile[i + 1] = altim2;
            xPlanim[i + 1] = lon2;
            yPlanim[i + 1] = lat2;
            timestampArray[i + 1] = utc2;
        }
    }

    private void gpsLogToShapefiles(Connection connection, File outputFolderFile, IJGTProgressMonitor pm) throws Exception {
        DefaultFeatureCollection newCollection;
        List<DaoGpsLog.GpsLog> logsList = OmsGeopaparazzi4Converter.getGpsLogsList(connection);
        if (this.doLoglines) {
            newCollection = OmsGeopaparazzi4Converter.getLogLinesFeatureCollection(pm, logsList);
            File outputLinesShapeFile = new File(outputFolderFile, "gpslines.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputLinesShapeFile.getAbsolutePath());
        }
        if (this.doLogpoints) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzinotes");
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            b.add("ALTIMETRY", Double.class);
            b.add("DATE", String.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            pm.beginTask("Import gps to points...", logsList.size());
            newCollection = new DefaultFeatureCollection();
            int index = 0;
            for (DaoGpsLog.GpsLog log : logsList) {
                List<DaoGpsLog.GpsPoint> gpsPointList = log.points;
                for (DaoGpsLog.GpsPoint gpsPoint : gpsPointList) {
                    Coordinate c = new Coordinate(gpsPoint.lon, gpsPoint.lat);
                    Point point = this.gf.createPoint(c);
                    String ts = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(gpsPoint.utctime));
                    Object[] values = new Object[]{point, gpsPoint.altim, ts};
                    SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(featureType.getTypeName() + "." + index++);
                    newCollection.add(feature);
                }
                pm.worked(1);
            }
            pm.done();
            File outputPointsShapeFile = new File(outputFolderFile, "gpspoints.shp");
            this.dumpVector((SimpleFeatureCollection)newCollection, outputPointsShapeFile.getAbsolutePath());
        }
        if (this.doLoglines) {
            pm.beginTask("Create log charts...", logsList.size());
            for (DaoGpsLog.GpsLog log : logsList) {
                String logName = log.text;
                int size = log.points.size();
                pm.message("Processing log: " + logName + " with " + size + " points.");
                String fileName = FileUtilities.getSafeFileName(logName);
                File profileFile = new File(this.chartsFolderFile, fileName + "_profile.png");
                File planimetricFile = new File(this.chartsFolderFile, fileName + "_planimetric.png");
                File csvFile = new File(this.chartsFolderFile, fileName + ".csv");
                double[] xProfile = new double[size];
                double[] yProfile = new double[size];
                double[] xPlanim = new double[size];
                double[] yPlanim = new double[size];
                long[] timestampArray = new long[size];
                OmsGeopaparazzi4Converter.populateProfilesForSingleLog(log, size, xProfile, yProfile, xPlanim, yPlanim, timestampArray);
                Scatter scatterProfile = new Scatter("Profile " + logName);
                scatterProfile.addSeries("profile", xProfile, yProfile);
                scatterProfile.setShowLines(true);
                scatterProfile.setXLabel("progressive distance [m]");
                scatterProfile.setYLabel("elevation [m]");
                BufferedImage imageProfile = scatterProfile.getImage(1000, 800);
                ImageIO.write((RenderedImage)imageProfile, "png", profileFile);
                Scatter scatterPlanim = new Scatter("Planimetry " + logName);
                scatterPlanim.addSeries("planimetry", xPlanim, yPlanim);
                scatterPlanim.setShowLines(false);
                scatterPlanim.setXLabel("longitude");
                scatterPlanim.setYLabel("latitude");
                BufferedImage imagePlanim = scatterPlanim.getImage(1000, 800);
                ImageIO.write((RenderedImage)imagePlanim, "png", planimetricFile);
                StringBuilder csvBuilder = new StringBuilder();
                csvBuilder.append("#x,y,progressive,elevation,utctimestamp\n");
                for (int j = 0; j < timestampArray.length; ++j) {
                    String line = String.valueOf(xPlanim[j]).replace(',', '.');
                    line = line + "," + String.valueOf(yPlanim[j]).replace(',', '.');
                    line = line + "," + String.valueOf(xProfile[j]).replace(',', '.');
                    line = line + "," + String.valueOf(yProfile[j]).replace(',', '.');
                    line = line + "," + timestampArray[j] + "\n";
                    csvBuilder.append(line);
                }
                FileUtilities.writeFile(csvBuilder.toString(), csvFile);
                pm.worked(1);
            }
            pm.done();
        }
    }

    private void mediaToShapeFile(Connection connection, File mediaFolderFile, IJGTProgressMonitor pm) throws Exception {
        SimpleFeatureCollection newCollection = OmsGeopaparazzi4Converter.media2FeatureCollection(connection, mediaFolderFile, pm);
        File outputPointsShapeFile = new File(mediaFolderFile.getParentFile(), "mediapoints.shp");
        this.dumpVector(newCollection, outputPointsShapeFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureCollection media2FeatureCollection(Connection connection, File mediaFolderFile, IJGTProgressMonitor pm) throws Exception, IOException, FileNotFoundException {
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        try {
            GeometryFactory gf = GeometryUtilities.gf();
            newCollection = new DefaultFeatureCollection();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzimediapoints");
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            String altimFN = TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName();
            String tsFN = TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName();
            String azimFN = TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName();
            String imageNameFN = TableDescriptions.ImageTableFields.COLUMN_TEXT.getFieldName();
            b.add(altimFN, String.class);
            b.add(tsFN, String.class);
            b.add(azimFN, Double.class);
            b.add(imageNameFN, String.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            List<Image> imagesList = DaoImages.getImagesList(connection);
            pm.beginTask("Importing media...", imagesList.size());
            for (Image image : imagesList) {
                File newImageFile = new File(mediaFolderFile, image.getName());
                byte[] imageData = DaoImages.getImageData(connection, image.getImageDataId());
                try (FileOutputStream outStream = new FileOutputStream(newImageFile);){
                    ((OutputStream)outStream).write(imageData);
                }
                Point point = gf.createPoint(new Coordinate(image.getLon(), image.getLat()));
                long ts = image.getTs();
                String dateTimeString = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                String imageRelativePath = mediaFolderFile.getName() + "/" + image.getName();
                Object[] values = new Object[]{point, image.getAltim(), dateTimeString, image.getAzim(), imageRelativePath};
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureCollection media2IdBasedFeatureCollection(Connection connection, IJGTProgressMonitor pm) throws Exception, IOException, FileNotFoundException {
        try {
            GeometryFactory gf = GeometryUtilities.gf();
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("geopaparazzimediapoints");
            b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            b.add("the_geom", Point.class);
            String altimFN = TableDescriptions.ImageTableFields.COLUMN_ALTIM.getFieldName();
            String tsFN = TableDescriptions.ImageTableFields.COLUMN_TS.getFieldName();
            String azimFN = TableDescriptions.ImageTableFields.COLUMN_AZIM.getFieldName();
            b.add(altimFN, String.class);
            b.add(tsFN, String.class);
            b.add(azimFN, Double.class);
            b.add("imageid", Long.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            List<Image> imagesList = DaoImages.getImagesList(connection);
            pm.beginTask("Importing media...", imagesList.size());
            for (Image image : imagesList) {
                Point point = gf.createPoint(new Coordinate(image.getLon(), image.getLat()));
                long ts = image.getTs();
                String dateTimeString = TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(new Date(ts));
                Object[] values = new Object[]{point, image.getAltim(), dateTimeString, image.getAzim(), image.getImageDataId()};
                SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                pm.worked(1);
            }
            DefaultFeatureCollection defaultFeatureCollection = newCollection;
            return defaultFeatureCollection;
        }
        finally {
            pm.done();
        }
    }

    public static void writeImageFromId(Connection connection, long imageId, File newImageFile) throws Exception {
        byte[] imageData = DaoImages.getImageData(connection, imageId);
        try (FileOutputStream outStream = new FileOutputStream(newImageFile);){
            ((OutputStream)outStream).write(imageData);
        }
    }

    static {
        try {
            Class.forName("org.sqlite.JDBC");
            hasDriver = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class BuilderAndCollectionPair {
        SimpleFeatureBuilder builder;
        DefaultFeatureCollection collection;

        private BuilderAndCollectionPair() {
        }
    }
}

