/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfENTITY;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfFile;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.opengis.feature.simple.SimpleFeature;

public class DxfLWPOLYLINE
extends DxfENTITY {
    public DxfLWPOLYLINE() {
        super("DEFAULT");
    }

    public static DxfGroup readEntity(RandomAccessFile raf, DefaultFeatureCollection entities) throws IOException {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(DxfFile.DXF_LINESCHEMA);
        String layer = "";
        String ltype = "";
        Double elevation = new Double(0.0);
        Double thickness = new Double(0.0);
        Integer color = new Integer(256);
        String text = "";
        Double text_height = new Double(0.0);
        String text_style = "";
        String geomType = "LineString";
        CoordinateList coordList = new CoordinateList();
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        DxfGroup group = DxfFile.ENTITIES;
        while (group.getCode() != 0) {
            if (group.getCode() == 8) {
                layer = group.getValue();
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 6) {
                ltype = group.getValue();
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 38) {
                elevation = new Double(group.getDoubleValue());
                z = group.getDoubleValue();
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 39) {
                thickness = new Double(group.getDoubleValue());
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 62) {
                color = new Integer(group.getIntValue());
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 70) {
                if ((group.getIntValue() & 1) == 1) {
                    geomType = "Polygon";
                }
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 10) {
                x = group.getDoubleValue();
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 20) {
                y = group.getDoubleValue();
                coordList.add((Object)new Coordinate(x, y, z));
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.equals(SEQEND)) {
                group = DxfGroup.readGroup(raf);
                continue;
            }
            if (group.getCode() == 0) break;
            group = DxfGroup.readGroup(raf);
        }
        if (geomType.equals("LineString") || coordList.size() < 4) {
            LineString lineString = gF.createLineString(coordList.toCoordinateArray());
            Object[] values = new Object[]{lineString, layer, ltype, elevation, thickness, color, text, text_height, text_style};
            builder.addAll(values);
            StringBuilder featureId = new StringBuilder();
            featureId.append(DxfFile.DXF_LINESCHEMA.getTypeName());
            featureId.append(".");
            featureId.append(DxfFile.getNextFid());
            SimpleFeature feature = builder.buildFeature(featureId.toString());
            entities.add(feature);
        } else if (geomType.equals("Polygon")) {
            coordList.closeRing();
            Polygon polygon = gF.createPolygon(gF.createLinearRing(coordList.toCoordinateArray()), null);
            Object[] values = new Object[]{polygon, layer, ltype, elevation, thickness, color, text, text_height, text_style};
            builder.addAll(values);
            StringBuilder featureId = new StringBuilder();
            featureId.append(DxfFile.DXF_LINESCHEMA.getTypeName());
            featureId.append(".");
            featureId.append(DxfFile.getNextFid());
            SimpleFeature feature = builder.buildFeature(featureId.toString());
            entities.add(feature);
        } else {
            System.out.println("Can't handle geometry type: " + geomType);
        }
        return group;
    }
}

