/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dxf;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfBLOCKS;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfCLASSES;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfENTITIES;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfHEADER;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfTABLES;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DxfFile {
    public static final DxfGroup SECTION = new DxfGroup(0, "SECTION");
    public static final DxfGroup ENDSEC = new DxfGroup(0, "ENDSEC");
    public static final DxfGroup EOF = new DxfGroup(0, "EOF");
    public static final DxfGroup HEADER = new DxfGroup(2, "HEADER");
    public static final DxfGroup CLASSES = new DxfGroup(2, "CLASSES");
    public static final DxfGroup TABLES = new DxfGroup(2, "TABLES");
    public static final DxfGroup BLOCKS = new DxfGroup(2, "BLOCKS");
    public static final DxfGroup ENTITIES = new DxfGroup(2, "ENTITIES");
    public static final DxfGroup OBJECTS = new DxfGroup(2, "OBJECTS");
    public static SimpleFeatureType DXF_POINTSCHEMA = null;
    public static SimpleFeatureType DXF_LINESCHEMA = null;
    public static SimpleFeatureType DXF_POLYGONSCHEMA = null;
    public static boolean DXF_SCHEMA_INITIALIZED = false;
    static int iterator = 0;
    private DxfHEADER header = null;
    private DxfCLASSES classes = null;
    private DxfTABLES tables = null;
    private DxfBLOCKS blocks = null;
    private DxfENTITIES entities = null;
    private int coordinatePrecision = 2;
    Map featureSchemas = new HashMap();
    Map datasets = new HashMap();
    SimpleFeatureCollection pointFeatures;
    SimpleFeatureCollection lineFeatures;
    SimpleFeatureCollection polygonFeatures;
    private final CoordinateReferenceSystem crs;
    private static int fid = 0;

    public static synchronized int getNextFid() {
        return ++fid;
    }

    public static synchronized void resetFid() {
        fid = 0;
    }

    public DxfFile(CoordinateReferenceSystem crs) {
        this.crs = crs;
        DxfFile.resetFid();
        DxfFile.initializeDXF_SCHEMA(crs);
    }

    public static synchronized void initializeDXF_SCHEMA(CoordinateReferenceSystem crs) {
        if (DXF_POINTSCHEMA != null && DXF_POINTSCHEMA.getAttributeCount() != 0) {
            return;
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("dxfpointfile");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("LAYER", String.class);
        b.add("LTYPE", String.class);
        b.add("ELEVATION", Double.class);
        b.add("THICKNESS", Double.class);
        b.add("COLOR", Integer.class);
        b.add("TEXT", String.class);
        b.add("TEXT_HEIGHT", Double.class);
        b.add("TEXT_STYLE", String.class);
        DXF_POINTSCHEMA = b.buildFeatureType();
        b = new SimpleFeatureTypeBuilder();
        b.setName("dxflinefile");
        b.setCRS(crs);
        b.add("the_geom", LineString.class);
        b.add("LAYER", String.class);
        b.add("LTYPE", String.class);
        b.add("ELEVATION", Double.class);
        b.add("THICKNESS", Double.class);
        b.add("COLOR", Integer.class);
        b.add("TEXT", String.class);
        b.add("TEXT_HEIGHT", Double.class);
        b.add("TEXT_STYLE", String.class);
        DXF_LINESCHEMA = b.buildFeatureType();
        b = new SimpleFeatureTypeBuilder();
        b.setName("dxfpolygonfile");
        b.setCRS(crs);
        b.add("the_geom", Polygon.class);
        b.add("LAYER", String.class);
        b.add("LTYPE", String.class);
        b.add("ELEVATION", Double.class);
        b.add("THICKNESS", Double.class);
        b.add("COLOR", Integer.class);
        b.add("TEXT", String.class);
        b.add("TEXT_HEIGHT", Double.class);
        b.add("TEXT_STYLE", String.class);
        DXF_POLYGONSCHEMA = b.buildFeatureType();
    }

    public int getCoordinatePrecision() {
        return this.coordinatePrecision;
    }

    public void setCoordinatePrecision(int coordinatePrecision) {
        this.coordinatePrecision = coordinatePrecision;
    }

    public static DxfFile createFromFile(File file, CoordinateReferenceSystem crs) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        return DxfFile.createFromFile(raf, crs);
    }

    public static DxfFile createFromFile(RandomAccessFile raf, CoordinateReferenceSystem crs) throws IOException {
        DxfFile dxfFile = new DxfFile(crs);
        DxfFile.initializeDXF_SCHEMA(crs);
        dxfFile.pointFeatures = new DefaultFeatureCollection();
        dxfFile.lineFeatures = new DefaultFeatureCollection();
        dxfFile.polygonFeatures = new DefaultFeatureCollection();
        DxfGroup group = null;
        while (null != (group = DxfGroup.readGroup(raf))) {
            if (group.equals(SECTION)) {
                group = DxfGroup.readGroup(raf);
                System.out.println("SECTION " + group.getValue());
                if (group.equals(HEADER)) {
                    dxfFile.header = DxfHEADER.readHeader(raf);
                    continue;
                }
                if (group.equals(CLASSES)) {
                    dxfFile.classes = DxfCLASSES.readClasses(raf);
                    continue;
                }
                if (group.equals(TABLES)) {
                    dxfFile.tables = DxfTABLES.readTables(raf);
                    continue;
                }
                if (group.equals(BLOCKS)) {
                    dxfFile.blocks = DxfBLOCKS.readEntities(raf);
                    ((DefaultFeatureCollection)dxfFile.pointFeatures).addAll((FeatureCollection)dxfFile.blocks.pointEntities);
                    ((DefaultFeatureCollection)dxfFile.lineFeatures).addAll((FeatureCollection)dxfFile.blocks.lineEntities);
                    ((DefaultFeatureCollection)dxfFile.polygonFeatures).addAll((FeatureCollection)dxfFile.blocks.polygonEntities);
                    continue;
                }
                if (group.equals(ENTITIES)) {
                    dxfFile.entities = DxfENTITIES.readEntities(raf);
                    ((DefaultFeatureCollection)dxfFile.pointFeatures).addAll((FeatureCollection)dxfFile.entities.pointEntities);
                    ((DefaultFeatureCollection)dxfFile.lineFeatures).addAll((FeatureCollection)dxfFile.entities.lineEntities);
                    ((DefaultFeatureCollection)dxfFile.polygonFeatures).addAll((FeatureCollection)dxfFile.entities.polygonEntities);
                    continue;
                }
                if (group.equals(OBJECTS)) {
                    System.out.println("Jump objects: " + group.getValue());
                    continue;
                }
                if (group.getCode() == 999) {
                    System.out.println("Jump 999: " + group.getValue());
                    continue;
                }
                System.out.println("Group " + group.getCode() + " " + group.getValue() + " UNKNOWN");
                continue;
            }
            if (group.getCode() == 999 || !group.equals(EOF)) continue;
        }
        raf.close();
        return dxfFile;
    }

    public SimpleFeatureCollection getPoints() {
        return this.pointFeatures;
    }

    public SimpleFeatureCollection getLines() {
        return this.lineFeatures;
    }

    public SimpleFeatureCollection getPolygons() {
        return this.polygonFeatures;
    }

    public static Set getLayers(File file) throws IOException {
        HashSet<String> datasets = new HashSet<String>();
        datasets.add("BLOCKS");
        datasets.add("ENTITIES");
        return datasets;
    }
}

