/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dwg.utils;

import java.math.BigInteger;
import java.util.Arrays;

public class ByteUtils {
    public static final int SIZE_BOOL = 1;
    public static final int SIZE_SHORT = 2;
    public static final int SIZE_INT = 4;
    public static final int SIZE_LONG = 8;
    public static final int SIZE_DOUBLE = 8;
    public static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final int bytesToInt(byte[] data, int[] offset) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            int n = offset[0];
            offset[0] = n + 1;
            result |= ByteUtils.byteToUnsignedInt(data[n]);
        }
        return result;
    }

    public static final void intToBytes(int i, byte[] data, int[] offset) {
        if (data != null) {
            for (int j = offset[0] + 4 - 1; j >= offset[0]; --j) {
                data[j] = (byte)i;
                i >>= 8;
            }
        }
        offset[0] = offset[0] + 4;
    }

    public static final short bytesToShort(byte[] data, int[] offset) {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            int n = offset[0];
            offset[0] = n + 1;
            result = (short)(result | (short)ByteUtils.byteToUnsignedInt(data[n]));
        }
        return result;
    }

    public static final void shortToBytes(short s, byte[] data, int[] offset) {
        if (data != null) {
            data[offset[0] + 1] = (byte)s;
            data[offset[0]] = (byte)(s >> 8);
        }
        offset[0] = offset[0] + 2;
    }

    public static final long bytesToLong(byte[] data, int[] offset) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            int n = offset[0];
            offset[0] = n + 1;
            int res = ByteUtils.byteToUnsignedInt(data[n]);
            result |= (long)res;
        }
        return result;
    }

    public static final void longToBytes(long l, byte[] data, int[] offset) {
        if (data != null) {
            for (int j = offset[0] + 8 - 1; j >= offset[0]; --j) {
                data[j] = (byte)l;
                l >>= 8;
            }
        }
        offset[0] = offset[0] + 8;
    }

    public static final double bytesToDouble(byte[] data, int[] offset) {
        long bits = ByteUtils.bytesToLong(data, offset);
        return Double.longBitsToDouble(bits);
    }

    public static final void doubleToBytes(double d, byte[] data, int[] offset) {
        long bits = Double.doubleToLongBits(d);
        ByteUtils.longToBytes(bits, data, offset);
    }

    public static final String bytesToString(byte[] data, int[] offset) {
        offset[0] = 0;
        int length = ByteUtils.bytesToInt(data, offset);
        String st = null;
        st = length < 0 || length > data.length ? new String(data) : new String(data, offset[0], length);
        offset[0] = offset[0] + length;
        return st;
    }

    public static final void stringToBytes(String s, byte[] data, int[] offset) {
        byte[] s_bytes = s.getBytes();
        if (data != null) {
            ByteUtils.intToBytes(s_bytes.length, data, offset);
            ByteUtils.memcpy(data, offset[0], s_bytes, 0, s_bytes.length);
        } else {
            offset[0] = offset[0] + 4;
        }
        offset[0] = offset[0] + s_bytes.length;
    }

    public static final boolean bytesToBool(byte[] data, int[] offset) {
        boolean result = true;
        if (data[offset[0]] == 0) {
            result = false;
        }
        offset[0] = offset[0] + 1;
        return result;
    }

    public static final void boolToBytes(boolean b, byte[] data, int[] offset) {
        if (data != null) {
            data[offset[0]] = (byte)(b ? 1 : 0);
        }
        offset[0] = offset[0] + 1;
    }

    public static final BigInteger bytesToBigInteger(byte[] data, int[] offset) {
        int length = ByteUtils.bytesToInt(data, offset);
        byte[] bytes = new byte[length];
        offset[0] = offset[0] + ByteUtils.memcpy(bytes, 0, data, offset[0], length);
        return new BigInteger(bytes);
    }

    public static final void bigIntegerToBytes(BigInteger n, byte[] data, int[] offset) {
        byte[] bytes = n.toByteArray();
        ByteUtils.intToBytes(bytes.length, data, offset);
        offset[0] = offset[0] + ByteUtils.memcpy(data, offset[0], bytes, 0, bytes.length);
    }

    public static final void bytesToInts(int[] dst, int dst_offset, byte[] src, int src_offset, int length) {
        if (src == null || dst == null || src_offset + length > src.length || dst_offset + length > dst.length * 4 || dst_offset % 4 != 0 || length % 4 != 0) {
            ByteUtils.croak("bytesToInts parameters are invalid src==" + Arrays.toString(src) + " dst==" + Arrays.toString(dst) + (src == null || dst == null ? " " : " (src_offset+length)>src.length==" + (src_offset + length) + ">" + src.length + " (dst_offset+length)>(dst.length*4)==" + (dst_offset + length) + ">" + dst.length * 4 + " (dst_offset%4)==" + dst_offset % 4 + " (length%4)==" + length % 4 + " dest.length==" + dst.length + " length==" + length));
        }
        int[] offset = new int[]{src_offset};
        int int_dst_offset = dst_offset / 4;
        for (int i = 0; i < length / 4; ++i) {
            dst[int_dst_offset++] = ByteUtils.bytesToInt(src, offset);
        }
    }

    public static final void intsToBytes(byte[] dst, int dst_offset, int[] src, int src_offset, int length) {
        if (src == null || dst == null || dst_offset + length > dst.length || src_offset + length > src.length * 4 || src_offset % 4 != 0 || length % 4 != 0) {
            ByteUtils.croak("intsToBytes parameters are invalid: src=" + Arrays.toString(src) + " dst=" + Arrays.toString(dst) + " (dst_offset=" + dst_offset + " + length=" + length + ")=" + (dst_offset + length) + " > dst.length=" + (dst == null ? 0 : dst.length) + " (src_offset=" + src_offset + " + length=" + length + ")=" + (src_offset + length) + " > (src.length=" + (src == null ? 0 : src.length) + "*4)=" + (src == null ? 0 : src.length * 4) + " (src_offset=" + src_offset + " % 4)=" + src_offset % 4 + " != 0" + " (length=" + length + " % 4)=" + length % 4 + " != 0");
        }
        int[] offset = new int[]{dst_offset};
        int int_src_offset = src_offset / 4;
        for (int i = 0; i < length / 4; ++i) {
            ByteUtils.intToBytes(src[int_src_offset++], dst, offset);
        }
    }

    public static final int byteToUnsignedInt(byte b) {
        return b & 0xFF;
    }

    public static int memcpy(byte[] dst, int dst_offset, byte[] src, int src_offset, int length) {
        if (dst != null && src != null) {
            if (dst.length < dst_offset + length) {
                ByteUtils.croak("dst.length = " + dst.length + ", but " + "dst_offset = " + dst_offset + " and length = " + length + ".");
            }
            if (src.length < src_offset + length) {
                ByteUtils.croak("src.length = " + src.length + ", but " + "src_offset = " + src_offset + " and length = " + length + ".");
            }
            int i = 0;
            while (i < length) {
                dst[dst_offset] = src[src_offset];
                ++i;
                ++dst_offset;
                ++src_offset;
            }
        }
        return length;
    }

    public static boolean memcmp(byte[] a, int a_offset, byte[] b, int b_offset, int length) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[a_offset] != b[b_offset]) {
                return false;
            }
            ++i;
            ++a_offset;
            ++b_offset;
        }
        return true;
    }

    public static void memclr(byte[] array, int offset, int length) {
        int i = 0;
        while (i < length) {
            array[offset] = 0;
            ++i;
            ++offset;
        }
    }

    public static int round_up(int value, int multiple) {
        return ((value - 1) / multiple + 1) * multiple;
    }

    public static byte[] zero_pad(byte[] original, int block_size) {
        if (original.length % block_size == 0) {
            return original;
        }
        byte[] result = new byte[ByteUtils.round_up(original.length, block_size)];
        ByteUtils.memcpy(result, 0, original, 0, original.length);
        return result;
    }

    public static boolean equals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static String print_bytes(byte[] data, int offset, int length) {
        int size = 2 * length;
        size += size / 8 + size / 64;
        char[] buf = new char[size];
        int low_mask = 15;
        int high_mask = 240;
        int buf_pos = 0;
        int j = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte b = data[i];
            buf[buf_pos++] = digits[(high_mask & b) >> 4];
            buf[buf_pos++] = digits[low_mask & b];
            if (j % 4 == 3) {
                buf[buf_pos++] = 32;
            }
            if (j % 32 == 31) {
                buf[buf_pos++] = 10;
            }
            ++j;
        }
        return new String(buf);
    }

    public static String print_bytes_exact(byte[] data, int offset, int length) {
        int size = 2 * length;
        char[] buf = new char[size];
        int low_mask = 15;
        int high_mask = 240;
        int buf_pos = 0;
        int j = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte b = data[i];
            buf[buf_pos++] = digits[(high_mask & b) >> 4];
            buf[buf_pos++] = digits[low_mask & b];
            ++j;
        }
        return new String(buf);
    }

    public static String print_bytes(byte[] data) {
        return ByteUtils.print_bytes(data, 0, data.length);
    }

    private static void croak(String msg) {
    }

    public static int getUnsigned(byte b) {
        return b & 0xFF;
    }
}

