/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.geotools;

import java.awt.RenderingHints;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.jgrasstools.gears.JGrassGears;
import org.jgrasstools.gears.libs.modules.ClassField;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class GearsProcessFactory
implements ProcessFactory {
    private static final String VERSION_STRING = "0.1-SNAPSHOT";
    private static final String namespace = "org.jgrasstools.gears";
    private LinkedHashMap<String, Class<?>> modulename2class;

    public Process create(Name name) {
        String moduleName = name.getLocalPart();
        Class<?> moduleClass = this.modulename2class.get(moduleName);
        try {
            Object processObj = moduleClass.newInstance();
            if (processObj instanceof Process) {
                Process process = (Process)processObj;
                return process;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InternationalString getDescription(Name name) {
        return null;
    }

    public Set<Name> getNames() {
        LinkedHashSet<Name> names = new LinkedHashSet<Name>();
        this.modulename2class = JGrassGears.getInstance().moduleName2Class;
        Set<String> modulesNames = this.modulename2class.keySet();
        for (String name : modulesNames) {
            names.add((Name)new NameImpl(namespace, name));
        }
        return names;
    }

    public Map<String, Parameter<?>> getParameterInfo(Name name) {
        String moduleName = name.getLocalPart();
        LinkedHashMap<String, List<ClassField>> modulename2fields = JGrassGears.getInstance().moduleName2Fields;
        List<ClassField> list = modulename2fields.get(moduleName);
        LinkedHashMap input = new LinkedHashMap();
        for (ClassField classField : list) {
            if (!classField.isIn) continue;
            String fieldName = classField.fieldName;
            String fieldDescription = classField.fieldDescription;
            Parameter param = new Parameter(fieldName, classField.fieldClass, fieldName, fieldDescription);
            input.put(param.key, param);
        }
        return input;
    }

    public Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) throws IllegalArgumentException {
        String moduleName = name.getLocalPart();
        LinkedHashMap<String, List<ClassField>> modulename2fields = JGrassGears.getInstance().moduleName2Fields;
        List<ClassField> list = modulename2fields.get(moduleName);
        LinkedHashMap output = new LinkedHashMap();
        for (ClassField classField : list) {
            if (!classField.isOut) continue;
            String fieldName = classField.fieldName;
            String fieldDescription = classField.fieldDescription;
            Parameter param = new Parameter(fieldName, classField.fieldClass, fieldName, fieldDescription);
            output.put(param.key, param);
        }
        return output;
    }

    public InternationalString getTitle() {
        return null;
    }

    public InternationalString getTitle(Name name) {
        return null;
    }

    public String getVersion(Name name) {
        return VERSION_STRING;
    }

    public boolean supportsProgress(Name name) {
        return true;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }
}

