/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.LabelUI;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.PainterIcon;
import org.jdesktop.swingx.plaf.BusyLabelAddon;
import org.jdesktop.swingx.plaf.BusyLabelUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXBusyLabel
extends JLabel {
    private static final long serialVersionUID = 5979268460848257147L;
    private BusyPainter busyPainter;
    private Timer busy;
    private int delay;
    private boolean wasBusyOnNotify = false;
    public static final String uiClassID = "BusyLabelUI";
    private Direction direction;

    public void setDirection(Direction dir) {
        this.direction = dir;
        this.busyPainter.setDirection(dir);
    }

    public JXBusyLabel() {
        this((Dimension)null);
    }

    public JXBusyLabel(Dimension dim) {
        this.createBusyPainter(dim);
    }

    protected void initPainter(Dimension dim) {
        PainterIcon icon = new PainterIcon(dim);
        icon.setPainter(this.busyPainter);
        this.setPreferredSize(dim);
        this.setIcon(icon);
    }

    protected void createBusyPainter(Dimension dim) {
        BusyLabelUI ui;
        BusyLabelUI busyLabelUI = ui = this.getUI() == null ? null : (BusyLabelUI)((Object)this.getUI());
        if (ui != null) {
            this.busyPainter = ui.getBusyPainter(dim);
            this.delay = ui.getDelay();
        }
        if (this.busyPainter != null) {
            if (dim == null) {
                Rectangle rt = this.busyPainter.getTrajectory().getBounds();
                Rectangle rp = this.busyPainter.getPointShape().getBounds();
                int max = Math.max(rp.width, rp.height);
                dim = new Dimension(rt.width + max, rt.height + max);
            }
            this.initPainter(dim);
        }
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean busy) {
        boolean old = this.isBusy();
        if (!old && busy) {
            this.startAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        } else if (old && !busy) {
            this.stopAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        }
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(this.delay, new ActionListener(){
            int frame;
            {
                this.frame = JXBusyLabel.this.busyPainter.getPoints();
            }

            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % JXBusyLabel.this.busyPainter.getPoints();
                JXBusyLabel.this.busyPainter.setFrame(JXBusyLabel.this.direction == Direction.LEFT ? JXBusyLabel.this.busyPainter.getPoints() - this.frame : this.frame);
                JXBusyLabel.this.frameChanged();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.busyPainter.setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    public void removeNotify() {
        this.wasBusyOnNotify = this.isBusy();
        this.stopAnimation();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        if (this.wasBusyOnNotify) {
            this.startAnimation();
        }
    }

    protected void frameChanged() {
        this.repaint();
    }

    public final BusyPainter getBusyPainter() {
        return this.busyPainter;
    }

    public final void setBusyPainter(BusyPainter busyPainter) {
        this.busyPainter = busyPainter;
        this.initPainter(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        int old = this.getDelay();
        this.delay = delay;
        if (old != this.getDelay()) {
            if (this.busy != null && this.busy.isRunning()) {
                this.busy.setDelay(this.getDelay());
            }
            this.firePropertyChange("delay", old, this.getDelay());
        }
    }

    public void updateUI() {
        this.setUI((LabelUI)LookAndFeelAddons.getUI(this, BusyLabelUI.class));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    static {
        LookAndFeelAddons.contribute(new BusyLabelAddon());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

