/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.logger.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private int size = 100;
    private List entries = Collections.synchronizedList(new ArrayList(100));

    public MemoryHandler() {
    }

    public MemoryHandler(int size) {
        this.size = size;
    }

    public void close() {
        this.flush();
    }

    public void flush() {
        this.entries.clear();
    }

    public Formatter getFormatter() {
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void publish(LogRecord logRecord) {
        this.entries.add(logRecord);
        if (this.entries.size() > this.size) {
            this.entries.subList(0, this.entries.size() - this.size).clear();
        }
    }

    public synchronized void push(Handler target) {
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            LogRecord record = (LogRecord)i.next();
            target.publish(record);
        }
        this.flush();
    }

    public void setFormatter(Formatter arg0) {
        throw new IllegalArgumentException("Cannot set a " + arg0 + " on this handler");
    }

    public void setSize(int size) {
        this.size = size;
    }
}

