/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.logger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import nl.tudelft.simulation.event.util.EventProducingMap;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.logger.gui.LoggerFrame;

public class LoggerSelectFrame
extends JFrame
implements EventListenerInterface {
    private JComboBox loggerChooser;
    private JButton openButton = new JButton("Open");

    public LoggerSelectFrame() {
        super("Logger selection Frame");
        this.initialize();
    }

    private void initialize() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.loggerChooser = new JComboBox<String>(Logger.getLoggerNames());
        contentPane.setPreferredSize(new Dimension(300, (int)this.loggerChooser.getPreferredSize().getHeight()));
        Logger.LOGGERS.addListener(this, EventProducingMap.OBJECT_ADDED_EVENT);
        Logger.LOGGERS.addListener(this, EventProducingMap.OBJECT_REMOVED_EVENT);
        this.openButton.addActionListener(new MyActionListener(this.loggerChooser));
        contentPane.add((Component)this.loggerChooser, "Center");
        contentPane.add((Component)this.openButton, "East");
        this.setContentPane(contentPane);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public synchronized void notify(EventInterface event) {
        if (event.getType().equals(EventProducingMap.OBJECT_ADDED_EVENT) || event.getType().equals(EventProducingMap.OBJECT_REMOVED_EVENT)) {
            String[] names = Logger.getLoggerNames();
            this.loggerChooser.removeAllItems();
            for (int i = 0; i < names.length; ++i) {
                this.loggerChooser.addItem(names[i]);
            }
            this.repaint();
        }
    }

    private class MyActionListener
    implements ActionListener {
        private JComboBox loggerChooser = null;

        public MyActionListener(JComboBox loggerChooser) {
            this.loggerChooser = loggerChooser;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.loggerChooser.getSelectedItem() != null) {
                String logger = (String)this.loggerChooser.getSelectedItem();
                new LoggerFrame(java.util.logging.Logger.getLogger(logger));
            } else {
                Logger.warning((Object)this, "actionPerformed", actionEvent.getActionCommand() + " on empty logger");
            }
        }
    }
}

