/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.logger.formatters;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class StyledTextFormatter
extends Formatter {
    public static final String STYLE_DEFAULT = "STYLE_DEFAULT";
    public static final String STYLE_SOURCE = "STYLE_SOURCE";
    public static final String STYLE_WARNING = "STYLE_WARNING";
    public static final String STYLE_FINE = "STYLE_FINE";
    public static final String STYLE_ORIGIN = "STYLE_ORIGIN";
    public static final String SEPARATOR = "!!@@!!";
    private boolean showOrigin = true;
    private Date date = new Date();
    private DateFormat dateFormatter = DateFormat.getTimeInstance();

    public StyledTextFormatter(boolean showOrigin) {
        this.showOrigin = showOrigin;
    }

    private String tag(String tag, String message) {
        return "<" + tag + ">" + message + "</" + tag + ">" + SEPARATOR;
    }

    public String format(LogRecord record) {
        StringBuffer message = new StringBuffer();
        try {
            int sepIndex;
            Level level = record.getLevel();
            this.date.setTime(record.getMillis());
            String levelLabel = this.dateFormatter.format(this.date) + " " + level.getName() + ": ";
            if (level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
                message.append(this.tag(STYLE_WARNING, levelLabel));
            } else if (!level.equals(Level.INFO)) {
                message.append(this.tag(STYLE_FINE, levelLabel));
            }
            String body = record.getMessage();
            if (body == null) {
                body = "null";
            }
            if ((sepIndex = body.indexOf(58)) != -1) {
                String source = body.substring(0, body.indexOf(58));
                message.append(this.tag(STYLE_SOURCE, source + " "));
                body = body.substring(body.indexOf(58));
            }
            message.append(this.tag(STYLE_DEFAULT, body + "\n"));
            if (this.showOrigin) {
                String sourceName = record.getLoggerName();
                if (record.getSourceClassName() != null) {
                    sourceName = record.getSourceClassName();
                }
                String methodName = "unknown";
                if (record.getSourceMethodName() != null) {
                    methodName = record.getSourceMethodName();
                }
                String originLog = "Origin: " + sourceName + "#" + methodName + "\n";
                message.append(this.tag(STYLE_ORIGIN, originLog));
                if (record.getThrown() != null) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        record.getThrown().printStackTrace(printWriter);
                        printWriter.close();
                        message.append(this.tag(STYLE_ORIGIN, stringWriter.toString()));
                    }
                    catch (Exception exception2) {
                        Object exception2 = null;
                    }
                }
            }
            message.append(this.tag(STYLE_DEFAULT, "\n"));
        }
        catch (Throwable exception) {
            System.out.println("Logger formatter exception " + record);
        }
        return message.toString();
    }
}

