/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.InternalTranscoder;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;

public class SVGGraphicFactory
implements ExternalGraphicFactory {
    Map<URL, Document> glyphCache = new SoftValueHashMap();
    static final Set<String> formats = new HashSet<String>(){
        {
            this.add("image/svg");
            this.add("image/svg-xml");
            this.add("image/svg+xml");
        }
    };

    public Icon getIcon(Feature feature, Expression url, String format, int size) throws Exception {
        if (format == null || !formats.contains(format.toLowerCase())) {
            return null;
        }
        URL svgfile = (URL)url.evaluate((Object)feature, URL.class);
        if (svgfile == null) {
            throw new IllegalArgumentException("The specified expression could not be turned into an URL");
        }
        InternalTranscoder svgTranscoder = new InternalTranscoder();
        TranscoderInput in = this.glyphCache.containsKey(svgfile) ? new TranscoderInput(this.glyphCache.get(svgfile)) : new TranscoderInput(svgfile.openStream());
        if (size > 0) {
            svgTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(size));
        }
        TranscoderOutput out = new TranscoderOutput();
        svgTranscoder.transcode(in, out);
        this.glyphCache.put(svgfile, svgTranscoder.getDocument());
        return new ImageIcon(svgTranscoder.getImage());
    }
}

