/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Dates {
    public static final int SOLAR_YEAR = 1;
    public static final int WATER_YEAR = 2;
    public static final int CALENDAR_YEAR = 3;
    private static final long SERIAL_BASE_1900 = -2209050000000L;
    public static final long MILLISECS_PER_MINUTE = 60000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    public static final long EPOCH_UNIX_ERA_DAY = 2440588L;
    private static SimpleDateFormat YYYYMMdd = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat MMdd = new SimpleDateFormat("MM-dd");
    private static SimpleDateFormat dd = new SimpleDateFormat("dd");

    private Dates() {
    }

    public static long getUnixDay(Calendar cal) {
        long offset = cal.get(15) + cal.get(16);
        long day = (long)Math.floor((double)(cal.getTime().getTime() + offset) / 8.64E7);
        return day;
    }

    public static long getJulianDay(Calendar cal) {
        return Dates.getUnixDay(cal) + 2440588L;
    }

    public static long diffDayPeriods(Calendar start, Calendar end) {
        long endL = end.getTimeInMillis() + (long)end.getTimeZone().getOffset(end.getTimeInMillis());
        long startL = start.getTimeInMillis() + (long)start.getTimeZone().getOffset(start.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }

    public static boolean isLeapYear(int year) {
        return year >= 1582 ? year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) : year % 4 == 0;
    }

    public static int getDayOfYear(Calendar cal, int type) {
        int jday = cal.get(6);
        int mo = cal.get(2) + 1;
        if (type == 3) {
            return jday;
        }
        if (type == 1) {
            int day = cal.get(5);
            return mo == 12 && day > 21 ? day - 21 : jday + 10;
        }
        if (type == 2) {
            return mo > 9 ? jday - (Dates.isLeapYear(cal.get(1)) ? 274 : 273) : jday + 92;
        }
        throw new IllegalArgumentException("getDayOfYear() type argument unknown");
    }

    public static double toSerialDate(Calendar cal) {
        long calTime = cal.getTimeInMillis();
        return (double)(calTime - -2209050000000L) / 8.64E7 + 1.0;
    }

    public static void setSerialDate(Calendar cal, double serialDate) {
        cal.setTimeInMillis(-2209050000000L + (long)((serialDate - 1.0) * 8.64E7));
    }

    public static double deltaHours(int calUnit, int increments) {
        if (calUnit == 5) {
            return 24 * increments;
        }
        if (calUnit == 10) {
            return increments;
        }
        if (calUnit == 12) {
            return increments / 60;
        }
        if (calUnit == 13) {
            return increments / 3600;
        }
        return -1.0;
    }

    private static int checkYear(String year) throws Exception {
        if (year == null || year.isEmpty()) {
            throw new Exception();
        }
        int y = Integer.parseInt(year);
        if (y < 1900 || y > 2100) {
            throw new Exception();
        }
        return y;
    }

    private static void checkMonth(String month) throws Exception {
        if (month == null || month.isEmpty()) {
            throw new Exception();
        }
        int m = Integer.parseInt(month);
        if (m < 1 || m > 12) {
            throw new Exception();
        }
    }

    private static void checkDay(String day) throws Exception {
        if (day == null || day.isEmpty()) {
            throw new Exception();
        }
        int d = Integer.parseInt(day);
        if (d < 1 || d > 31) {
            throw new Exception();
        }
    }

    private static Date parse(Calendar base, String date) throws Exception {
        Date parse = null;
        try {
            parse = YYYYMMdd.parse(date);
            String[] p = date.split("-");
            Dates.checkYear(p[0]);
            Dates.checkMonth(p[1]);
            Dates.checkDay(p[2]);
        }
        catch (ParseException ex) {
            try {
                MMdd.parse(date);
                String[] p = date.split("-");
                Dates.checkMonth(p[0]);
                Dates.checkDay(p[1]);
                parse = YYYYMMdd.parse(base.get(1) + "-" + date);
            }
            catch (ParseException ex1) {
                try {
                    dd.parse(date);
                    Dates.checkDay(date);
                    parse = YYYYMMdd.parse(base.get(1) + "-" + base.get(2) + 1 + "-" + date);
                }
                catch (ParseException ex2) {
                    throw new Exception();
                }
            }
        }
        return parse;
    }

    public static synchronized Date[] parseESPDates(String espdate) {
        try {
            String[] parts = espdate.split("\\s*/\\s*");
            if (parts.length != 3) {
                throw new Exception();
            }
            Date[] date = new Date[3];
            String[] p = parts[0].split("-");
            date[0] = YYYYMMdd.parse(parts[0]);
            Dates.checkYear(p[0]);
            Dates.checkMonth(p[1]);
            Dates.checkDay(p[2]);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date[0]);
            date[1] = Dates.parse(cal, parts[1]);
            cal.setTime(date[1]);
            date[2] = Dates.parse(cal, parts[2]);
            if (!date[1].after(date[0]) || !date[2].after(date[1])) {
                throw new Exception();
            }
            return date;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid range '" + espdate + "'");
        }
    }

    public static synchronized Date[] parseDuration(String duration) {
        try {
            String[] parts = duration.split("\\s*/\\s*");
            if (parts.length != 2) {
                throw new Exception();
            }
            Date[] date = new Date[2];
            String[] p = parts[0].split("-");
            date[0] = YYYYMMdd.parse(parts[0]);
            Dates.checkYear(p[0]);
            Dates.checkMonth(p[1]);
            Dates.checkDay(p[2]);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date[0]);
            date[1] = Dates.parse(cal, parts[1]);
            if (!date[1].after(date[0])) {
                throw new Exception();
            }
            return date;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid range '" + duration + "'");
        }
    }

    public static String[] splitDuration(String duration) {
        String[] parts = duration.split("\\s*/\\s*");
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException("duration " + duration);
        }
        return new String[]{parts[0], parts[1]};
    }

    public static String durationStart(String duration) {
        String[] d = Dates.splitDuration(duration);
        return d[0];
    }

    public static String durationEnd(String duration) {
        String[] d = Dates.splitDuration(duration);
        return d[1];
    }

    public static String durationStartMonth(String duration) {
        String[] d = Dates.splitDuration(duration);
        String[] p = d[0].split("-");
        if (p.length == 3) {
            return p[1];
        }
        if (p.length == 2) {
            return p[0];
        }
        return null;
    }

    public static String durationEndMonth(String duration) {
        String[] d = Dates.splitDuration(duration);
        String[] p = d[1].split("-");
        if (p.length == 3) {
            return p[1];
        }
        if (p.length == 2) {
            return p[0];
        }
        return null;
    }

    public static int[] parseHistoricalYears(String y) {
        try {
            int y2;
            String[] parts = y.split("\\s*/\\s*");
            if (parts.length != 2) {
                throw new Exception();
            }
            int y1 = Dates.checkYear(parts[0]);
            if (y1 >= (y2 = Dates.checkYear(parts[1]))) {
                throw new Exception();
            }
            return new int[]{y1, y2};
        }
        catch (Exception E) {
            throw new IllegalArgumentException("Not a valid year range '" + y + "'");
        }
    }

    public static synchronized Date parseDate(String date) {
        try {
            Date d = YYYYMMdd.parse(date);
            String[] p = date.split("-");
            Dates.checkYear(p[0]);
            Dates.checkMonth(p[1]);
            Dates.checkDay(p[2]);
            return d;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(date);
        }
    }

    public static synchronized String today() {
        return YYYYMMdd.format(new Date());
    }

    public static synchronized String yesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(5, -1);
        return YYYYMMdd.format(cal.getTime());
    }

    public static synchronized String tomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(5, 1);
        return YYYYMMdd.format(cal.getTime());
    }

    public static Date dayBefore(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        ((Calendar)c).add(5, -1);
        return c.getTime();
    }

    public static void main(String[] args) throws ParseException {
        String test = "1981-01-01/04-31/04-30";
        Object[] date = Dates.parseESPDates(test);
        System.out.println(Arrays.toString(date));
    }
}

